/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.util;

import com.ingres.gcf.util.SqlData;
import com.ingres.gcf.util.SqlExFactory;
import java.math.BigDecimal;
import java.sql.SQLException;

public class SqlSmallInt
extends SqlData {
    private short value = 0;

    public SqlSmallInt() {
        super(true);
    }

    public SqlSmallInt(short s) {
        super(false);
        this.value = s;
    }

    public void set(short s) {
        this.setNotNull();
        this.value = s;
    }

    public void set(SqlSmallInt sqlSmallInt) {
        if (sqlSmallInt == null || sqlSmallInt.isNull()) {
            this.setNull();
        } else {
            this.setNotNull();
            this.value = sqlSmallInt.value;
        }
    }

    public short get() {
        return this.value;
    }

    @Override
    public void setBoolean(boolean bl) throws SQLException {
        this.setNotNull();
        this.value = (short)(bl ? 1 : 0);
    }

    @Override
    public void setByte(byte by) throws SQLException {
        this.setNotNull();
        this.value = by;
    }

    @Override
    public void setShort(short s) throws SQLException {
        this.setNotNull();
        this.value = s;
    }

    @Override
    public void setInt(int n) throws SQLException {
        this.setNotNull();
        this.value = (short)n;
    }

    @Override
    public void setLong(long l) throws SQLException {
        this.setNotNull();
        this.value = (short)l;
    }

    @Override
    public void setFloat(float f) throws SQLException {
        this.setNotNull();
        this.value = (short)f;
    }

    @Override
    public void setDouble(double d) throws SQLException {
        this.setNotNull();
        this.value = (short)d;
    }

    @Override
    public void setBigDecimal(BigDecimal bigDecimal) throws SQLException {
        if (bigDecimal == null) {
            this.setNull();
        } else {
            this.setNotNull();
            this.value = (short)bigDecimal.intValue();
        }
    }

    @Override
    public void setString(String string) throws SQLException {
        if (string == null) {
            this.setNull();
        } else {
            this.setNotNull();
            try {
                this.value = Short.parseShort(string.trim());
            }
            catch (NumberFormatException numberFormatException) {
                throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
            }
        }
    }

    @Override
    public boolean getBoolean() throws SQLException {
        return this.value != 0;
    }

    @Override
    public byte getByte() throws SQLException {
        return (byte)this.value;
    }

    @Override
    public short getShort() throws SQLException {
        return this.value;
    }

    @Override
    public int getInt() throws SQLException {
        return this.value;
    }

    @Override
    public long getLong() throws SQLException {
        return this.value;
    }

    @Override
    public float getFloat() throws SQLException {
        return this.value;
    }

    @Override
    public double getDouble() throws SQLException {
        return this.value;
    }

    @Override
    public BigDecimal getBigDecimal() throws SQLException {
        return BigDecimal.valueOf(this.value);
    }

    @Override
    public String getString() throws SQLException {
        return Short.toString(this.value);
    }

    @Override
    public Object getObject() throws SQLException {
        return (int)this.value;
    }
}

