/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.util;

import com.ingres.gcf.util.ByteArray;
import com.ingres.gcf.util.SqlByte;
import com.ingres.gcf.util.SqlExFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.SQLException;

public class SqlIPv6
extends SqlByte
implements ByteArray {
    public SqlIPv6() {
        super(16);
    }

    public void set(SqlIPv6 sqlIPv6) {
        if (sqlIPv6 == null || sqlIPv6.isNull()) {
            this.setNull();
        } else {
            this.clear();
            this.put(sqlIPv6.value, 0, sqlIPv6.length);
        }
    }

    @Override
    public void setString(String string) throws SQLException {
        if (string == null) {
            this.setNull();
        } else {
            InetAddress inetAddress;
            try {
                inetAddress = InetAddress.getByName(string);
            }
            catch (UnknownHostException unknownHostException) {
                throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
            }
            byte[] byArray = inetAddress.getAddress();
            if (byArray == null || byArray.length != this.limit) {
                throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
            }
            this.setBytes(byArray);
        }
    }

    @Override
    public String getString() throws SQLException {
        String string;
        this.extend();
        try {
            InetAddress inetAddress = InetAddress.getByAddress(this.value);
            string = inetAddress.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            string = super.getString();
        }
        return string;
    }

    @Override
    public String getString(int n) throws SQLException {
        return this.getString();
    }
}

