/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.util;

import com.ingres.gcf.util.ByteArray;
import com.ingres.gcf.util.SqlByte;
import com.ingres.gcf.util.SqlExFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.SQLException;

public class SqlIPv4
extends SqlByte
implements ByteArray {
    public SqlIPv4() {
        super(4);
    }

    public void set(SqlIPv4 sqlIPv4) {
        if (sqlIPv4 == null || sqlIPv4.isNull()) {
            this.setNull();
        } else {
            this.clear();
            this.put(sqlIPv4.value, 0, sqlIPv4.length);
        }
    }

    @Override
    public void setString(String string) throws SQLException {
        if (string == null) {
            this.setNull();
        } else {
            InetAddress inetAddress;
            try {
                inetAddress = InetAddress.getByName(string);
            }
            catch (UnknownHostException unknownHostException) {
                throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
            }
            byte[] byArray = inetAddress.getAddress();
            if (byArray == null || byArray.length != this.limit) {
                throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
            }
            this.setBytes(byArray);
        }
    }

    @Override
    public String getString() throws SQLException {
        String string;
        this.extend();
        try {
            InetAddress inetAddress = InetAddress.getByAddress(this.value);
            string = inetAddress.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            string = super.getString();
        }
        return string;
    }

    @Override
    public String getString(int n) throws SQLException {
        return this.getString();
    }
}

