/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.dam;

import com.ingres.gcf.dam.IoBuff;
import com.ingres.gcf.util.ByteArray;
import com.ingres.gcf.util.CharSet;
import com.ingres.gcf.util.GcfErr;
import com.ingres.gcf.util.IdMap;
import com.ingres.gcf.util.SqlExFactory;
import com.ingres.gcf.util.Trace;
import com.ingres.gcf.util.TraceLog;
import com.ingres.gcf.util.Tracing;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.concurrent.Executor;

class InBuff
extends IoBuff
implements GcfErr {
    protected Trace trace;

    public InBuff(InputStream inputStream, int n, int n2, TraceLog traceLog) {
        super(inputStream, traceLog);
        this.title = "InBuff[" + n + "]";
        this.trace = new Tracing(traceLog, "msg.tl");
        this.setBuffSize(n2);
    }

    public Executor getTimeoutExecutor() {
        return this.timeoutExecutor;
    }

    public void setTimeoutAction(Executor executor, Runnable runnable) {
        this.timeoutExecutor = executor;
        this.timeoutAction = runnable;
    }

    public short receive() throws SQLException {
        super.next();
        int n = this.readInt();
        if (this.proto_lvl <= 1 && n != 1280590666 || this.proto_lvl >= 2 && n != 1280593220) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.title + ": invalid TL header ID");
            }
            this.close();
            throw SqlExFactory.get(ERR_GC4002_PROTOCOL_ERR);
        }
        short s = this.readShort();
        if (this.trace.enabled(2)) {
            this.trace.write(this.title + ": receive TL packet " + IdMap.map(s, tlMap));
        }
        if (this.trace.enabled(3)) {
            this.trace.write(this.title + ": length " + this.avail());
        }
        return s;
    }

    public int avail() {
        return this.data_end - this.data_ptr;
    }

    public byte readByte() throws SQLException {
        this.need(1, true);
        return this.buffer[this.data_ptr++];
    }

    public short readShort() throws SQLException {
        this.need(2, true);
        return (short)(this.buffer[this.data_ptr++] & 0xFF | this.buffer[this.data_ptr++] << 8 & 0xFF00);
    }

    public int readInt() throws SQLException {
        this.need(4, true);
        return this.buffer[this.data_ptr++] & 0xFF | this.buffer[this.data_ptr++] << 8 & 0xFF00 | this.buffer[this.data_ptr++] << 16 & 0xFF0000 | this.buffer[this.data_ptr++] << 24 & 0xFF000000;
    }

    public long readLong() throws SQLException {
        this.need(8, true);
        return (long)this.buffer[this.data_ptr++] & 0xFFL | (long)this.buffer[this.data_ptr++] << 8 & 0xFF00L | (long)this.buffer[this.data_ptr++] << 16 & 0xFF0000L | (long)this.buffer[this.data_ptr++] << 24 & 0xFF000000L | (long)this.buffer[this.data_ptr++] << 32 & 0xFF00000000L | (long)this.buffer[this.data_ptr++] << 40 & 0xFF0000000000L | (long)this.buffer[this.data_ptr++] << 48 & 0xFF000000000000L | (long)this.buffer[this.data_ptr++] << 56 & 0xFF00000000000000L;
    }

    public float readFloat() throws SQLException {
        float f = Float.NaN;
        this.need(6, true);
        byte by = (byte)(this.buffer[this.data_ptr + 1] >>> 7 & 1);
        short s = (short)(this.buffer[this.data_ptr + 1] << 8 & 0x7F00 | this.buffer[this.data_ptr + 0] & 0xFF);
        int n = this.buffer[this.data_ptr + 3] << 24 & 0xFF000000 | this.buffer[this.data_ptr + 2] << 16 & 0xFF0000 | this.buffer[this.data_ptr + 5] << 8 & 0xFF00 | this.buffer[this.data_ptr + 4] & 0xFF;
        this.data_ptr += 6;
        if (s != 0) {
            s = (short)(s - 16256);
        }
        if (s < 0 || s > 255) {
            f = by != 0 ? Float.MIN_VALUE : Float.MAX_VALUE;
        } else {
            int n2 = by << 31 & Integer.MIN_VALUE | s << 23 & 0x7F800000 | n >>> 9 & 0x7FFFFF;
            f = Float.intBitsToFloat(n2);
        }
        return f;
    }

    public double readDouble() throws SQLException {
        double d = Double.NaN;
        this.need(10, true);
        byte by = (byte)(this.buffer[this.data_ptr + 1] >>> 7 & 1);
        short s = (short)(this.buffer[this.data_ptr + 1] << 8 & 0x7F00 | this.buffer[this.data_ptr + 0] & 0xFF);
        long l = (long)this.buffer[this.data_ptr + 3] << 56 & 0xFF00000000000000L | (long)this.buffer[this.data_ptr + 2] << 48 & 0xFF000000000000L | (long)this.buffer[this.data_ptr + 5] << 40 & 0xFF0000000000L | (long)this.buffer[this.data_ptr + 4] << 32 & 0xFF00000000L | (long)this.buffer[this.data_ptr + 7] << 24 & 0xFF000000L | (long)this.buffer[this.data_ptr + 6] << 16 & 0xFF0000L | (long)this.buffer[this.data_ptr + 9] << 8 & 0xFF00L | (long)this.buffer[this.data_ptr + 8] & 0xFFL;
        this.data_ptr += 10;
        if (s != 0) {
            s = (short)(s - 15360);
        }
        if (s < 0 || s > 2047) {
            d = by != 0 ? Double.MIN_VALUE : Double.MAX_VALUE;
        } else {
            long l2 = (long)by << 63 & Long.MIN_VALUE | (long)s << 52 & 0x7FF0000000000000L | l >>> 12 & 0xFFFFFFFFFFFFFL;
            d = Double.longBitsToDouble(l2);
        }
        return d;
    }

    public int readBytes(byte[] byArray, int n, int n2) throws SQLException {
        this.need(n2, false);
        n2 = Math.min(n2, this.avail());
        System.arraycopy(this.buffer, this.data_ptr, byArray, n, n2);
        this.data_ptr += n2;
        return n2;
    }

    public int readBytes(ByteArray byteArray, int n) throws SQLException {
        this.need(n, false);
        n = Math.min(n, this.avail());
        byteArray.put(this.buffer, this.data_ptr, n);
        this.data_ptr += n;
        return n;
    }

    public String readString(int n, CharSet charSet) throws SQLException {
        String string;
        this.need(n, true);
        try {
            string = charSet.getString(this.buffer, this.data_ptr, n);
        }
        catch (Exception exception) {
            throw SqlExFactory.get(ERR_GC401E_CHAR_ENCODE);
        }
        this.data_ptr += n;
        return string;
    }

    public int skip(int n) throws SQLException {
        this.need(n, false);
        n = Math.min(n, this.avail());
        this.data_ptr += n;
        return n;
    }

    private void need(int n, boolean bl) throws SQLException {
        int n2;
        while ((n2 = this.avail()) < n) {
            if (n2 > 0) {
                if (!bl) break;
                if (this.trace.enabled(1)) {
                    this.trace.write(this.title + ": atomic value split (" + n2 + "," + n + ")");
                }
                this.close();
                throw SqlExFactory.get(ERR_GC4002_PROTOCOL_ERR);
            }
            short s = this.receive();
            if (s == 21572) continue;
            if (this.trace.enabled(1)) {
                this.trace.write(this.title + ": invalid TL packet ID 0x" + Integer.toHexString(s));
            }
            this.close();
            throw SqlExFactory.get(ERR_GC4002_PROTOCOL_ERR);
        }
        if (this.trace.enabled(4)) {
            if (n2 < n) {
                this.trace.write(this.title + ": reading " + n2 + " (" + n + " requested)");
            } else {
                this.trace.write(this.title + ": reading " + n);
            }
        }
    }
}

