/*
 * Decompiled with CFR 0.152.
 */
package bpm.mdm.remote.test;

import bpm.mdm.model.Attribute;
import bpm.mdm.model.Entity;
import bpm.mdm.model.runtime.Row;
import bpm.mdm.model.runtime.RuntimeFactory;
import bpm.mdm.model.runtime.exception.RowsExceptionHolder;
import bpm.mdm.model.storage.IEntityStorage;
import bpm.mdm.remote.MdmRemote;
import bpm.mdm.remote.StoreReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class TestConcurrency {
    public static void main(String[] args) {
        try {
            MdmRemote api = new MdmRemote("system", "system", "http://localhost:9191", null, null);
            api.loadModel();
            MdmRemote api2 = new MdmRemote("system", "system", "http://localhost:9191", null, null);
            Entity prod = null;
            Attribute id = null;
            Attribute name = null;
            Attribute price = null;
            for (Entity e : api.getModel().getEntities()) {
                if (!e.getName().equals("produits")) continue;
                prod = e;
                for (Attribute a : e.getAttributes()) {
                    if (a.getName().equals("id")) {
                        id = a;
                        continue;
                    }
                    if (a.getName().equals("nom")) {
                        name = a;
                        continue;
                    }
                    if (!a.getName().equals("prix d'achat")) continue;
                    price = a;
                }
            }
            ArrayList<Row> l1 = new ArrayList<Row>();
            Row r = RuntimeFactory.eINSTANCE.createRow();
            r.setValue(id, (Object)"1");
            r.setValue(name, (Object)"P1");
            r.setValue(price, (Object)1);
            l1.add(r);
            r = RuntimeFactory.eINSTANCE.createRow();
            r.setValue(id, (Object)"2");
            r.setValue(name, (Object)"P1");
            r.setValue(price, (Object)2);
            l1.add(r);
            r = RuntimeFactory.eINSTANCE.createRow();
            r.setValue(id, (Object)"3");
            r.setValue(name, (Object)"P1");
            r.setValue(price, (Object)3);
            l1.add(r);
            ArrayList<Row> l2 = new ArrayList<Row>();
            r = RuntimeFactory.eINSTANCE.createRow();
            r.setValue(id, (Object)"1");
            r.setValue(name, (Object)"P2");
            r.setValue(price, (Object)1);
            l2.add(r);
            r = RuntimeFactory.eINSTANCE.createRow();
            r.setValue(id, (Object)"2");
            r.setValue(name, (Object)"P2");
            r.setValue(price, (Object)2);
            l2.add(r);
            r = RuntimeFactory.eINSTANCE.createRow();
            r.setValue(id, (Object)"3");
            r.setValue(name, (Object)"P2");
            r.setValue(price, (Object)3);
            l2.add(r);
            Saver s1 = new Saver(api.getStore(prod), l1);
            Saver s2 = new Saver(api2.getStore(prod), l2);
            Loader load1 = new Loader(api.createStoreReader(prod), prod, "reader1");
            s1.start();
            load1.start();
            s2.start();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static class Loader
    extends Thread {
        StoreReader reader;
        Entity entity;
        String thIde;

        Loader(StoreReader reader, Entity entity, String thIde) {
            this.reader = reader;
            this.entity = entity;
            this.thIde = thIde;
        }

        @Override
        public void run() {
            try {
                try {
                    Thread.sleep(1000L);
                    this.reader.open();
                    while (this.reader.hasNext()) {
                        Row r = this.reader.next();
                        StringBuilder b = new StringBuilder();
                        b.append(String.valueOf(this.thIde) + ":");
                        for (Attribute a : this.entity.getAttributes()) {
                            b.append("\t");
                            b.append("" + r.getValue(a));
                        }
                        System.out.println(b.toString());
                    }
                }
                catch (Exception ex) {
                    Logger.getLogger(this.getClass()).error((Object)("Could not open StoreReader - " + ex.getMessage()), (Throwable)ex);
                    try {
                        this.reader.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return;
                }
            }
            finally {
                try {
                    this.reader.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static class Saver
    extends Thread {
        IEntityStorage store;
        List<Row> rows;

        Saver(IEntityStorage store, List<Row> rows) {
            this.store = store;
            this.rows = rows;
        }

        @Override
        public void run() {
            System.out.println(String.valueOf(this.getName()) + " start");
            for (Row r : this.rows) {
                try {
                    this.store.createRow(r);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.err.println(String.valueOf(this.getName()) + " canceled");
                }
                System.out.println(String.valueOf(this.getName()) + " row created");
                try {
                    System.out.println(String.valueOf(this.getName()) + " flushing");
                    this.store.flush();
                    System.out.println(String.valueOf(this.getName()) + " flushed");
                }
                catch (RowsExceptionHolder rowsExceptionHolder) {
                    System.out.println(String.valueOf(this.getName()) + " flushed rows exceptions");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.out.println(String.valueOf(this.getName()) + " flushed failed");
                }
                try {
                    Thread.sleep(Double.valueOf(Math.random() * 5000.0).longValue());
                }
                catch (Exception exception) {}
            }
            System.out.println(String.valueOf(this.getName()) + " end");
        }
    }
}

