/*
 * Decompiled with CFR 0.152.
 */
package bpm.mdm.remote;

import bpm.mdm.model.Entity;
import bpm.mdm.model.api.IEntityReader;
import bpm.mdm.model.api.IMdmProvider;
import bpm.mdm.model.runtime.Row;
import bpm.mdm.model.serialisation.DatasSerializer;
import bpm.mdm.model.serialisation.MdmConfiguration;
import bpm.mdm.remote.HttpRemote;
import bpm.vanilla.platform.core.xstream.IXmlActionType;
import bpm.vanilla.platform.core.xstream.XmlAction;
import bpm.vanilla.platform.core.xstream.XmlArgumentsHolder;
import com.thoughtworks.xstream.XStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;

public class StoreReader
implements IEntityReader {
    private int chunkNumber = -1;
    private List<Row> rows;
    private Iterator<Row> iterator;
    private HttpRemote http;
    private Entity entity;
    private XStream xstream;

    protected StoreReader(Entity entity, HttpRemote http, XStream xstream) {
        this.entity = entity;
        this.http = http;
        this.xstream = xstream;
    }

    public void open() throws Exception {
        if (this.chunkNumber >= 0) {
            throw new Exception("Cannot open a StoreReader more tahn once");
        }
        this.readNextChunk();
    }

    private void isOpen() throws Exception {
        if (this.rows == null || this.iterator == null) {
            throw new Exception("The reader has not been opened");
        }
    }

    public boolean hasNext() throws Exception {
        this.isOpen();
        if (this.chunkNumber < 0) {
            return false;
        }
        if (!this.iterator.hasNext()) {
            try {
                return this.readNextChunk();
            }
            catch (Exception e) {
                Logger.getLogger(this.getClass()).warn((Object)e.getMessage(), (Throwable)e);
                this.releaseResources();
                return false;
            }
        }
        return true;
    }

    public Row next() throws Exception {
        this.isOpen();
        return this.iterator.next();
    }

    private void releaseResources() {
        this.chunkNumber = -1;
        if (this.rows != null) {
            this.rows.clear();
        }
        this.rows = null;
        this.iterator = null;
    }

    private boolean readNextChunk() throws Exception {
        ++this.chunkNumber;
        XmlAction op = new XmlAction(this.createArguments(this.entity.getName(), this.chunkNumber), (IXmlActionType)IMdmProvider.ActionType.GET_ENTITY_DATAS);
        String xml = this.http.executeDatasAction(this.xstream.toXML((Object)op));
        if (xml.isEmpty()) {
            return false;
        }
        byte[] bytes = xml.getBytes();
        DatasSerializer s = new DatasSerializer(new MdmConfiguration());
        List l = s.loadDatas(this.entity, (InputStream)new ByteArrayInputStream(Base64.decodeBase64((byte[])bytes)));
        this.rows = s.convert(this.entity, l);
        this.iterator = this.rows.iterator();
        return true;
    }

    private XmlArgumentsHolder createArguments(Object ... arguments) {
        XmlArgumentsHolder args = new XmlArgumentsHolder();
        int i = 0;
        while (i < arguments.length) {
            args.addArgument(arguments[i]);
            ++i;
        }
        return args;
    }

    public void close() throws Exception {
        this.isOpen();
        this.releaseResources();
    }
}

