/*
 * Decompiled with CFR 0.152.
 */
package bpm.mdm.remote;

import bpm.mdm.model.Attribute;
import bpm.mdm.model.Entity;
import bpm.mdm.model.api.IMdmProvider;
import bpm.mdm.model.runtime.Row;
import bpm.mdm.model.runtime.exception.AbstractRowException;
import bpm.mdm.model.runtime.exception.NonExistingChunkFileException;
import bpm.mdm.model.runtime.exception.RowsExceptionHolder;
import bpm.mdm.model.serialisation.DatasSerializer;
import bpm.mdm.model.serialisation.MdmConfiguration;
import bpm.mdm.model.storage.EntityStorageStatistics;
import bpm.mdm.model.storage.IEntityStorage;
import bpm.mdm.remote.HttpRemote;
import bpm.vanilla.platform.core.xstream.IXmlActionType;
import bpm.vanilla.platform.core.xstream.XmlAction;
import bpm.vanilla.platform.core.xstream.XmlArgumentsHolder;
import com.thoughtworks.xstream.XStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.codec.binary.Base64;

public class RemoteStore
implements IEntityStorage {
    private List<Row> toAdd = new ArrayList<Row>();
    private List<Row> toUpdate = new ArrayList<Row>();
    private List<Row> toDelete = new ArrayList<Row>();
    private HttpRemote http;
    private Entity entity;
    private XStream xstream;

    protected RemoteStore(Entity entity, HttpRemote http, XStream xstream) {
        this.entity = entity;
        this.http = http;
        this.xstream = xstream;
    }

    public void cancel() throws Exception {
        this.toDelete.clear();
        this.toUpdate.clear();
        this.toAdd.clear();
    }

    public void createRow(Row row) throws Exception {
        this.toAdd.add(row);
    }

    public void deleteRow(Row row) throws Exception {
        this.toDelete.add(row);
    }

    private List<AbstractRowException> getExceptions(String xmlResult) throws Exception {
        Object o;
        ArrayList<AbstractRowException> rowsErrors = new ArrayList<AbstractRowException>();
        if (xmlResult != null && !xmlResult.isEmpty() && (o = this.xstream.fromXML(xmlResult)) instanceof List) {
            for (Object e : (List)o) {
                if (!(e instanceof AbstractRowException)) continue;
                rowsErrors.add((AbstractRowException)e);
            }
        }
        return rowsErrors;
    }

    public void flush() throws Exception {
        List<Row> failedRows;
        List<AbstractRowException> rowExceptions;
        String res;
        XmlAction op;
        byte[] bytes;
        ArrayList<AbstractRowException> rowsErrors = new ArrayList<AbstractRowException>();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DatasSerializer s = new DatasSerializer(new MdmConfiguration());
        if (!this.toAdd.isEmpty()) {
            s.saveDatas(this.entity, s.convertToSerializable(this.entity, this.toAdd), (OutputStream)bos);
            bytes = Base64.encodeBase64((byte[])bos.toByteArray());
            op = new XmlAction(this.createArguments(this.entity.getName(), bytes), (IXmlActionType)IMdmProvider.ActionType.SAVE_DATAS);
            res = null;
            try {
                res = this.http.executeDatasAction(this.xstream.toXML((Object)op));
            }
            catch (Exception ex) {
                throw new Exception("Communication error : " + ex.getMessage(), ex);
            }
            rowExceptions = this.getExceptions(res);
            rowsErrors.addAll(rowExceptions);
            failedRows = this.retrieveFailedRows(this.toAdd, rowExceptions);
            this.toAdd.clear();
            this.toAdd.addAll(failedRows);
        }
        if (!this.toUpdate.isEmpty()) {
            bos = new ByteArrayOutputStream();
            s.saveDatas(this.entity, s.convertToSerializable(this.entity, this.toUpdate), (OutputStream)bos);
            bytes = Base64.encodeBase64((byte[])bos.toByteArray());
            op = new XmlAction(this.createArguments(this.entity.getName(), bytes), (IXmlActionType)IMdmProvider.ActionType.UPDATE_DATAS);
            res = null;
            try {
                res = this.http.executeDatasAction(this.xstream.toXML((Object)op));
            }
            catch (Exception ex) {
                throw new Exception("Communication error : " + ex.getMessage(), ex);
            }
            rowExceptions = this.getExceptions(res);
            rowsErrors.addAll(rowExceptions);
            failedRows = this.retrieveFailedRows(this.toUpdate, rowExceptions);
            this.toUpdate.clear();
            this.toUpdate.addAll(failedRows);
        }
        if (!this.toDelete.isEmpty()) {
            bos = new ByteArrayOutputStream();
            s.saveDatas(this.entity, s.convertToSerializable(this.entity, this.toDelete), (OutputStream)bos);
            bytes = Base64.encodeBase64((byte[])bos.toByteArray());
            op = new XmlAction(this.createArguments(this.entity.getName(), bytes), (IXmlActionType)IMdmProvider.ActionType.DELETE_DATAS);
            res = null;
            try {
                res = this.http.executeDatasAction(this.xstream.toXML((Object)op));
            }
            catch (Exception ex) {
                throw new Exception("Communication error : " + ex.getMessage(), ex);
            }
            rowExceptions = this.getExceptions(res);
            rowsErrors.addAll(rowExceptions);
            failedRows = this.retrieveFailedRows(this.toDelete, rowExceptions);
            this.toDelete.clear();
            this.toDelete.addAll(failedRows);
        }
        if (!rowsErrors.isEmpty()) {
            throw new RowsExceptionHolder(rowsErrors);
        }
    }

    private List<Row> retrieveFailedRows(List<Row> flushed, List<AbstractRowException> rowExceptions) {
        ArrayList<Row> failedRows = new ArrayList<Row>();
        for (Row r : flushed) {
            for (AbstractRowException e : rowExceptions) {
                boolean equals = true;
                for (Attribute a : this.entity.getAttributes()) {
                    if (e.getRow().getValue(a) == null && r.getValue(a) != null) {
                        equals = false;
                        break;
                    }
                    if (r.getValue(a) == null && e.getRow().getValue(a) != null) {
                        if (!a.isNullAllowed()) continue;
                        equals = false;
                        break;
                    }
                    if (r.getValue(a) == null || e.getRow().getValue(a) == null || r.getValue(a).equals(e.getRow().getValue(a))) continue;
                    equals = false;
                    break;
                }
                if (!equals) continue;
                failedRows.add(r);
                e.setRow(r);
            }
        }
        return failedRows;
    }

    public List<Row> getRows(int chunkNumber) throws NonExistingChunkFileException, Exception {
        XmlAction op = new XmlAction(this.createArguments(this.entity.getName(), chunkNumber), (IXmlActionType)IMdmProvider.ActionType.GET_ENTITY_DATAS);
        String xml = this.http.executeDatasAction(this.xstream.toXML((Object)op));
        if (xml.isEmpty()) {
            return new ArrayList<Row>();
        }
        byte[] bytes = xml.getBytes();
        if (bytes == null || bytes.length == 0) {
            throw new NonExistingChunkFileException("Chunk " + chunkNumber + " does not exist on " + this.entity.getName());
        }
        DatasSerializer s = new DatasSerializer(new MdmConfiguration());
        List l = s.loadDatas(this.entity, (InputStream)new ByteArrayInputStream(Base64.decodeBase64((byte[])bytes)));
        return s.convert(this.entity, l);
    }

    public void updateRow(Row row) throws Exception {
        this.toUpdate.add(row);
    }

    private XmlArgumentsHolder createArguments(Object ... arguments) {
        XmlArgumentsHolder args = new XmlArgumentsHolder();
        int i = 0;
        while (i < arguments.length) {
            args.addArgument(arguments[i]);
            ++i;
        }
        return args;
    }

    public Row lookup(Row row) throws Exception {
        HashMap<String, Object> primaryKey = new HashMap<String, Object>();
        for (Attribute a : this.entity.getAttributesId()) {
            primaryKey.put(a.getUuid(), row.getValue(a));
        }
        if (primaryKey.size() == 0) {
            throw new Exception("Cannot perform a lookup on the Entity " + this.entity.getName() + " because it has no Identifier Attribute");
        }
        XmlAction op = new XmlAction(this.createArguments(this.entity.getUuid(), primaryKey), (IXmlActionType)IMdmProvider.ActionType.LOOKUP);
        String xml = this.http.executeDatasAction(this.xstream.toXML((Object)op));
        if (xml.isEmpty()) {
            return null;
        }
        byte[] bytes = xml.getBytes();
        DatasSerializer s = new DatasSerializer(new MdmConfiguration());
        List l = s.loadDatas(this.entity, (InputStream)new ByteArrayInputStream(Base64.decodeBase64((byte[])bytes)));
        List r = s.convert(this.entity, l);
        return (Row)r.get(0);
    }

    public AbstractRowException.OperationType getType(Row row) {
        if (this.toAdd.contains(row)) {
            return AbstractRowException.OperationType.CREATE;
        }
        if (this.toDelete.contains(row)) {
            return AbstractRowException.OperationType.DELETE;
        }
        if (this.toUpdate.contains(row)) {
            return AbstractRowException.OperationType.UPDATE;
        }
        return null;
    }

    public void cancel(Row row) {
        this.toAdd.remove(row);
        this.toDelete.remove(row);
        this.toUpdate.remove(row);
    }

    public EntityStorageStatistics getStorageStatistics() throws Exception {
        XmlAction op = new XmlAction(this.createArguments(this.entity.getName()), (IXmlActionType)IMdmProvider.ActionType.GET_STORE_STATISTICS);
        String res = null;
        try {
            res = this.http.executeDatasAction(this.xstream.toXML((Object)op));
        }
        catch (Exception ex) {
            throw new Exception("Communication error : " + ex.getMessage(), ex);
        }
        Object o = this.xstream.fromXML(res);
        if (o instanceof Exception) {
            throw (Exception)o;
        }
        return (EntityStorageStatistics)o;
    }

    public List<Row> getInvalidRows() throws Exception {
        XmlAction op = new XmlAction(this.createArguments(this.entity.getUuid()), (IXmlActionType)IMdmProvider.ActionType.GET_INVALID_ROWS);
        String xml = this.http.executeDatasAction(this.xstream.toXML((Object)op));
        if (xml.isEmpty()) {
            return null;
        }
        byte[] bytes = xml.getBytes();
        DatasSerializer s = new DatasSerializer(new MdmConfiguration());
        List l = s.loadDatas(this.entity, (InputStream)new ByteArrayInputStream(Base64.decodeBase64((byte[])bytes)));
        List r = s.convert(this.entity, l);
        return r;
    }
}

