/*
 * Decompiled with CFR 0.152.
 */
package bpm.mdm.remote;

import bpm.mdm.model.Entity;
import bpm.mdm.model.Model;
import bpm.mdm.model.api.IMdmProvider;
import bpm.mdm.model.serialisation.EMFSerializer;
import bpm.mdm.model.serialisation.MdmConfiguration;
import bpm.mdm.model.storage.IEntityStorage;
import bpm.mdm.model.supplier.Contract;
import bpm.mdm.model.supplier.DocumentItem;
import bpm.mdm.model.supplier.MdmDirectory;
import bpm.mdm.model.supplier.Supplier;
import bpm.mdm.remote.HttpRemote;
import bpm.mdm.remote.RemoteStore;
import bpm.mdm.remote.StoreReader;
import bpm.vanilla.platform.core.IRepositoryContext;
import bpm.vanilla.platform.core.beans.DataSort;
import bpm.vanilla.platform.core.beans.DataWithCount;
import bpm.vanilla.platform.core.beans.Group;
import bpm.vanilla.platform.core.beans.User;
import bpm.vanilla.platform.core.beans.resources.ContractIntegrationInformations;
import bpm.vanilla.platform.core.beans.resources.ContractType;
import bpm.vanilla.platform.core.beans.resources.DocumentSchema;
import bpm.vanilla.platform.core.xstream.IXmlActionType;
import bpm.vanilla.platform.core.xstream.XmlAction;
import bpm.vanilla.platform.core.xstream.XmlArgumentsHolder;
import com.thoughtworks.xstream.XStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EContentAdapter;

public class MdmRemote
implements IMdmProvider {
    private static XStream xstream;
    private HttpRemote http = new HttpRemote();
    private Model model;
    private EContentAdapter collectionsListeners;
    private Adapter propertyAdapter;
    private HashMap<Entity, IEntityStorage> stores = new HashMap();

    static {
        MdmRemote.init();
    }

    public MdmRemote(String login, String password, String vanillaUrl) {
        this.http.init(vanillaUrl, login, password);
        MdmRemote.init();
    }

    public MdmRemote(String login, String password, String vanillaUrl, Adapter propertyAdapter, EContentAdapter collectionsListeners) {
        this.collectionsListeners = collectionsListeners;
        this.propertyAdapter = propertyAdapter;
        this.http.init(vanillaUrl, login, password);
        MdmRemote.init();
    }

    private XmlArgumentsHolder createArguments(Object ... arguments) {
        XmlArgumentsHolder args = new XmlArgumentsHolder();
        int i = 0;
        while (i < arguments.length) {
            args.addArgument(arguments[i]);
            ++i;
        }
        return args;
    }

    private static void init() {
        xstream = new XStream();
    }

    public Model getModel() {
        return this.model;
    }

    public void persistModel(Model model) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = null;){
            try {
                EMFSerializer s = new EMFSerializer(new MdmConfiguration());
                s.save((OutputStream)bos, model);
            }
            catch (Exception ex) {
                throw new Exception("Could not serialize Object Model - " + ex.getMessage(), ex);
            }
        }
        byte[] bytes = new Base64().encode(bos.toByteArray());
        XmlAction op = new XmlAction(this.createArguments(new Object[]{bytes}), (IXmlActionType)IMdmProvider.ActionType.UPDATE_MODEL);
        String xml = this.http.executeModelAction(xstream.toXML((Object)op));
        try {
            Object res = xstream.fromXML(xml);
            if (res != null) {
                if (res == Boolean.TRUE) {
                    return;
                }
                if (res instanceof Exception) {
                    throw (Exception)res;
                }
            }
        }
        catch (Exception ex) {
            throw new Exception("Unable to parse server response - " + ex.getMessage(), ex);
        }
    }

    public Model loadModel() throws Exception {
        if (this.model != null) {
            this.attachListeners((EObject)this.model, false);
        }
        try {
            XmlAction op = new XmlAction(this.createArguments(new Object[0]), (IXmlActionType)IMdmProvider.ActionType.GET_MODEL);
            String xml = this.http.executeModelAction(xstream.toXML((Object)op));
            EMFSerializer s = new EMFSerializer(new MdmConfiguration());
            this.model = s.loadModel((InputStream)new ByteArrayInputStream(xml.getBytes("UTF-8")));
            this.attachListeners((EObject)this.model, true);
            return this.model;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            throw new Exception(ex.getMessage(), ex);
        }
    }

    private void attachListeners(EObject object, boolean add) {
        if (this.collectionsListeners != null && this.propertyAdapter != null) {
            if (object instanceof EList) {
                if (add) {
                    object.eAdapters().add((Object)this.collectionsListeners);
                } else {
                    object.eAdapters().remove((Object)this.collectionsListeners);
                }
            } else if (add) {
                object.eAdapters().add((Object)this.propertyAdapter);
            } else {
                object.eAdapters().remove((Object)this.propertyAdapter);
            }
        }
        for (EObject child : object.eContents()) {
            this.attachListeners(child, add);
        }
    }

    public IEntityStorage getStore(Entity entity) {
        if (this.stores.get(entity) == null) {
            RemoteStore rm = new RemoteStore(entity, this.http, xstream);
            this.stores.put(entity, rm);
        }
        return this.stores.get(entity);
    }

    public StoreReader createStoreReader(Entity entity) {
        StoreReader reader = new StoreReader(entity, this.http, xstream);
        return reader;
    }

    public Contract addContract(Contract contract) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(contract), (IXmlActionType)IMdmProvider.ActionType.ADD_CONTRACT);
        String xml = this.http.executeModelAction(xstream.toXML((Object)op));
        return (Contract)xstream.fromXML(xml);
    }

    public void addSecuredSupplier(int supplierId, int groupId) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(supplierId, groupId), (IXmlActionType)IMdmProvider.ActionType.ADD_SECURITY);
        this.http.executeModelAction(xstream.toXML((Object)op));
    }

    public Supplier addSupplier(Supplier supplier) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(supplier), (IXmlActionType)IMdmProvider.ActionType.ADD_SUPPLIER);
        String xml = this.http.executeModelAction(xstream.toXML((Object)op));
        return (Supplier)xstream.fromXML(xml);
    }

    public List<Supplier> getSuppliers() throws Exception {
        XmlAction op = new XmlAction(this.createArguments(new Object[0]), (IXmlActionType)IMdmProvider.ActionType.GET_SUPPLIERS);
        String xml = this.http.executeModelAction(xstream.toXML((Object)op));
        List model = (List)xstream.fromXML(xml);
        return model;
    }

    public List<Supplier> getSuppliersByGroupId(int groupId) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(groupId), (IXmlActionType)IMdmProvider.ActionType.GET_SUPPLIERS);
        String xml = this.http.executeModelAction(xstream.toXML((Object)op));
        List model = (List)xstream.fromXML(xml);
        return model;
    }

    public void removeContract(Contract contract) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(contract), (IXmlActionType)IMdmProvider.ActionType.REMOVE_CONTRACT);
        this.http.executeModelAction(xstream.toXML((Object)op));
    }

    public void removeSupplier(Supplier supplier) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(supplier), (IXmlActionType)IMdmProvider.ActionType.REMOVE_SUPPLIER);
        this.http.executeModelAction(xstream.toXML((Object)op));
    }

    public List<Supplier> saveSuppliers(List<Supplier> suppliers) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(suppliers), (IXmlActionType)IMdmProvider.ActionType.SAVE_SUPPLIERS);
        String xml = this.http.executeModelAction(xstream.toXML((Object)op));
        List model = (List)xstream.fromXML(xml);
        return model;
    }

    public Supplier addSupplier(Supplier supplier, List<Group> groups) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(supplier, groups), (IXmlActionType)IMdmProvider.ActionType.ADD_SUPPLIER);
        String xml = this.http.executeModelAction(xstream.toXML((Object)op));
        return (Supplier)xstream.fromXML(xml);
    }

    public List<Integer> getSupplierSecurity(Integer id) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(id), (IXmlActionType)IMdmProvider.ActionType.GET_SUPPLIER_SECURITY);
        String xml = this.http.executeModelAction(xstream.toXML((Object)op));
        List model = (List)xstream.fromXML(xml);
        return model;
    }

    public void saveOrUpdateDocumentItem(DocumentItem docItem) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(docItem), (IXmlActionType)IMdmProvider.ActionType.ADD_DOCUMENT_ITEM);
        this.http.executeModelAction(xstream.toXML((Object)op));
    }

    public void removeDocumentItem(DocumentItem docItem) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(docItem), (IXmlActionType)IMdmProvider.ActionType.REMOVE_DOCUMENT_ITEM);
        this.http.executeModelAction(xstream.toXML((Object)op));
    }

    public List<DocumentItem> getDocumentItems(int contractId) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(contractId), (IXmlActionType)IMdmProvider.ActionType.GED_DOCUMENT_ITEMS);
        String xml = this.http.executeModelAction(xstream.toXML((Object)op));
        return (List)xstream.fromXML(xml);
    }

    public Contract getContract(int contractId) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(contractId), (IXmlActionType)IMdmProvider.ActionType.GET_CONTRACT);
        String xml = this.http.executeModelAction(xstream.toXML((Object)op));
        return (Contract)xstream.fromXML(xml);
    }

    public void launchAssociatedItems(int contractId, IRepositoryContext repositoryContext, User user) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(contractId, repositoryContext, user), (IXmlActionType)IMdmProvider.ActionType.LAUNCH_ASSOCIATED_ITEMS);
        this.http.executeModelAction(xstream.toXML((Object)op));
    }

    public DataWithCount<Contract> getContracts(Integer directoryId, Integer groupId, String query, int firstResult, int length, DataSort sort) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(directoryId, groupId, query, firstResult, length, sort), (IXmlActionType)IMdmProvider.ActionType.GET_CONTRACTS_BY_DIRECTORY);
        String xml = this.http.executeModelAction(xstream.toXML((Object)op));
        return (DataWithCount)xstream.fromXML(xml);
    }

    public MdmDirectory saveOrUpdateDirectory(MdmDirectory directory) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(directory), (IXmlActionType)IMdmProvider.ActionType.SAVE_DIRECTORY);
        String xml = this.http.executeModelAction(xstream.toXML((Object)op));
        return (MdmDirectory)xstream.fromXML(xml);
    }

    public void removeDirectory(MdmDirectory directory) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(directory), (IXmlActionType)IMdmProvider.ActionType.REMOVE_DIRECTORY);
        this.http.executeModelAction(xstream.toXML((Object)op));
    }

    public List<MdmDirectory> getDirectories(Integer parentId, boolean includeSubdirectories) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(parentId, includeSubdirectories), (IXmlActionType)IMdmProvider.ActionType.GET_DIRECTORIES);
        String xml = this.http.executeModelAction(xstream.toXML((Object)op));
        return (List)xstream.fromXML(xml);
    }

    public List<ContractIntegrationInformations> getIntegrationsInfosByContract(Integer directoryId) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(directoryId), (IXmlActionType)IMdmProvider.ActionType.GET_INTEGRATIONS_INFOS_BY_CONTRACT);
        String xml = this.http.executeModelAction(xstream.toXML((Object)op));
        return xml != null && !xml.isEmpty() ? (List)xstream.fromXML(xml) : null;
    }

    public ContractIntegrationInformations getIntegrationInfosByContract(int contractId) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(contractId), (IXmlActionType)IMdmProvider.ActionType.GET_INTEGRATION_INFOS_BY_CONTRACT);
        String xml = this.http.executeModelAction(xstream.toXML((Object)op));
        return xml != null && !xml.isEmpty() ? (ContractIntegrationInformations)xstream.fromXML(xml) : null;
    }

    public ContractIntegrationInformations getIntegrationInfosByLimesurvey(String limesurveyId) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(limesurveyId), (IXmlActionType)IMdmProvider.ActionType.GET_INTEGRATION_INFOS_BY_LIMESURVEY);
        String xml = this.http.executeModelAction(xstream.toXML((Object)op));
        return xml != null && !xml.isEmpty() ? (ContractIntegrationInformations)xstream.fromXML(xml) : null;
    }

    public ContractIntegrationInformations saveOrUpdateIntegrationInfos(ContractIntegrationInformations integrationInfos) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(integrationInfos), (IXmlActionType)IMdmProvider.ActionType.MANAGE_INTEGRATION_INFOS);
        String xml = this.http.executeModelAction(xstream.toXML((Object)op));
        return (ContractIntegrationInformations)xstream.fromXML(xml);
    }

    public void removeIntegrationInfos(ContractIntegrationInformations integrationInfos) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(integrationInfos), (IXmlActionType)IMdmProvider.ActionType.REMOVE_INTEGRATION_INFOS);
        this.http.executeModelAction(xstream.toXML((Object)op));
    }

    public List<DocumentSchema> getDocumentSchemas(int contractId) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(contractId), (IXmlActionType)IMdmProvider.ActionType.GED_DOCUMENT_SCHEMAS);
        String xml = this.http.executeModelAction(xstream.toXML((Object)op));
        return xml != null && !xml.isEmpty() ? (List)xstream.fromXML(xml) : new ArrayList<DocumentSchema>();
    }

    public void removeDocumentSchema(DocumentSchema docSchema) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(docSchema), (IXmlActionType)IMdmProvider.ActionType.REMOVE_DOCUMENT_SCHEMA);
        this.http.executeModelAction(xstream.toXML((Object)op));
    }

    public void saveOrUpdateDocumentSchema(DocumentSchema docSchema) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(docSchema), (IXmlActionType)IMdmProvider.ActionType.ADD_DOCUMENT_SCHEMA);
        this.http.executeModelAction(xstream.toXML((Object)op));
    }

    public List<ContractIntegrationInformations> getKpiInfosByDatasetId(String datasetId) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(datasetId), (IXmlActionType)IMdmProvider.ActionType.GET_KPI_INFOS_BY_DATASET_ID);
        String xml = this.http.executeModelAction(xstream.toXML((Object)op));
        return xml != null && !xml.isEmpty() ? (List)xstream.fromXML(xml) : null;
    }

    public List<ContractIntegrationInformations> getIntegrationInfosByOrganisation(String organisation, ContractType type) throws Exception {
        XmlAction op = new XmlAction(this.createArguments(organisation, type), (IXmlActionType)IMdmProvider.ActionType.GET_INTEGRATION_INFOS_BY_ORGANISATION);
        String xml = this.http.executeModelAction(xstream.toXML((Object)op));
        return xml != null && !xml.isEmpty() ? (List)xstream.fromXML(xml) : null;
    }
}

