/*
 * Decompiled with CFR 0.152.
 */
package bpm.nosql.oda.ui.impl.datasource;

import bpm.nosql.oda.runtime.impl.CassandraConnection;
import bpm.nosql.oda.runtime.impl.Connection;
import bpm.nosql.oda.runtime.impl.HbaseConnection;
import bpm.nosql.oda.ui.impl.datasource.ConnectionComposite;
import bpm.vanilla.platform.core.utils.MD5Helper;
import java.util.Properties;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSourceWizardPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class NOSQLDataSourcePage
extends DataSourceWizardPage {
    private ConnectionComposite connectionComposite;
    private Properties prop;
    private boolean ConnextionIsOpen;

    public NOSQLDataSourcePage(String pageName) {
        super(pageName);
    }

    public Properties collectCustomProperties() {
        this.prop = new Properties();
        if (this.connectionComposite != null) {
            if (!this.getOdaDataSourceId().contains("hbase")) {
                this.prop.put("host", this.connectionComposite.getProperties().getProperty("host"));
                this.prop.put("port", this.connectionComposite.getProperties().getProperty("port"));
                this.prop.put("database", this.connectionComposite.getProperties().getProperty("database"));
                if (this.connectionComposite.getProperties().getProperty("password").matches("[0-9a-f]{32}")) {
                    this.prop.put("password", this.connectionComposite.getProperties().getProperty("password"));
                } else {
                    this.prop.put("password", MD5Helper.encode((String)this.connectionComposite.getProperties().getProperty("password")));
                }
                if (this.connectionComposite.getProperties().getProperty("pass").equals("true")) {
                    this.prop.put("pass", "true");
                } else if (this.connectionComposite.getProperties().getProperty("pass").equals("false")) {
                    this.prop.put("pass", "false");
                }
            } else {
                this.prop.put("configfile", this.connectionComposite.getProperties().getProperty("configfile"));
            }
        }
        return this.prop;
    }

    public void createPageCustomControl(Composite parent) {
        this.connectionComposite = new ConnectionComposite(parent, 0, this, this.getOdaDataSourceId());
        this.connectionComposite.fillData(this.prop);
    }

    public void setInitialProperties(Properties dataSourceProps) {
        this.prop = dataSourceProps;
    }

    protected void testConnection() {
        if (this.getOdaDataSourceId().contains("bpm.nosql.oda.runtime.cassandra")) {
            CassandraConnection con = new CassandraConnection();
            try {
                con.open(this.connectionComposite.getProperties());
                this.ConnextionIsOpen = con.isOpen();
            }
            catch (OdaException e) {
                e.printStackTrace();
            }
        } else if (this.getOdaDataSourceId().contains("bpm.nosql.oda.runtime.hbase")) {
            HbaseConnection con = new HbaseConnection();
            try {
                con.open(this.connectionComposite.getProperties());
                this.ConnextionIsOpen = con.isOpen();
            }
            catch (OdaException e) {
                e.printStackTrace();
            }
        } else {
            Connection con = new Connection();
            try {
                con.open(this.connectionComposite.getProperties());
                this.ConnextionIsOpen = con.isOpen();
            }
            catch (OdaException e) {
                e.printStackTrace();
            }
        }
        if (this.ConnextionIsOpen) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Success", (String)"Connection successful");
        } else {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Connection refused");
        }
    }
}

