/*
 * Decompiled with CFR 0.152.
 */
package bpm.nosql.oda.ui.impl.datasource;

import bpm.nosql.oda.ui.impl.datasource.NOSQLDataSourcePage;
import bpm.vanilla.platform.core.utils.MD5Helper;
import java.util.Properties;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ConnectionComposite
extends Composite {
    private Text login;
    private Text password;
    private Text host;
    private Text port;
    private Text txtDb;
    private Text txtConfigFile;
    private Button passProtected;
    private Button btnConfigFile;
    private boolean pass;
    private ConnectionComposite conComposite;
    private String odaDatasourceId;

    public ConnectionComposite(Composite parent, int style, NOSQLDataSourcePage nosqlDataSourcePage, String odaDatasourceId) {
        super(parent, style);
        this.odaDatasourceId = odaDatasourceId;
        if (this.odaDatasourceId.contains("hbase")) {
            this.setLayout((Layout)new GridLayout(3, false));
            this.buildContentHbase();
        } else {
            this.setLayout((Layout)new GridLayout(2, false));
            this.buildContent();
        }
        this.fillData(null);
    }

    private void buildContent() {
        Label lblHost = new Label((Composite)this, 0);
        lblHost.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        lblHost.setText("Host");
        this.host = new Text((Composite)this, 2048);
        this.host.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label lblPort = new Label((Composite)this, 0);
        lblPort.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        lblPort.setText("Port");
        this.port = new Text((Composite)this, 2048);
        this.port.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label yourDb = new Label((Composite)this, 0);
        yourDb.setText("Database");
        yourDb.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.txtDb = new Text((Composite)this, 2048);
        this.txtDb.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.passProtected = new Button((Composite)this, 32);
        this.passProtected.setText("Password Protected");
        this.passProtected.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        this.passProtected.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ConnectionComposite.this.passProtected.getSelection()) {
                    ConnectionComposite.this.login.setEnabled(true);
                    ConnectionComposite.this.password.setEnabled(true);
                    ConnectionComposite.this.pass = true;
                } else {
                    ConnectionComposite.this.login.setEnabled(false);
                    ConnectionComposite.this.password.setEnabled(false);
                    ConnectionComposite.this.pass = false;
                }
            }
        });
        Label lblLogin = new Label((Composite)this, 0);
        lblLogin.setText("Login");
        lblLogin.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.login = new Text((Composite)this, 2048);
        this.login.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.login.setEnabled(false);
        Label lblPassword = new Label((Composite)this, 0);
        lblPassword.setText("Password");
        lblPassword.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.password = new Text((Composite)this, 0x400800);
        this.password.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.password.setEnabled(false);
    }

    private void buildContentHbase() {
        Label lblConfigFile = new Label((Composite)this, 0);
        lblConfigFile.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        lblConfigFile.setText("Host");
        this.txtConfigFile = new Text((Composite)this, 2048);
        this.txtConfigFile.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.btnConfigFile = new Button((Composite)this, 8);
        this.btnConfigFile.setText("...");
        this.btnConfigFile.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.btnConfigFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dial = new FileDialog(ConnectionComposite.this.getShell());
                String configFile = dial.open();
                try {
                    configFile = configFile.replaceAll("\\\\", "/");
                    ConnectionComposite.this.txtConfigFile.setText(configFile);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
    }

    public String getLogin() {
        return this.login.getText();
    }

    public String getPassword() {
        return this.password.getText();
    }

    public String getPort() {
        return this.port.getText();
    }

    public String getConfigFile() {
        return this.txtConfigFile.getText();
    }

    public String getTxtDb() {
        return this.txtDb.getText();
    }

    public String getHost() {
        return this.host.getText();
    }

    public boolean isPass() {
        return this.pass;
    }

    public String getOdaDatasourceId() {
        return this.odaDatasourceId;
    }

    public ConnectionComposite getConComposite() {
        return this.conComposite;
    }

    public void fillData(Properties properties) {
        if (properties != null) {
            if (!this.getOdaDatasourceId().contains("hbase")) {
                this.host.setText(properties.getProperty("host"));
                this.port.setText(properties.getProperty("port"));
                if (properties.getProperty("user") != null) {
                    this.login.setText(properties.getProperty("user"));
                }
                if (properties.getProperty("password") != null) {
                    this.password.setText(properties.getProperty("password"));
                }
                this.txtDb.setText(properties.getProperty("database"));
            } else {
                this.txtConfigFile.setText(properties.getProperty("configfile"));
            }
        }
    }

    public Properties getProperties() {
        String databaseType;
        Properties prop = new Properties();
        if (this.odaDatasourceId.contains("cassandra")) {
            databaseType = "cassandra";
            prop.put("user", this.login.getText());
            if (this.getPassword().matches("[0-9a-f]{32}")) {
                prop.put("password", this.password.getText());
            } else {
                prop.put("password", MD5Helper.encode((String)this.password.getText()));
            }
            prop.put("database", this.txtDb.getText());
            prop.put("port", this.port.getText());
            prop.put("host", this.host.getText());
            if (this.pass) {
                prop.put("pass", "true");
            } else {
                prop.put("pass", "false");
            }
        } else if (this.odaDatasourceId.contains("hbase")) {
            databaseType = "hbase";
            prop.put("configfile", this.txtConfigFile.getText());
        } else {
            databaseType = "mongodb";
            prop.put("user", this.login.getText());
            if (this.getPassword().matches("[0-9a-f]{32}")) {
                prop.put("password", this.password.getText());
            } else {
                prop.put("password", MD5Helper.encode((String)this.password.getText()));
            }
            prop.put("database", this.txtDb.getText());
            prop.put("port", this.port.getText());
            prop.put("host", this.host.getText());
            if (this.pass) {
                prop.put("pass", "true");
            } else {
                prop.put("pass", "false");
            }
        }
        prop.put("dbtype", databaseType);
        return prop;
    }
}

