/*
 * Decompiled with CFR 0.152.
 */
package bpm.nosql.oda.ui.impl;

import bpm.nosql.oda.runtime.impl.Connection;
import bpm.nosql.oda.runtime.impl.ConnectionManager;
import bpm.nosql.oda.runtime.impl.Query;
import bpm.nosql.oda.runtime.impl.ResultSetMetaData;
import bpm.vanilla.oda.commons.Activator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IParameterMetaData;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DataSetParameters;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.DesignFactory;
import org.eclipse.datatools.connectivity.oda.design.ParameterDefinition;
import org.eclipse.datatools.connectivity.oda.design.ParameterMode;
import org.eclipse.datatools.connectivity.oda.design.ResultSetColumns;
import org.eclipse.datatools.connectivity.oda.design.ResultSetDefinition;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DesignSessionUtil;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSetWizardPage;
import org.eclipse.datatools.connectivity.oda.design.util.DesignUtil;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class NOSQLDataSetWizardPage
extends DataSetWizardPage {
    private static String DEFAULT_MESSAGE = "Define the query text for the data set";
    private TableViewer viewerColSelected;
    private ListViewer listCol;
    private ArrayList<String> availableColumns;
    private ArrayList<String> selectedColumns;
    private Properties connProps;
    private Button btnAdd;
    private Button btnRemove;
    private Button btnAddAll;
    private Button btnRemoveAll;
    private Query query;
    private ResultSetMetaData metadata;
    private Connection conn;

    public NOSQLDataSetWizardPage() {
        super("");
    }

    public NOSQLDataSetWizardPage(String pageName) {
        super(pageName);
        this.setTitle(pageName);
        this.setMessage(DEFAULT_MESSAGE);
    }

    public void createPageCustomControl(Composite parent) {
        Composite inCompo = new Composite(parent, 0);
        inCompo.setLayout((Layout)new GridLayout(1, false));
        this.setControl(this.createPageControl(inCompo));
        this.initializeControl();
    }

    private void initializeControl() {
        this.connProps = DesignUtil.convertDataSourceProperties((DataSourceDesign)this.getInitializationDesign().getDataSourceDesign());
        try {
            this.conn = (Connection)ConnectionManager.getConnection((Properties)this.connProps);
            this.fillDatas(this.conn);
        }
        catch (OdaException e) {
            e.printStackTrace();
        }
        DataSetDesign dataSetDesign = this.getInitializationDesign();
        if (dataSetDesign == null || dataSetDesign.getQueryText() == null || dataSetDesign.getQueryText().trim().equals("")) {
            return;
        }
        this.initSelection(dataSetDesign);
        this.validateData();
    }

    private void initSelection(DataSetDesign dataSetDesign) {
        String queryText = dataSetDesign.getQueryText();
        if (this.selectedColumns == null) {
            this.selectedColumns = new ArrayList();
        }
        try {
            List<String> columns = Arrays.asList(queryText.substring(queryText.indexOf("select ") + 7, queryText.indexOf(" from ")).split(","));
            for (String col : columns) {
                this.selectedColumns.add(col);
                this.availableColumns.remove(col);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.viewerColSelected.setInput(this.selectedColumns);
        this.listCol.setInput(this.availableColumns);
    }

    private void fillDatas(Connection conn) throws OdaException {
        this.query = conn.newQuery(null);
        this.metadata = (ResultSetMetaData)this.query.getMetaData();
        try {
            this.availableColumns = this.metadata.getColumns();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.listCol.setInput(this.availableColumns);
    }

    private Control createPageControl(Composite parent) {
        this.setPageComplete(false);
        parent.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        parent.setLayout((Layout)new GridLayout(2, false));
        Composite comp = new Composite(parent, 2048);
        comp.setLayoutData((Object)new GridData(4, 4, true, true));
        comp.setLayout((Layout)new GridLayout(2, false));
        Label lbl = new Label(comp, 0);
        lbl.setText("Select Columns to display themself.");
        lbl.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        Composite groupListColumn = new Composite(comp, 2048);
        groupListColumn.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        groupListColumn.setLayout((Layout)new GridLayout(2, false));
        this.listCol = new ListViewer(groupListColumn, 2570);
        this.listCol.getList().setLayoutData((Object)new GridData(4, 4, true, true, 1, 5));
        this.listCol.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                ArrayList input = (ArrayList)inputElement;
                return input.toArray();
            }
        });
        this.listCol.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return (String)element;
            }
        });
        this.btnAdd = new Button(groupListColumn, 8);
        this.btnAdd.setToolTipText("Add a column");
        this.btnAdd.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.btnAdd.setImage(Activator.getDefault().getImageRegistry().get("ui/icons/add.png"));
        this.btnRemove = new Button(groupListColumn, 8);
        this.btnRemove.setToolTipText("Remove a column");
        this.btnRemove.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.btnRemove.setImage(Activator.getDefault().getImageRegistry().get("ui/icons/delete.png"));
        this.btnAddAll = new Button(groupListColumn, 8);
        this.btnAddAll.setToolTipText("Add All columns");
        this.btnAddAll.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.btnAddAll.setImage(Activator.getDefault().getImageRegistry().get("ui/icons/table_add.png"));
        this.btnRemoveAll = new Button(groupListColumn, 8);
        this.btnRemoveAll.setToolTipText("Remove All columns");
        this.btnRemoveAll.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.btnRemoveAll.setImage(Activator.getDefault().getImageRegistry().get("ui/icons/table_delete.png"));
        Composite groupListSelected = new Composite(comp, 0);
        groupListSelected.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        groupListSelected.setLayout((Layout)new GridLayout(1, false));
        this.viewerColSelected = new TableViewer(groupListSelected, 68354);
        this.viewerColSelected.getTable().setLayoutData((Object)new GridData(4, 4, true, true, 1, 5));
        this.viewerColSelected.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                ArrayList input = (ArrayList)inputElement;
                return input.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        TableViewerColumn column = new TableViewerColumn(this.viewerColSelected, 68354);
        column.getColumn().setText("Column's Name");
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return (String)element;
            }

            public Image getImage(Object element) {
                return Activator.getDefault().getImageRegistry().get("ui/icons/table_go.png");
            }
        });
        column = new TableViewerColumn(this.viewerColSelected, 0);
        column.getColumn().setText("Column's label");
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return (String)element;
            }
        });
        int i = 0;
        int n = this.viewerColSelected.getTable().getColumnCount();
        while (i < n) {
            this.viewerColSelected.getTable().getColumn(i).setWidth(145);
            ++i;
        }
        this.viewerColSelected.getTable().setHeaderVisible(true);
        this.viewerColSelected.getTable().setLinesVisible(true);
        this.viewerColSelected.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                selection.getFirstElement();
            }
        });
        this.initListenersBtnTool();
        return parent;
    }

    private void initListenersBtnTool() {
        this.btnAdd.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)NOSQLDataSetWizardPage.this.listCol.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                for (Object c : selection) {
                    NOSQLDataSetWizardPage.this.availableColumns.remove(c);
                    if (NOSQLDataSetWizardPage.this.selectedColumns == null) {
                        NOSQLDataSetWizardPage.this.selectedColumns = new ArrayList();
                    }
                    NOSQLDataSetWizardPage.this.selectedColumns.add((String)c);
                    NOSQLDataSetWizardPage.this.query.setSelectColumns((List)NOSQLDataSetWizardPage.this.selectedColumns);
                }
                NOSQLDataSetWizardPage.this.listCol.setInput((Object)NOSQLDataSetWizardPage.this.availableColumns);
                NOSQLDataSetWizardPage.this.viewerColSelected.setInput((Object)NOSQLDataSetWizardPage.this.selectedColumns);
                NOSQLDataSetWizardPage.this.setPageComplete(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.btnRemove.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)NOSQLDataSetWizardPage.this.viewerColSelected.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                Object c = selection.getFirstElement();
                NOSQLDataSetWizardPage.this.selectedColumns.remove(c);
                NOSQLDataSetWizardPage.this.availableColumns.add((String)c);
                NOSQLDataSetWizardPage.this.listCol.setInput((Object)NOSQLDataSetWizardPage.this.availableColumns);
                NOSQLDataSetWizardPage.this.viewerColSelected.setInput((Object)NOSQLDataSetWizardPage.this.selectedColumns);
                NOSQLDataSetWizardPage.this.setPageComplete(!NOSQLDataSetWizardPage.this.selectedColumns.isEmpty());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.btnAddAll.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (NOSQLDataSetWizardPage.this.selectedColumns == null) {
                    NOSQLDataSetWizardPage.this.selectedColumns = new ArrayList();
                }
                NOSQLDataSetWizardPage.this.selectedColumns.addAll(NOSQLDataSetWizardPage.this.availableColumns);
                NOSQLDataSetWizardPage.this.availableColumns = new ArrayList();
                NOSQLDataSetWizardPage.this.listCol.setInput((Object)NOSQLDataSetWizardPage.this.availableColumns);
                NOSQLDataSetWizardPage.this.viewerColSelected.setInput((Object)NOSQLDataSetWizardPage.this.selectedColumns);
                NOSQLDataSetWizardPage.this.setPageComplete(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.btnRemoveAll.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                NOSQLDataSetWizardPage.this.availableColumns.addAll(NOSQLDataSetWizardPage.this.selectedColumns);
                NOSQLDataSetWizardPage.this.selectedColumns = new ArrayList();
                NOSQLDataSetWizardPage.this.listCol.setInput((Object)NOSQLDataSetWizardPage.this.availableColumns);
                NOSQLDataSetWizardPage.this.viewerColSelected.setInput((Object)NOSQLDataSetWizardPage.this.selectedColumns);
                NOSQLDataSetWizardPage.this.setPageComplete(false);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void closeConnection(IConnection conn) {
        try {
            if (conn != null && conn.isOpen()) {
                conn.close();
            }
        }
        catch (OdaException e) {
            e.printStackTrace();
        }
    }

    protected DataSetDesign collectDataSetDesign(DataSetDesign dataSetDesign) {
        block5: {
            String queryText = this.getQueryText();
            dataSetDesign.setQueryText(queryText);
            IConnection conn = null;
            try {
                try {
                    Properties connProps = DesignUtil.convertDataSourceProperties((DataSourceDesign)this.getInitializationDesign().getDataSourceDesign());
                    conn = ConnectionManager.getConnection((Properties)connProps);
                    this.updateDesign(dataSetDesign, conn, queryText);
                }
                catch (OdaException e) {
                    dataSetDesign.setResultSets(null);
                    dataSetDesign.setParameters(null);
                    e.printStackTrace();
                    this.closeConnection(conn);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                this.closeConnection(conn);
                throw throwable;
            }
            this.closeConnection(conn);
        }
        return dataSetDesign;
    }

    private boolean hasValidData() {
        this.validateData();
        return this.canLeave();
    }

    private void validateData() {
        boolean isValid;
        boolean bl = isValid = this.getQueryText() != null && this.getQueryText().trim().length() > 0;
        if (isValid) {
            this.setMessage(DEFAULT_MESSAGE);
        } else {
            this.setMessage("Requires input value.", 3);
        }
        this.setPageComplete(isValid);
    }

    private String getQueryText() {
        StringBuilder b = new StringBuilder();
        b.append("select ");
        for (String col : this.selectedColumns) {
            b.append(String.valueOf(col) + ",");
        }
        String s = b.substring(0, b.length() - 1).toString();
        b = new StringBuilder();
        b.append(String.valueOf(s) + " from ");
        b.append(this.connProps.getProperty("database"));
        return b.toString();
    }

    private void updateDesign(DataSetDesign dataSetDesign, IConnection conn, String queryText) throws OdaException {
        Query query = (Query)conn.newQuery(null);
        query.prepare(queryText);
        if (query.getSelectColumns() != null && !query.getSelectColumns().isEmpty()) {
            this.selectedColumns = (ArrayList)query.getSelectColumns();
        }
        try {
            IResultSetMetaData md = query.getMetaData();
            this.updateResultSetDesign(md, dataSetDesign);
        }
        catch (OdaException e) {
            dataSetDesign.setResultSets(null);
            e.printStackTrace();
        }
        try {
            IParameterMetaData paramMd = query.getParameterMetaData();
            this.updateParameterDesign(paramMd, dataSetDesign);
        }
        catch (OdaException ex) {
            dataSetDesign.setParameters(null);
            ex.printStackTrace();
        }
    }

    private void updateResultSetDesign(IResultSetMetaData md, DataSetDesign dataSetDesign) throws OdaException {
        ResultSetColumns columns = DesignSessionUtil.toResultSetColumnsDesign((IResultSetMetaData)md);
        ResultSetDefinition resultSetDefn = DesignFactory.eINSTANCE.createResultSetDefinition();
        resultSetDefn.setResultSetColumns(columns);
        dataSetDesign.setPrimaryResultSet(resultSetDefn);
        dataSetDesign.getResultSets().setDerivedMetaData(true);
    }

    private void updateParameterDesign(IParameterMetaData paramMd, DataSetDesign dataSetDesign) throws OdaException {
        ParameterDefinition paramDef;
        DataSetParameters paramDesign = DesignSessionUtil.toDataSetParametersDesign((IParameterMetaData)paramMd, (ParameterMode)DesignSessionUtil.toParameterModeDesign((int)1));
        dataSetDesign.setParameters(paramDesign);
        if (paramDesign == null) {
            return;
        }
        paramDesign.setDerivedMetaData(true);
        if (paramDesign.getParameterDefinitions().size() > 0 && (paramDef = (ParameterDefinition)paramDesign.getParameterDefinitions().get(0)) != null) {
            paramDef.setDefaultScalarValue("dummy default value");
        }
    }

    protected boolean canLeave() {
        return this.isPageComplete();
    }
}

