/*
 * Decompiled with CFR 0.152.
 */
package bpm.nosql.oda.ui.hbase.impl;

import bpm.nosql.oda.runtime.impl.ConnectionManager;
import bpm.nosql.oda.runtime.impl.HbaseConnection;
import bpm.nosql.oda.runtime.impl.HbaseQuery;
import bpm.nosql.oda.runtime.impl.HbaseResultSetMetaData;
import bpm.vanilla.oda.commons.Activator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IParameterMetaData;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DataSetParameters;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.DesignFactory;
import org.eclipse.datatools.connectivity.oda.design.ParameterDefinition;
import org.eclipse.datatools.connectivity.oda.design.ParameterMode;
import org.eclipse.datatools.connectivity.oda.design.ResultSetColumns;
import org.eclipse.datatools.connectivity.oda.design.ResultSetDefinition;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DesignSessionUtil;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSetWizardPage;
import org.eclipse.datatools.connectivity.oda.design.util.DesignUtil;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class HbaseDataSetWizardPage
extends DataSetWizardPage {
    private static String DEFAULT_MESSAGE = "Define the query text for the data set";
    private Properties connProps;
    private HbaseConnection conn;
    private ArrayList<String> tablesNames;
    private ArrayList<String> familiesList;
    private ArrayList<String> availableColumns;
    private ArrayList<String> selectedColumns;
    private ComboViewer comboTable;
    private ComboViewer comboFamily;
    private String selectedTable;
    private String selectedFamily;
    private HTableDescriptor[] listTableDescriptor;
    private Collection<HColumnDescriptor> listFamilies;
    private TableViewer viewerColSelected;
    private Button btnAdd;
    private Button btnRemove;
    private Button btnAddAll;
    private Button btnRemoveAll;
    private ListViewer listCol;
    private HbaseQuery query;
    private HbaseResultSetMetaData metadata;

    public HbaseDataSetWizardPage() {
        super("");
    }

    public HbaseDataSetWizardPage(String pageName) {
        super(pageName);
        this.setTitle(pageName);
        this.setMessage(DEFAULT_MESSAGE);
    }

    public void createPageCustomControl(Composite parent) {
        Composite inCompo = new Composite(parent, 0);
        inCompo.setLayout((Layout)new GridLayout(1, false));
        this.setControl(this.createPageControl(inCompo));
        this.initializeControl();
    }

    private void initializeControl() {
        this.connProps = DesignUtil.convertDataSourceProperties((DataSourceDesign)this.getInitializationDesign().getDataSourceDesign());
        try {
            this.conn = (HbaseConnection)ConnectionManager.getConnection((Properties)this.connProps);
            this.fillDatas(this.conn);
        }
        catch (OdaException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DataSetDesign dataSetDesign = this.getInitializationDesign();
        if (dataSetDesign == null || dataSetDesign.getQueryText() == null || dataSetDesign.getQueryText().trim().equals("")) {
            return;
        }
        this.initSelection(dataSetDesign);
        this.validateData();
    }

    private void initSelection(DataSetDesign dataSetDesign) {
        String queryText = dataSetDesign.getQueryText();
        List<String> columns = Arrays.asList(queryText.substring(queryText.indexOf("select ") + 7, queryText.indexOf(" from ")).split(","));
        this.comboTable.setSelection((ISelection)new StructuredSelection((Object)queryText.substring(queryText.indexOf(" from ") + 6, queryText.indexOf("."))));
        this.comboFamily.setSelection((ISelection)new StructuredSelection((Object)queryText.substring(queryText.indexOf(".") + 1)));
        if (this.selectedColumns == null) {
            this.selectedColumns = new ArrayList();
        }
        for (String col : columns) {
            this.selectedColumns.add(col);
            this.availableColumns.remove(col);
        }
        this.viewerColSelected.setInput(this.selectedColumns);
        this.listCol.setInput(this.availableColumns);
    }

    private void validateData() {
        boolean isValid;
        boolean bl = isValid = this.getQueryText() != null && ((String)this.getQueryText()).trim().length() > 0;
        if (isValid) {
            this.setMessage(DEFAULT_MESSAGE);
        } else {
            this.setMessage("Requires input value.", 3);
        }
        this.setPageComplete(isValid);
    }

    private Object getQueryText() {
        StringBuilder b = new StringBuilder();
        b.append("select ");
        for (String col : this.selectedColumns) {
            b.append(String.valueOf(col) + ",");
        }
        String s = b.substring(0, b.length() - 1).toString();
        b = new StringBuilder();
        b.append(String.valueOf(s) + " from ");
        b.append(String.valueOf(this.selectedTable) + "." + this.selectedFamily);
        return b.toString();
    }

    private void fillDatas(HbaseConnection conn) throws Exception {
        this.query = (HbaseQuery)conn.newQuery(null);
        this.metadata = (HbaseResultSetMetaData)this.query.getMetaData();
        this.listTableDescriptor = conn.getListTables();
        this.tablesNames = new ArrayList();
        this.availableColumns = this.metadata.getColumns();
        HTableDescriptor[] hTableDescriptorArray = this.listTableDescriptor;
        int n = this.listTableDescriptor.length;
        int n2 = 0;
        while (n2 < n) {
            HTableDescriptor tableDescr = hTableDescriptorArray[n2];
            this.tablesNames.add(tableDescr.getNameAsString());
            ++n2;
        }
        this.comboTable.setInput(this.tablesNames);
    }

    private Control createPageControl(Composite parent) {
        this.setPageComplete(false);
        parent.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        parent.setLayout((Layout)new GridLayout(2, false));
        Composite composite = new Composite(parent, 2048);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)new GridLayout(2, false));
        Label lblTables = new Label(composite, 0);
        lblTables.setText("Select Table");
        lblTables.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.comboTable = new ComboViewer(composite, 12);
        this.comboTable.getCombo().setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.comboTable.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                Object[] currentElement = ((ArrayList)inputElement).toArray();
                return currentElement;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.comboTable.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return (String)element;
            }
        });
        this.comboTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)HbaseDataSetWizardPage.this.comboTable.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                Object o = selection.getFirstElement();
                HbaseDataSetWizardPage.this.selectedTable = (String)o;
                this.getFamilys(HbaseDataSetWizardPage.this.selectedTable);
                HbaseDataSetWizardPage.this.query.setSelectedTable(HbaseDataSetWizardPage.this.selectedTable);
            }

            private void getFamilys(String table) {
                try {
                    HTableDescriptor[] hTableDescriptorArray = HbaseDataSetWizardPage.this.listTableDescriptor;
                    int n = hTableDescriptorArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        HTableDescriptor tableDescr = hTableDescriptorArray[n2];
                        if (tableDescr.getNameAsString().equals(table)) {
                            HbaseDataSetWizardPage.this.listFamilies = tableDescr.getFamilies();
                            HbaseDataSetWizardPage.this.familiesList = new ArrayList();
                            for (HColumnDescriptor families : HbaseDataSetWizardPage.this.listFamilies) {
                                HbaseDataSetWizardPage.this.familiesList.add(families.getNameAsString());
                            }
                            HbaseDataSetWizardPage.this.comboFamily.setInput((Object)HbaseDataSetWizardPage.this.familiesList);
                        }
                        ++n2;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        Label lbl = new Label(composite, 0);
        lbl.setText("Select Columns familie.");
        lbl.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        this.comboFamily = new ComboViewer(composite, 12);
        this.comboFamily.getCombo().setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.comboFamily.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                Object[] currentElement = ((ArrayList)inputElement).toArray();
                return currentElement;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.comboFamily.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return super.getText(element);
            }
        });
        this.comboFamily.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)HbaseDataSetWizardPage.this.comboFamily.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                if (HbaseDataSetWizardPage.this.selectedColumns != null) {
                    HbaseDataSetWizardPage.this.selectedColumns.clear();
                    HbaseDataSetWizardPage.this.viewerColSelected.refresh();
                }
                Object o = selection.getFirstElement();
                HbaseDataSetWizardPage.this.selectedFamily = (String)o;
                try {
                    this.getColumns(HbaseDataSetWizardPage.this.listTableDescriptor, HbaseDataSetWizardPage.this.listFamilies);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                HbaseDataSetWizardPage.this.query.setSelectedFamilies(HbaseDataSetWizardPage.this.selectedFamily);
            }

            private void getColumns(HTableDescriptor[] listTableDescriptor, Collection<HColumnDescriptor> listFamilies) throws Exception {
                for (HColumnDescriptor column : listFamilies) {
                    if (!column.getNameAsString().equals(HbaseDataSetWizardPage.this.selectedFamily)) continue;
                    ResultScanner result = null;
                    try {
                        HTable table = new HTable(HbaseDataSetWizardPage.this.conn.getConfig(), HbaseDataSetWizardPage.this.selectedTable);
                        Scan s = new Scan();
                        s.addFamily(Bytes.toBytes((String)HbaseDataSetWizardPage.this.selectedFamily));
                        result = table.getScanner(s);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    Result r = result.next();
                    HbaseDataSetWizardPage.this.availableColumns = new ArrayList();
                    for (KeyValue kv : r.list()) {
                        HbaseDataSetWizardPage.this.availableColumns.add(Bytes.toString((byte[])kv.getQualifier()));
                    }
                    HbaseDataSetWizardPage.this.listCol.setInput((Object)HbaseDataSetWizardPage.this.availableColumns);
                }
            }
        });
        Composite groupListColumn = new Composite(composite, 2048);
        groupListColumn.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        groupListColumn.setLayout((Layout)new GridLayout(2, false));
        this.listCol = new ListViewer(groupListColumn, 2570);
        this.listCol.getList().setLayoutData((Object)new GridData(4, 4, true, true, 1, 5));
        this.listCol.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                ArrayList input = (ArrayList)inputElement;
                return input.toArray();
            }
        });
        this.listCol.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return (String)element;
            }
        });
        this.btnAdd = new Button(groupListColumn, 8);
        this.btnAdd.setToolTipText("Add a column");
        this.btnAdd.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.btnAdd.setImage(Activator.getDefault().getImageRegistry().get("ui/icons/add.png"));
        this.btnRemove = new Button(groupListColumn, 8);
        this.btnRemove.setToolTipText("Remove a column");
        this.btnRemove.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.btnRemove.setImage(Activator.getDefault().getImageRegistry().get("ui/icons/delete.png"));
        this.btnAddAll = new Button(groupListColumn, 8);
        this.btnAddAll.setToolTipText("Add All columns");
        this.btnAddAll.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.btnAddAll.setImage(Activator.getDefault().getImageRegistry().get("ui/icons/table_add.png"));
        this.btnRemoveAll = new Button(groupListColumn, 8);
        this.btnRemoveAll.setToolTipText("Remove All columns");
        this.btnRemoveAll.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.btnRemoveAll.setImage(Activator.getDefault().getImageRegistry().get("ui/icons/table_delete.png"));
        Composite groupListSelected = new Composite(composite, 0);
        groupListSelected.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        groupListSelected.setLayout((Layout)new GridLayout(1, false));
        this.viewerColSelected = new TableViewer(groupListSelected, 68354);
        this.viewerColSelected.getTable().setLayoutData((Object)new GridData(4, 4, true, true, 1, 5));
        this.viewerColSelected.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                ArrayList input = (ArrayList)inputElement;
                return input.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        TableViewerColumn column = new TableViewerColumn(this.viewerColSelected, 68354);
        column.getColumn().setText("Column's Name");
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return (String)element;
            }

            public Image getImage(Object element) {
                return Activator.getDefault().getImageRegistry().get("ui/icons/table_go.png");
            }
        });
        column = new TableViewerColumn(this.viewerColSelected, 0);
        column.getColumn().setText("Column's label");
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return (String)element;
            }
        });
        int i = 0;
        int n = this.viewerColSelected.getTable().getColumnCount();
        while (i < n) {
            this.viewerColSelected.getTable().getColumn(i).setWidth(145);
            ++i;
        }
        this.viewerColSelected.getTable().setHeaderVisible(true);
        this.viewerColSelected.getTable().setLinesVisible(true);
        this.viewerColSelected.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                selection.getFirstElement();
            }
        });
        this.initListenersBtnTool();
        return composite;
    }

    private void closeConnection(IConnection conn) {
        try {
            if (conn != null && conn.isOpen()) {
                conn.close();
            }
        }
        catch (OdaException e) {
            e.printStackTrace();
        }
    }

    protected DataSetDesign collectDataSetDesign(DataSetDesign dataSetDesign) {
        block5: {
            String queryText = (String)this.getQueryText();
            dataSetDesign.setQueryText(queryText);
            IConnection conn = null;
            try {
                try {
                    this.connProps = DesignUtil.convertDataSourceProperties((DataSourceDesign)this.getInitializationDesign().getDataSourceDesign());
                    conn = ConnectionManager.getConnection((Properties)this.connProps);
                    this.updateDesign(dataSetDesign, conn, queryText);
                }
                catch (OdaException e) {
                    dataSetDesign.setResultSets(null);
                    dataSetDesign.setParameters(null);
                    e.printStackTrace();
                    this.closeConnection(conn);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                this.closeConnection(conn);
                throw throwable;
            }
            this.closeConnection(conn);
        }
        return dataSetDesign;
    }

    private void updateDesign(DataSetDesign dataSetDesign, IConnection conn2, String queryText) throws OdaException {
        this.query.prepare(queryText);
        if (this.query.getSelectColumns() != null && !this.query.getSelectColumns().isEmpty()) {
            this.selectedColumns = (ArrayList)this.query.getSelectColumns();
        } else {
            this.query.setSelectColumns(this.selectedColumns);
        }
        try {
            HbaseResultSetMetaData md = new HbaseResultSetMetaData(this.query);
            this.updateResultSetDesign((IResultSetMetaData)md, dataSetDesign);
        }
        catch (OdaException e) {
            dataSetDesign.setResultSets(null);
            e.printStackTrace();
        }
        try {
            IParameterMetaData paramMd = this.query.getParameterMetaData();
            this.updateParameterDesign(paramMd, dataSetDesign);
        }
        catch (OdaException ex) {
            dataSetDesign.setParameters(null);
            ex.printStackTrace();
        }
    }

    private void updateParameterDesign(IParameterMetaData paramMd, DataSetDesign dataSetDesign) throws OdaException {
        ParameterDefinition paramDef;
        DataSetParameters paramDesign = DesignSessionUtil.toDataSetParametersDesign((IParameterMetaData)paramMd, (ParameterMode)DesignSessionUtil.toParameterModeDesign((int)1));
        dataSetDesign.setParameters(paramDesign);
        if (paramDesign == null) {
            return;
        }
        paramDesign.setDerivedMetaData(true);
        if (paramDesign.getParameterDefinitions().size() > 0 && (paramDef = (ParameterDefinition)paramDesign.getParameterDefinitions().get(0)) != null) {
            paramDef.setDefaultScalarValue("dummy default value");
        }
    }

    private void updateResultSetDesign(IResultSetMetaData md, DataSetDesign dataSetDesign) throws OdaException {
        ResultSetColumns columns = DesignSessionUtil.toResultSetColumnsDesign((IResultSetMetaData)md);
        ResultSetDefinition resultSetDefn = DesignFactory.eINSTANCE.createResultSetDefinition();
        resultSetDefn.setResultSetColumns(columns);
        dataSetDesign.setPrimaryResultSet(resultSetDefn);
        dataSetDesign.getResultSets().setDerivedMetaData(true);
    }

    private void initListenersBtnTool() {
        this.btnAdd.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)HbaseDataSetWizardPage.this.listCol.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                for (Object c : selection) {
                    HbaseDataSetWizardPage.this.availableColumns.remove(c);
                    if (HbaseDataSetWizardPage.this.selectedColumns == null) {
                        HbaseDataSetWizardPage.this.selectedColumns = new ArrayList();
                    }
                    HbaseDataSetWizardPage.this.selectedColumns.add((String)c);
                }
                HbaseDataSetWizardPage.this.query.setSelectColumns((List)HbaseDataSetWizardPage.this.selectedColumns);
                HbaseDataSetWizardPage.this.listCol.setInput((Object)HbaseDataSetWizardPage.this.availableColumns);
                HbaseDataSetWizardPage.this.viewerColSelected.setInput((Object)HbaseDataSetWizardPage.this.selectedColumns);
                HbaseDataSetWizardPage.this.setPageComplete(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.btnRemove.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)HbaseDataSetWizardPage.this.viewerColSelected.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                Object c = selection.getFirstElement();
                HbaseDataSetWizardPage.this.selectedColumns.remove(c);
                HbaseDataSetWizardPage.this.availableColumns.add((String)c);
                HbaseDataSetWizardPage.this.listCol.setInput((Object)HbaseDataSetWizardPage.this.availableColumns);
                HbaseDataSetWizardPage.this.viewerColSelected.setInput((Object)HbaseDataSetWizardPage.this.selectedColumns);
                HbaseDataSetWizardPage.this.setPageComplete(!HbaseDataSetWizardPage.this.selectedColumns.isEmpty());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.btnAddAll.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (HbaseDataSetWizardPage.this.selectedColumns == null) {
                    HbaseDataSetWizardPage.this.selectedColumns = new ArrayList();
                }
                HbaseDataSetWizardPage.this.selectedColumns.addAll(HbaseDataSetWizardPage.this.availableColumns);
                HbaseDataSetWizardPage.this.availableColumns = new ArrayList();
                HbaseDataSetWizardPage.this.listCol.setInput((Object)HbaseDataSetWizardPage.this.availableColumns);
                HbaseDataSetWizardPage.this.viewerColSelected.setInput((Object)HbaseDataSetWizardPage.this.selectedColumns);
                HbaseDataSetWizardPage.this.query.setSelectColumns((List)HbaseDataSetWizardPage.this.selectedColumns);
                HbaseDataSetWizardPage.this.setPageComplete(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.btnRemoveAll.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                HbaseDataSetWizardPage.this.availableColumns.addAll(HbaseDataSetWizardPage.this.selectedColumns);
                HbaseDataSetWizardPage.this.selectedColumns = new ArrayList();
                HbaseDataSetWizardPage.this.listCol.setInput((Object)HbaseDataSetWizardPage.this.availableColumns);
                HbaseDataSetWizardPage.this.viewerColSelected.setInput((Object)HbaseDataSetWizardPage.this.selectedColumns);
                HbaseDataSetWizardPage.this.setPageComplete(false);
            }
        });
    }

    protected boolean canLeave() {
        return this.isPageComplete();
    }
}

