/*
 * Decompiled with CFR 0.152.
 */
package bpm.nosql.oda.ui.cassandra.impl;

import bpm.nosql.oda.runtime.impl.CassandraConnection;
import bpm.nosql.oda.runtime.impl.CassandraDriver;
import bpm.nosql.oda.runtime.impl.CassandraQuery;
import java.util.Properties;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IParameterMetaData;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DataSetParameters;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.DesignFactory;
import org.eclipse.datatools.connectivity.oda.design.ParameterDefinition;
import org.eclipse.datatools.connectivity.oda.design.ParameterMode;
import org.eclipse.datatools.connectivity.oda.design.ResultSetColumns;
import org.eclipse.datatools.connectivity.oda.design.ResultSetDefinition;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DesignSessionUtil;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSetWizardPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CassandraDataSetWizardPage
extends DataSetWizardPage {
    private static String DEFAULT_MESSAGE = "Define the query text for the data set";
    private transient Text m_queryTextField;

    public CassandraDataSetWizardPage() {
        super("");
    }

    public CassandraDataSetWizardPage(String pageName) {
        super(pageName);
        this.setTitle(pageName);
        this.setMessage(DEFAULT_MESSAGE);
    }

    public CassandraDataSetWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.setMessage(DEFAULT_MESSAGE);
    }

    public void createPageCustomControl(Composite parent) {
        this.setControl(this.createPageControl(parent));
        this.initializeControl();
    }

    private Control createPageControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        GridData gridData = new GridData(272);
        composite.setLayoutData((Object)gridData);
        Label fieldLabel = new Label(composite, 0);
        fieldLabel.setText("&Query Text:");
        this.m_queryTextField = new Text(composite, 2816);
        GridData data = new GridData(768);
        data.heightHint = 100;
        this.m_queryTextField.setLayoutData((Object)data);
        this.m_queryTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CassandraDataSetWizardPage.this.validateData();
            }
        });
        this.setPageComplete(false);
        return composite;
    }

    private void initializeControl() {
        DataSetDesign dataSetDesign = this.getInitializationDesign();
        if (dataSetDesign == null) {
            return;
        }
        String queryText = dataSetDesign.getQueryText();
        if (queryText == null) {
            return;
        }
        this.m_queryTextField.setText(queryText);
        this.validateData();
        this.setMessage(DEFAULT_MESSAGE);
    }

    private void validateData() {
        boolean isValid;
        boolean bl = isValid = this.m_queryTextField != null && this.getQueryText() != null && ((String)this.getQueryText()).trim().length() > 0;
        if (isValid) {
            this.setMessage(DEFAULT_MESSAGE);
        } else {
            this.setMessage("Requires input value.", 3);
        }
        this.setPageComplete(isValid);
    }

    private Object getQueryText() {
        return this.m_queryTextField.getText();
    }

    protected DataSetDesign collectDataSetDesign(DataSetDesign dataSetDesign) {
        block5: {
            String queryText = (String)this.getQueryText();
            dataSetDesign.setQueryText(queryText);
            CassandraConnection customConn = null;
            try {
                try {
                    CassandraDriver customDriver = new CassandraDriver();
                    customConn = customDriver.getConnection(null);
                    Properties connProps = DesignSessionUtil.getEffectiveDataSourceProperties((DataSourceDesign)this.getInitializationDesign().getDataSourceDesign());
                    customConn.open(connProps);
                    this.updateDesign(dataSetDesign, customConn, queryText);
                }
                catch (OdaException e) {
                    dataSetDesign.setResultSets(null);
                    dataSetDesign.setParameters(null);
                    e.printStackTrace();
                    this.closeConnection((IConnection)customConn);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                this.closeConnection((IConnection)customConn);
                throw throwable;
            }
            this.closeConnection((IConnection)customConn);
        }
        return dataSetDesign;
    }

    protected void collectResponseState() {
        super.collectResponseState();
    }

    protected boolean canLeave() {
        return this.isPageComplete();
    }

    private boolean hasValidData() {
        this.validateData();
        return this.canLeave();
    }

    private void updateDesign(DataSetDesign dataSetDesign, CassandraConnection conn, String queryText) throws OdaException {
        CassandraQuery query = conn.newQuery(null);
        query.prepare(queryText.toString());
        try {
            IResultSetMetaData md = query.getMetaData();
            this.updateResultSetDesign(md, dataSetDesign);
        }
        catch (OdaException e) {
            dataSetDesign.setResultSets(null);
            e.printStackTrace();
        }
        try {
            IParameterMetaData paramMd = query.getParameterMetaData();
            this.updateParameterDesign(paramMd, dataSetDesign);
        }
        catch (OdaException ex) {
            dataSetDesign.setParameters(null);
            ex.printStackTrace();
        }
    }

    private void updateResultSetDesign(IResultSetMetaData md, DataSetDesign dataSetDesign) throws OdaException {
        ResultSetColumns columns = DesignSessionUtil.toResultSetColumnsDesign((IResultSetMetaData)md);
        ResultSetDefinition resultSetDefn = DesignFactory.eINSTANCE.createResultSetDefinition();
        resultSetDefn.setResultSetColumns(columns);
        dataSetDesign.setPrimaryResultSet(resultSetDefn);
        dataSetDesign.getResultSets().setDerivedMetaData(true);
    }

    private void updateParameterDesign(IParameterMetaData paramMd, DataSetDesign dataSetDesign) throws OdaException {
        ParameterDefinition paramDef;
        DataSetParameters paramDesign = DesignSessionUtil.toDataSetParametersDesign((IParameterMetaData)paramMd, (ParameterMode)DesignSessionUtil.toParameterModeDesign((int)1));
        dataSetDesign.setParameters(paramDesign);
        if (paramDesign == null) {
            return;
        }
        paramDesign.setDerivedMetaData(true);
        if (paramDesign.getParameterDefinitions().size() > 0 && (paramDef = (ParameterDefinition)paramDesign.getParameterDefinitions().get(0)) != null) {
            paramDef.setDefaultScalarValue("dummy default value");
        }
    }

    private void closeConnection(IConnection conn) {
        try {
            if (conn != null && conn.isOpen()) {
                conn.close();
            }
        }
        catch (OdaException e) {
            e.printStackTrace();
        }
    }
}

