/*
 * Decompiled with CFR 0.152.
 */
package bpm.vanilla.platform.xstream;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateConverter
implements Converter {
    private static final String FORMAT_DATE = "dd/MM/yyyy HH:mm:ss";

    public boolean canConvert(Class clazz) {
        return Date.class.isAssignableFrom(clazz);
    }

    public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
        SimpleDateFormat formatter = new SimpleDateFormat(FORMAT_DATE);
        Date date = (Date)value;
        writer.setValue(formatter.format(date));
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        try {
            SimpleDateFormat formatter = new SimpleDateFormat(FORMAT_DATE);
            return formatter.parse(reader.getValue());
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Date();
        }
    }
}

