/*
 * Decompiled with CFR 0.152.
 */
package bpm.fwr.oda.ui.impl.datasource;

import bpm.fwr.oda.ui.Activator;
import bpm.fwr.oda.ui.impl.datasource.FwrDataSourcePage;
import bpm.vanilla.platform.core.IRepositoryApi;
import bpm.vanilla.platform.core.IRepositoryContext;
import bpm.vanilla.platform.core.IVanillaAPI;
import bpm.vanilla.platform.core.IVanillaContext;
import bpm.vanilla.platform.core.beans.Group;
import bpm.vanilla.platform.core.beans.User;
import bpm.vanilla.platform.core.impl.BaseRepositoryContext;
import bpm.vanilla.platform.core.impl.BaseVanillaContext;
import bpm.vanilla.platform.core.remote.RemoteRepositoryApi;
import bpm.vanilla.platform.core.remote.RemoteVanillaPlatform;
import bpm.vanilla.platform.core.repository.IRepository;
import bpm.vanilla.platform.core.repository.Repository;
import bpm.vanilla.platform.core.repository.RepositoryDirectory;
import bpm.vanilla.platform.core.repository.RepositoryItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ConnectionComposite
extends Composite {
    private Text url;
    private Text login;
    private Text password;
    private Collection<String> groups;
    private Combo groupNames;
    private Combo repositoryNames;
    private String groupName;
    private String repositoryName;
    private List<RepositoryDirectory> rootDirectories;
    private List<Group> listGroup;
    private List<bpm.vanilla.platform.core.beans.Repository> listRepositories;
    private Group selectedGroup;
    private bpm.vanilla.platform.core.beans.Repository selectedRepository;
    private RepositoryItem selectedFwrReport;
    protected TreeViewer viewer;
    private FwrDataSourcePage page;
    private IRepository repo;

    public ConnectionComposite(Composite parent, int style, FwrDataSourcePage page) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(2, false));
        this.page = page;
        this.buildContent();
    }

    public void buildContent() {
        Label log = new Label((Composite)this, 0);
        log.setLayoutData((Object)new GridData(1, 2, false, false));
        log.setText(Activator.getResourceString("ConnectionComposite.Username"));
        this.login = new Text((Composite)this, 2048);
        this.login.setLayoutData((Object)new GridData(4, 2, true, false));
        this.login.setText("system");
        Label pass = new Label((Composite)this, 0);
        pass.setLayoutData((Object)new GridData(1, 2, false, false));
        pass.setText(Activator.getResourceString("ConnectionComposite.Password"));
        this.password = new Text((Composite)this, 0x400800);
        this.password.setLayoutData((Object)new GridData(4, 2, true, false));
        this.password.setText("system");
        Label vanUrl = new Label((Composite)this, 0);
        vanUrl.setLayoutData((Object)new GridData(1, 2, false, false));
        vanUrl.setText(Activator.getResourceString("ConnectionComposite.VanillaUrl"));
        this.url = new Text((Composite)this, 2048);
        this.url.setLayoutData((Object)new GridData(4, 2, true, false));
        this.url.setText("http://localhost:7171/VanillaRuntime");
        Button connect = new Button((Composite)this, 0);
        connect.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        connect.setText(Activator.getResourceString("ConnectionComposite.ConnectVanilla"));
        connect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    RemoteVanillaPlatform api = new RemoteVanillaPlatform(ConnectionComposite.this.getUrl(), ConnectionComposite.this.login.getText(), ConnectionComposite.this.password.getText());
                    User user = api.getVanillaSecurityManager().getUserByLogin(ConnectionComposite.this.getLogin());
                    ConnectionComposite.this.initRepositories((IVanillaAPI)api, user);
                    ConnectionComposite.this.initGroups((IVanillaAPI)api, user);
                }
                catch (Exception ex) {
                    MessageDialog.openError((Shell)ConnectionComposite.this.getShell(), (String)Activator.getResourceString("ConnectionComposite.ErrorConnection"), (String)ex.getMessage());
                    ex.printStackTrace();
                }
            }
        });
        Label group = new Label((Composite)this, 0);
        group.setLayoutData((Object)new GridData(1, 2, false, false));
        group.setText(Activator.getResourceString("ConnectionComposite.10"));
        this.groupNames = new Combo((Composite)this, 8);
        this.groupNames.setLayoutData((Object)new GridData(4, 2, true, false));
        this.groupNames.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectionComposite.this.groupName = ConnectionComposite.this.groupNames.getText();
            }
        });
        Label rep = new Label((Composite)this, 0);
        rep.setLayoutData((Object)new GridData(1, 2, false, false));
        rep.setText(Activator.getResourceString("ConnectionComposite.12"));
        this.repositoryNames = new Combo((Composite)this, 8);
        this.repositoryNames.setLayoutData((Object)new GridData(4, 2, true, false));
        this.repositoryNames.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectionComposite.this.repositoryName = ConnectionComposite.this.repositoryNames.getText();
            }
        });
        Button load = new Button((Composite)this, 0);
        load.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        load.setText(Activator.getResourceString("ConnectionComposite.LoadRepository"));
        load.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectionComposite.this.selectedGroup = null;
                int i = 0;
                while (i < ConnectionComposite.this.listGroup.size()) {
                    if (ConnectionComposite.this.groupNames.getText().equals(((Group)ConnectionComposite.this.listGroup.get(i)).getName())) {
                        ConnectionComposite.this.selectedGroup = (Group)ConnectionComposite.this.listGroup.get(i);
                    }
                    ++i;
                }
                ConnectionComposite.this.selectedRepository = null;
                i = 0;
                while (i < ConnectionComposite.this.listRepositories.size()) {
                    if (ConnectionComposite.this.repositoryNames.getText().equals(((bpm.vanilla.platform.core.beans.Repository)ConnectionComposite.this.listRepositories.get(i)).getName())) {
                        ConnectionComposite.this.selectedRepository = (bpm.vanilla.platform.core.beans.Repository)ConnectionComposite.this.listRepositories.get(i);
                    }
                    ++i;
                }
                if (ConnectionComposite.this.selectedGroup != null && ConnectionComposite.this.selectedRepository != null) {
                    ConnectionComposite.this.loadData();
                }
            }
        });
        this.viewer = new TreeViewer((Composite)this, 268438274);
        this.viewer.getTree().setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.viewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                List l = (List)inputElement;
                return l.toArray(new Object[l.size()]);
            }

            public boolean hasChildren(Object element) {
                if (element instanceof RepositoryDirectory) {
                    try {
                        return ConnectionComposite.this.repo.getChildDirectories((RepositoryDirectory)element).size() != 0 || ConnectionComposite.this.repo.getItems((RepositoryDirectory)element).size() != 0;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return false;
            }

            public Object getParent(Object element) {
                return null;
            }

            public Object[] getChildren(Object parentElement) {
                ArrayList l = new ArrayList();
                if (parentElement instanceof RepositoryDirectory) {
                    try {
                        l.addAll(ConnectionComposite.this.repo.getChildDirectories((RepositoryDirectory)parentElement));
                        l.addAll(ConnectionComposite.this.repo.getItems((RepositoryDirectory)parentElement));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return l.toArray(new Object[l.size()]);
            }
        });
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof RepositoryDirectory) {
                    RepositoryDirectory dir = (RepositoryDirectory)element;
                    return dir.getName();
                }
                RepositoryItem item = (RepositoryItem)element;
                return item.getItemName();
            }

            public Image getImage(Object obj) {
                if (obj instanceof RepositoryDirectory) {
                    return Activator.getDefault().getImageRegistry().get("directory");
                }
                if (obj instanceof RepositoryItem) {
                    return Activator.getDefault().getImageRegistry().get("directoryItem");
                }
                return null;
            }
        });
    }

    private void initRepositories(IVanillaAPI api, User user) {
        try {
            this.listRepositories = api.getVanillaRepositoryManager().getUserRepositories(user.getLogin());
            String[] items = new String[this.listRepositories.size()];
            int i = 0;
            for (bpm.vanilla.platform.core.beans.Repository c : this.listRepositories) {
                items[i++] = c.getName();
            }
            this.repositoryNames.setItems(items);
            i = 0;
        }
        catch (Exception ex2) {
            ex2.printStackTrace();
        }
    }

    private void initGroups(IVanillaAPI api, User user) {
        try {
            this.listGroup = api.getVanillaSecurityManager().getGroups(user);
            String[] groups = new String[this.listGroup.size()];
            int i = 0;
            for (Group c : this.listGroup) {
                groups[i++] = c.getName();
            }
            this.groupNames.setItems(groups);
            i = 0;
            for (Group c : this.listGroup) {
                if (c.getName().equals("System")) {
                    this.groupNames.select(i);
                }
                ++i;
            }
        }
        catch (Exception ex3) {
            ex3.printStackTrace();
        }
    }

    public void loadData() {
        BaseVanillaContext vanillaContext = new BaseVanillaContext(this.url.getText(), this.login.getText(), this.password.getText());
        BaseRepositoryContext ctx = new BaseRepositoryContext((IVanillaContext)vanillaContext, this.selectedGroup, this.selectedRepository);
        RemoteRepositoryApi connection = new RemoteRepositoryApi((IRepositoryContext)ctx);
        try {
            this.repo = new Repository((IRepositoryApi)connection, 4);
            this.rootDirectories = this.repo.getRootDirectories();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        this.viewer.setInput(this.rootDirectories);
    }

    public String getUrl() {
        return this.url.getText();
    }

    public String getLogin() {
        return this.login.getText();
    }

    public String getPassword() {
        return this.password.getText();
    }

    public int getSelectedGroupId() {
        return this.selectedGroup.getId();
    }

    public String getSelectedGroupName() {
        return this.selectedGroup.getName();
    }

    public String getSelectedRepositoryUrl() {
        return this.selectedRepository.getUrl();
    }

    public int getFWReportId() throws Exception {
        IStructuredSelection ss = (IStructuredSelection)this.viewer.getSelection();
        if (ss.isEmpty() || !(ss.getFirstElement() instanceof RepositoryItem)) {
            throw new Exception("No FreeWebReport has been select.");
        }
        return ((RepositoryItem)ss.getFirstElement()).getId();
    }
}

