/*
 * Decompiled with CFR 0.152.
 */
package bpm.fwr.oda.ui.impl.dataset;

import bpm.fwr.api.beans.FWRReport;
import bpm.fwr.api.beans.dataset.Column;
import bpm.fwr.api.beans.dataset.DataSet;
import bpm.fwr.api.beans.dataset.FWRFilter;
import bpm.fwr.oda.runtime.impl.ConnectionManager;
import bpm.fwr.oda.runtime.impl.DatasHelper;
import bpm.vanilla.platform.core.IRepositoryApi;
import java.util.List;
import java.util.Properties;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSetWizardPage;
import org.eclipse.datatools.connectivity.oda.design.util.DesignUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.TableColumn;

public class FwrDataSetPage
extends DataSetWizardPage {
    private TableViewer tableViewer;
    private TableViewer tableDataSetViewer;
    private TableViewer tableFWRFilters;
    private Document document;

    public FwrDataSetPage(String pageName) {
        super(pageName);
    }

    public FwrDataSetPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createPageCustomControl(Composite parent) {
        this.setControl(this.createPageControl(parent));
        try {
            this.initialiseControl();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Control createPageControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, true));
        ISelectionChangedListener selLst = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection ss = (IStructuredSelection)event.getSelection();
                if (ss.isEmpty() || !(ss.getFirstElement() instanceof DataSet)) {
                    return;
                }
                List inputColumn = ((DataSet)ss.getFirstElement()).getColumns();
                List inputFilter = ((DataSet)ss.getFirstElement()).getFwrFilters();
                FwrDataSetPage.this.tableDataSetViewer.setInput((Object)inputColumn);
                FwrDataSetPage.this.tableFWRFilters.setInput((Object)inputFilter);
            }
        };
        this.tableViewer = new TableViewer(container, 268438274);
        this.tableViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                List dataSets = (List)inputElement;
                return dataSets.toArray(new Object[dataSets.size()]);
            }
        });
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof DataSet) {
                    return ((DataSet)element).getName();
                }
                return null;
            }
        });
        this.tableViewer.addSelectionChangedListener(selLst);
        TabFolder folder = new TabFolder(container, 0);
        folder.setLayout((Layout)new GridLayout(2, false));
        folder.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.tableDataSetViewer = new TableViewer((Composite)folder, 268438274);
        this.tableDataSetViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.tableDataSetViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                List columns = (List)inputElement;
                return columns.toArray(new Object[columns.size()]);
            }
        });
        this.tableDataSetViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Column) {
                    return ((Column)element).getName();
                }
                return null;
            }
        });
        TabItem tabDataSet = new TabItem(folder, 0);
        tabDataSet.setText("DataSet");
        tabDataSet.setControl((Control)this.tableDataSetViewer.getTable());
        this.tableFWRFilters = new TableViewer((Composite)folder, 268503810);
        this.tableFWRFilters.getTable().setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.tableFWRFilters.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                List columns = (List)inputElement;
                return columns.toArray(new Object[columns.size()]);
            }
        });
        this.tableFWRFilters.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public String getColumnText(Object element, int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return ((FWRFilter)element).getName();
                    }
                    case 1: {
                        return ((FWRFilter)element).getColumnName();
                    }
                    case 2: {
                        if (((FWRFilter)element).getOperator() != null) {
                            return ((FWRFilter)element).getOperator();
                        }
                        return "";
                    }
                    case 3: {
                        List values = ((FWRFilter)element).getValues();
                        String value = null;
                        if (!values.isEmpty()) {
                            if (values.size() == 1) {
                                value = (String)values.get(0);
                            } else {
                                for (String str : values) {
                                    value = String.valueOf(value) + " + " + str;
                                }
                            }
                        }
                        return value;
                    }
                }
                return "";
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }
        });
        TabItem tabFilter = new TabItem(folder, 0);
        tabFilter.setText("FWR Filters");
        tabFilter.setControl((Control)this.tableFWRFilters.getTable());
        TableColumn name = new TableColumn(this.tableFWRFilters.getTable(), 0);
        name.setText("Name");
        name.setWidth(80);
        TableColumn format = new TableColumn(this.tableFWRFilters.getTable(), 0);
        format.setText("DataSet Column");
        format.setWidth(250);
        TableColumn comment = new TableColumn(this.tableFWRFilters.getTable(), 0);
        comment.setText("Operator");
        comment.setWidth(100);
        TableColumn version = new TableColumn(this.tableFWRFilters.getTable(), 0);
        version.setText("Values");
        version.setWidth(80);
        this.tableFWRFilters.getTable().setHeaderVisible(true);
        this.tableFWRFilters.getTable().setLinesVisible(true);
        return container;
    }

    private void initialiseControl() throws Exception {
        FWRReport model = this.initialiseFwrReport();
        DataSetDesign dataSetDesign = this.getInitializationDesign();
        if (dataSetDesign == null || dataSetDesign.getQueryText() == null || dataSetDesign.getQueryText().trim().equals("")) {
            List dataSets;
            List input = dataSets = model.getAllDatasets();
            this.tableViewer.setInput((Object)input);
        } else {
            String datasetname = this.restoreSelection(dataSetDesign, model);
            List dataSets = model.getAllDatasets();
            DataSet dataset = null;
            boolean found = false;
            for (DataSet ds : dataSets) {
                if (!ds.getName().equals(datasetname)) continue;
                found = true;
                dataset = ds;
            }
            if (found) {
                DataSet datasetobject = dataset;
                List input = dataSets;
                this.tableViewer.setInput((Object)input);
                this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)datasetobject));
            } else {
                throw new Exception("The dataset does not exist");
            }
        }
    }

    protected DataSetDesign collectDataSetDesign(DataSetDesign design) {
        Properties connProps = DesignUtil.convertDataSourceProperties((DataSourceDesign)this.getInitializationDesign().getDataSourceDesign());
        IRepositoryApi conn = null;
        try {
            conn = ConnectionManager.getConnection((Properties)connProps);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DataSet ds = null;
        FWRReport model = this.initialiseFwrReport();
        DataSetDesign dataSetDesign = this.getInitializationDesign();
        if (dataSetDesign == null || dataSetDesign.getQueryText() == null || dataSetDesign.getQueryText().trim().equals("")) {
            IStructuredSelection ss = (IStructuredSelection)this.tableViewer.getSelection();
            if (ss.isEmpty() || !(ss.getFirstElement() instanceof DataSet)) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"No DataSet has been choose.");
            }
            ds = (DataSet)ss.getFirstElement();
        } else {
            String datasetname = this.restoreSelection(dataSetDesign, model);
            List dataSets = model.getAllDatasets();
            for (DataSet datas : dataSets) {
                if (!datas.getName().equals(datasetname)) continue;
                ds = datas;
            }
        }
        ds.getDatasource().setUrl(conn.getContext().getRepository().getUrl());
        String propertiesPart = ds.getDatasource().getXml();
        String query = DatasHelper.getInstance().buildQuery(ds, conn);
        query = "<rootElement>\n<dataSet>\n<dataSetName>" + ds.getName() + "</dataSetName>\n</dataSet>\n" + propertiesPart + query + "</rootElement>";
        design.setQueryText(query);
        return design;
    }

    private FWRReport initialiseFwrReport() {
        Properties connProps = DesignUtil.convertDataSourceProperties((DataSourceDesign)this.getInitializationDesign().getDataSourceDesign());
        FWRReport model = null;
        try {
            model = ConnectionManager.getFWRReport((Properties)connProps);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return model;
    }

    private String restoreSelection(DataSetDesign dataSetDesign, FWRReport model) {
        try {
            this.document = DocumentHelper.parseText((String)dataSetDesign.getQueryText());
        }
        catch (DocumentException e1) {
            e1.printStackTrace();
        }
        Element e = this.document.getRootElement().element("dataSet");
        if (e.element("dataSetName") != null) {
            Element d = e.element("dataSetName");
            if (d != null) {
                return d.getStringValue();
            }
            return null;
        }
        return null;
    }
}

