/*
 * Decompiled with CFR 0.152.
 */
package bpm.vanilla.listdata.oda.driver.ui.impl;

import bpm.vanilla.platform.core.beans.Group;
import bpm.vanilla.platform.core.beans.Repository;
import bpm.vanilla.platform.core.beans.User;
import bpm.vanilla.platform.core.remote.RemoteVanillaPlatform;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Properties;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSourceWizardPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;

public class DataSourcePage
extends DataSourceWizardPage {
    private Text login;
    private Text password;
    private Text vanillaUrl;
    private ComboViewer repositories;
    private ComboViewer groups;
    private Button loadRepositories;
    private Properties initialProps;

    public DataSourcePage(String pageName) {
        super(pageName);
    }

    public DataSourcePage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public Properties collectCustomProperties() {
        Properties prop = new Properties();
        prop.setProperty("vanillaUrl", this.vanillaUrl.getText());
        prop.setProperty("vanillaLogin", this.login.getText());
        prop.setProperty("vanillaPassword", this.password.getText());
        prop.setProperty("vanillaRepositoryId", "" + ((Repository)((IStructuredSelection)this.repositories.getSelection()).getFirstElement()).getId());
        prop.setProperty("groupId", "" + ((Group)((IStructuredSelection)this.groups.getSelection()).getFirstElement()).getId());
        return prop;
    }

    public void createPageCustomControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout(2, false));
        Label l = new Label(main, 0);
        l.setLayoutData((Object)new GridData(1, 2, false, false));
        l.setText("Vanilla Url");
        this.vanillaUrl = new Text(main, 2048);
        this.vanillaUrl.setLayoutData((Object)new GridData(4, 2, true, false));
        l = new Label(main, 0);
        l.setLayoutData((Object)new GridData(1, 2, false, false));
        l.setText("Vanilla Login");
        this.login = new Text(main, 2048);
        this.login.setLayoutData((Object)new GridData(4, 2, true, false));
        this.login.addModifyListener((ModifyListener)new TextListener());
        l = new Label(main, 0);
        l.setLayoutData((Object)new GridData(1, 2, false, false));
        l.setText("Vanilla Password");
        this.password = new Text(main, 0x400800);
        this.password.setLayoutData((Object)new GridData(4, 2, true, false));
        this.password.addModifyListener((ModifyListener)new TextListener());
        this.loadRepositories = new Button(main, 8);
        this.loadRepositories.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        this.loadRepositories.setText("Connect");
        this.loadRepositories.setEnabled(false);
        this.loadRepositories.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    DataSourcePage.this.loadRepositories();
                }
                catch (Exception ex) {
                    MessageDialog.openError((Shell)DataSourcePage.this.getShell(), (String)"Unable to load repositories", (String)ex.getMessage());
                }
            }
        });
        l = new Label(main, 0);
        l.setLayoutData((Object)new GridData(1, 2, false, false));
        l.setText("Group");
        this.groups = new ComboViewer(main, 8);
        this.groups.getControl().setLayoutData((Object)new GridData(4, 2, true, false));
        this.groups.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                Collection c = (Collection)inputElement;
                return c.toArray(new Object[c.size()]);
            }
        });
        this.groups.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((Group)element).getName();
            }
        });
        l = new Label(main, 0);
        l.setLayoutData((Object)new GridData(1, 2, false, false));
        l.setText("Repository");
        this.repositories = new ComboViewer(main, 8);
        this.repositories.getControl().setLayoutData((Object)new GridData(4, 2, true, false));
        this.repositories.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                Collection c = (Collection)inputElement;
                return c.toArray(new Object[c.size()]);
            }
        });
        this.repositories.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((Repository)element).getName();
            }
        });
        this.fill();
    }

    private void fill() {
        if (this.initialProps == null) {
            this.loadPreferences();
            return;
        }
        this.vanillaUrl.setText(this.initialProps.getProperty("vanillaUrl"));
        this.login.setText(this.initialProps.getProperty("vanillaLogin"));
        this.password.setText(this.initialProps.getProperty("vanillaPassword"));
        int id = Integer.parseInt(this.initialProps.getProperty("vanillaRepositoryId"));
        try {
            this.loadRepositories();
            for (Repository d : (Collection)this.repositories.getInput()) {
                if (d.getId() != id) continue;
                this.repositories.setSelection((ISelection)new StructuredSelection((Object)d));
                break;
            }
            try {
                id = Integer.parseInt(this.initialProps.getProperty("groupId"));
                for (Repository d : (Collection)this.groups.getInput()) {
                    if (d.getId() != id) continue;
                    this.groups.setSelection((ISelection)new StructuredSelection((Object)d));
                    break;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        catch (Exception ex) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Unable to load repositories", (String)ex.getMessage());
        }
    }

    public void setInitialProperties(Properties dataSourceProps) {
        this.initialProps = dataSourceProps;
    }

    private void loadRepositories() throws Exception {
        User vanillaUser = null;
        RemoteVanillaPlatform api = new RemoteVanillaPlatform(this.vanillaUrl.getText(), this.login.getText(), this.password.getText());
        try {
            vanillaUser = api.getVanillaSecurityManager().getUserByLogin(this.login.getText());
        }
        catch (Exception ex) {
            throw new OdaException("Unable to fnd User, " + ex.getMessage());
        }
        if (vanillaUser == null) {
            throw new OdaException("The User " + this.login.getText() + " does not exist.");
        }
        this.repositories.setInput((Object)api.getVanillaRepositoryManager().getUserRepositories(vanillaUser.getLogin()));
        this.groups.setInput((Object)api.getVanillaSecurityManager().getGroups(vanillaUser));
    }

    private void loadPreferences() {
        try {
            Bundle bundle = Platform.getBundle((String)"bpm.oda.driver.reader");
            String activator = (String)bundle.getHeaders().get("Bundle-Activator");
            Class activatorClass = bundle.loadClass(activator);
            Method method = activatorClass.getMethod("getDefault", new Class[0]);
            AbstractUIPlugin plugin = (AbstractUIPlugin)method.invoke(null, new Object[0]);
            this.vanillaUrl.setText(plugin.getPreferenceStore().getString("bpm.oda.driver.reader.preferences.vanillaUrl"));
            this.login.setText(plugin.getPreferenceStore().getString("bpm.oda.driver.reader.preferences.vanillaLogin"));
            this.password.setText(plugin.getPreferenceStore().getString("bpm.oda.driver.reader.preferences.vanillaPassword"));
        }
        catch (Throwable throwable) {}
    }

    private class TextListener
    implements ModifyListener {
        private TextListener() {
        }

        public void modifyText(ModifyEvent e) {
            DataSourcePage.this.loadRepositories.setEnabled(!"".equals(DataSourcePage.this.login.getText()) && !"".equals(DataSourcePage.this.password.getText()));
        }
    }
}

