/*
 * Decompiled with CFR 0.152.
 */
package bpm.vanilla.listdata.oda.driver.ui.impl;

import bpm.vanilla.listdata.oda.driver.impl.Driver;
import bpm.vanilla.platform.core.IRepositoryContext;
import bpm.vanilla.platform.core.IVanillaContext;
import bpm.vanilla.platform.core.beans.Repository;
import bpm.vanilla.platform.core.beans.User;
import bpm.vanilla.platform.core.impl.BaseRepositoryContext;
import bpm.vanilla.platform.core.impl.BaseVanillaContext;
import bpm.vanilla.platform.core.remote.RemoteRepositoryApi;
import bpm.vanilla.platform.core.remote.RemoteVanillaPlatform;
import bpm.vanilla.platform.core.repository.DatasProvider;
import bpm.vanilla.platform.core.repository.services.IDataProviderService;
import bpm.vanilla.platform.core.utils.MD5Helper;
import java.util.Collection;
import java.util.Properties;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IParameterMetaData;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DataSetParameters;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.DesignFactory;
import org.eclipse.datatools.connectivity.oda.design.ParameterDefinition;
import org.eclipse.datatools.connectivity.oda.design.ParameterMode;
import org.eclipse.datatools.connectivity.oda.design.ResultSetColumns;
import org.eclipse.datatools.connectivity.oda.design.ResultSetDefinition;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DesignSessionUtil;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSetWizardPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class CustomDataSetWizardPage
extends DataSetWizardPage {
    private static String DEFAULT_MESSAGE = "Define the query text for the data set";
    private ComboViewer datasProviders;
    private IDataProviderService dataProviderAdmin;

    public CustomDataSetWizardPage(String pageName) {
        super(pageName);
        this.setTitle(pageName);
        this.setMessage(DEFAULT_MESSAGE);
    }

    public CustomDataSetWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.setMessage(DEFAULT_MESSAGE);
    }

    public void createPageCustomControl(Composite parent) {
        this.setControl(this.createPageControl(parent));
        this.initializeControl();
    }

    private Control createPageControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(1808));
        Label l = new Label(composite, 0);
        l.setText("DatasProvider");
        this.datasProviders = new ComboViewer(composite, 8);
        this.datasProviders.getControl().setLayoutData((Object)new GridData(4, 2, true, false));
        this.datasProviders.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                Collection c = (Collection)inputElement;
                return c.toArray(new Object[c.size()]);
            }
        });
        this.datasProviders.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((DatasProvider)element).getName();
            }
        });
        this.datasProviders.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CustomDataSetWizardPage.this.validateData();
            }
        });
        this.setPageComplete(false);
        return composite;
    }

    private void initWidgets() {
        try {
            Properties initialProps = DesignSessionUtil.getEffectiveDataSourceProperties((DataSourceDesign)this.getInitializationDesign().getDataSourceDesign());
            String vanillaUrl = initialProps.getProperty("vanillaUrl");
            String login = initialProps.getProperty("vanillaLogin");
            String password = initialProps.getProperty("vanillaPassword");
            int id = Integer.parseInt(initialProps.getProperty("vanillaRepositoryId"));
            Integer groupid = -1;
            try {
                groupid = Integer.parseInt(initialProps.getProperty("groupId"));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            User vanillaUser = null;
            RemoteVanillaPlatform api = new RemoteVanillaPlatform(vanillaUrl, login, password);
            try {
                vanillaUser = api.getVanillaSecurityManager().getUserByLogin(login);
            }
            catch (Exception ex) {
                throw new OdaException("Unable to fnd User, " + ex.getMessage());
            }
            if (vanillaUser == null) {
                throw new OdaException("The User " + login + " does not exist.");
            }
            String pass = password;
            if (!pass.matches("[0-9a-f]{32}")) {
                pass = MD5Helper.encode((String)pass);
            }
            if (!vanillaUser.getPassword().equals(pass)) {
                throw new OdaException("Bad password.");
            }
            try {
                Repository def = null;
                for (Repository d : api.getVanillaRepositoryManager().getUserRepositories(vanillaUser.getLogin())) {
                    if (d.getId() != id) continue;
                    def = d;
                    break;
                }
                BaseVanillaContext vanillaContext = new BaseVanillaContext(vanillaUrl, login, password);
                BaseRepositoryContext ctx = new BaseRepositoryContext((IVanillaContext)vanillaContext, api.getVanillaSecurityManager().getGroupById(groupid.intValue()), def);
                RemoteRepositoryApi socket = new RemoteRepositoryApi((IRepositoryContext)ctx);
                this.dataProviderAdmin = socket.getDatasProviderService();
                this.datasProviders.setInput((Object)this.dataProviderAdmin.getAll());
            }
            catch (Exception ex) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Unable to load repositories", (String)ex.getMessage());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MessageDialog.openError((Shell)this.getShell(), (String)"Initialiation problem", (String)e.getMessage());
        }
    }

    private void initializeControl() {
        this.initWidgets();
        DataSetDesign dataSetDesign = this.getInitializationDesign();
        if (dataSetDesign == null) {
            return;
        }
        String queryText = dataSetDesign.getQueryText();
        if (queryText == null) {
            return;
        }
        try {
            for (DatasProvider d : (Collection)this.datasProviders.getInput()) {
                if (d.getId() != Integer.parseInt(queryText)) continue;
                this.datasProviders.setSelection((ISelection)new StructuredSelection((Object)d));
                break;
            }
        }
        catch (Exception exception) {}
        this.validateData();
        this.setMessage(DEFAULT_MESSAGE);
    }

    private String getQueryText() {
        try {
            return "" + ((DatasProvider)((IStructuredSelection)this.datasProviders.getSelection()).getFirstElement()).getId();
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected DataSetDesign collectDataSetDesign(DataSetDesign design) {
        if (this.getControl() == null) {
            return design;
        }
        if (!this.hasValidData()) {
            return null;
        }
        this.savePage(design);
        return design;
    }

    protected void collectResponseState() {
        super.collectResponseState();
    }

    protected boolean canLeave() {
        return this.isPageComplete();
    }

    private void validateData() {
        boolean isValid;
        boolean bl = isValid = !this.datasProviders.getSelection().isEmpty();
        if (isValid) {
            this.setMessage(DEFAULT_MESSAGE);
        } else {
            this.setMessage("Requires input value.", 3);
        }
        this.setPageComplete(isValid);
    }

    private boolean hasValidData() {
        this.validateData();
        return this.canLeave();
    }

    private void savePage(DataSetDesign dataSetDesign) {
        block5: {
            String queryText = this.getQueryText();
            dataSetDesign.setQueryText(queryText);
            IConnection customConn = null;
            try {
                try {
                    Driver customDriver = new Driver();
                    customConn = customDriver.getConnection(null);
                    Properties connProps = DesignSessionUtil.getEffectiveDataSourceProperties((DataSourceDesign)this.getInitializationDesign().getDataSourceDesign());
                    customConn.open(connProps);
                    this.updateDesign(dataSetDesign, customConn, queryText);
                }
                catch (OdaException e) {
                    dataSetDesign.setResultSets(null);
                    dataSetDesign.setParameters(null);
                    e.printStackTrace();
                    this.closeConnection(customConn);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                this.closeConnection(customConn);
                throw throwable;
            }
            this.closeConnection(customConn);
        }
    }

    private void updateDesign(DataSetDesign dataSetDesign, IConnection conn, String queryText) throws OdaException {
        IQuery query = conn.newQuery(null);
        query.prepare(queryText);
        try {
            IResultSetMetaData md = query.getMetaData();
            this.updateResultSetDesign(md, dataSetDesign);
        }
        catch (OdaException e) {
            dataSetDesign.setResultSets(null);
            e.printStackTrace();
        }
        try {
            IParameterMetaData paramMd = query.getParameterMetaData();
            this.updateParameterDesign(paramMd, dataSetDesign);
        }
        catch (OdaException ex) {
            dataSetDesign.setParameters(null);
            ex.printStackTrace();
        }
    }

    private void updateResultSetDesign(IResultSetMetaData md, DataSetDesign dataSetDesign) throws OdaException {
        ResultSetColumns columns = DesignSessionUtil.toResultSetColumnsDesign((IResultSetMetaData)md);
        ResultSetDefinition resultSetDefn = DesignFactory.eINSTANCE.createResultSetDefinition();
        resultSetDefn.setResultSetColumns(columns);
        dataSetDesign.setPrimaryResultSet(resultSetDefn);
        dataSetDesign.getResultSets().setDerivedMetaData(true);
    }

    private void updateParameterDesign(IParameterMetaData paramMd, DataSetDesign dataSetDesign) throws OdaException {
        ParameterDefinition paramDef;
        DataSetParameters paramDesign = DesignSessionUtil.toDataSetParametersDesign((IParameterMetaData)paramMd, (ParameterMode)DesignSessionUtil.toParameterModeDesign((int)1));
        dataSetDesign.setParameters(paramDesign);
        if (paramDesign == null) {
            return;
        }
        paramDesign.setDerivedMetaData(true);
        if (paramDesign.getParameterDefinitions().size() > 0 && (paramDef = (ParameterDefinition)paramDesign.getParameterDefinitions().get(0)) != null) {
            paramDef.setDefaultScalarValue("dummy default value");
        }
    }

    private void closeConnection(IConnection conn) {
        try {
            if (conn != null && conn.isOpen()) {
                conn.close();
            }
        }
        catch (OdaException e) {
            e.printStackTrace();
        }
    }
}

