/*
 * Decompiled with CFR 0.152.
 */
package bpm.studio.expressions.core.measures.impl;

import bpm.studio.expressions.core.measures.IOperand;
import bpm.studio.expressions.core.measures.IOperator;

public class Operation
implements IOperand {
    private IOperator operator;
    private IOperand[] operands;

    public Operation(IOperator operator) {
        this.operator = operator;
        this.operands = new IOperand[this.operator.getOperandNumber()];
    }

    @Override
    public IOperand getOperand(int pos) {
        return this.operands[pos];
    }

    @Override
    public IOperand[] getOperands() {
        return this.operands;
    }

    @Override
    public IOperator getOperator() {
        return this.operator;
    }

    @Override
    public void setOperand(int pos, IOperand operand) throws Exception {
        if (pos >= this.getOperator().getOperandNumber()) {
            throw new Exception("Operator " + this.getOperator().getSymbol() + " have only " + this.getOperator().getOperandNumber() + " operands");
        }
        this.operands[pos] = operand;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.getOperator().getOperandNumber() > 0) {
            buf.append("(");
        }
        buf.append(this.getOperator().getSymbol());
        int i = 0;
        while (i < this.getOperands().length) {
            buf.append(", ");
            if (this.getOperand(i) == null) {
                buf.append("<?>");
            } else {
                buf.append(this.getOperand(i).toString());
            }
            ++i;
        }
        if (this.getOperator().getOperandNumber() > 0) {
            buf.append(")");
        }
        return buf.toString();
    }

    @Override
    public void validate() throws Exception {
        int i = 0;
        while (i < this.getOperator().getOperandNumber()) {
            if (this.getOperand(i) == null) {
                throw new Exception("Missing Operand number " + i);
            }
            this.getOperand(i).validate();
            ++i;
        }
    }
}

