/*
 * Decompiled with CFR 0.152.
 */
package bpm.studio.expressions.core.measures.impl;

import bpm.studio.expressions.core.measures.IOperand;
import bpm.studio.expressions.core.measures.IOperator;
import bpm.studio.expressions.core.measures.impl.AggregationOperator;
import bpm.studio.expressions.core.measures.impl.ConditionOperator;
import bpm.studio.expressions.core.measures.impl.Dimension;
import bpm.studio.expressions.core.measures.impl.DimensionFunctionOperator;
import bpm.studio.expressions.core.measures.impl.DimensionLevel;
import bpm.studio.expressions.core.measures.impl.LiteralOperator;
import bpm.studio.expressions.core.measures.impl.MathOperator;
import bpm.studio.expressions.core.measures.impl.Measure;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class MeasureParser {
    private static char START_TAG = (char)40;
    private static char END_TAG = (char)41;
    private static char OPERAND_SEPARATOR = (char)44;
    private static char SPACE = (char)32;
    private List<Measure> availableMeasures = new ArrayList<Measure>();
    private List<DimensionLevel> levels = new ArrayList<DimensionLevel>();
    private List<Dimension> dimensions = new ArrayList<Dimension>();

    public MeasureParser(List<Measure> availableMeasures, List<DimensionLevel> levels, List<Dimension> dimensions) {
        this.availableMeasures = availableMeasures;
        this.levels = levels;
        this.dimensions = dimensions;
    }

    protected List<IOperator> getOperators() {
        IOperator op;
        ArrayList<IOperator> l = new ArrayList<IOperator>();
        IOperator[] iOperatorArray = MathOperator.operators;
        int n = MathOperator.operators.length;
        int n2 = 0;
        while (n2 < n) {
            op = iOperatorArray[n2];
            l.add(op);
            ++n2;
        }
        iOperatorArray = AggregationOperator.operators;
        n = AggregationOperator.operators.length;
        n2 = 0;
        while (n2 < n) {
            op = iOperatorArray[n2];
            l.add(op);
            ++n2;
        }
        iOperatorArray = ConditionOperator.operators;
        n = ConditionOperator.operators.length;
        n2 = 0;
        while (n2 < n) {
            op = iOperatorArray[n2];
            l.add(op);
            ++n2;
        }
        iOperatorArray = DimensionFunctionOperator.operators;
        n = DimensionFunctionOperator.operators.length;
        n2 = 0;
        while (n2 < n) {
            IOperator m = iOperatorArray[n2];
            l.add(m);
            ++n2;
        }
        return l;
    }

    public IOperand getOperand(String operatorName) throws Exception {
        IOperator result = null;
        for (IOperator iOperator : this.getOperators()) {
            if (!iOperator.getSymbol().equals(operatorName)) continue;
            result = iOperator;
            break;
        }
        for (Measure measure : this.availableMeasures) {
            if (!measure.getSymbol().equals(operatorName)) continue;
            result = measure;
            break;
        }
        for (DimensionLevel dimensionLevel : this.levels) {
            if (!dimensionLevel.getSymbol().equals(operatorName)) continue;
            result = dimensionLevel;
            break;
        }
        for (Dimension dimension : this.dimensions) {
            if (!dimension.getSymbol().equals(operatorName)) continue;
            result = dimension;
            break;
        }
        if (result == null && Pattern.matches("\\'.*\\'", operatorName.trim())) {
            result = new LiteralOperator(operatorName.trim());
        }
        if (result == null && Pattern.matches("\\<[a-zA-Z]\\>", operatorName.trim())) {
            throw new Exception("Undefined argument " + operatorName);
        }
        if (result == null) {
            throw new Exception("Undefined operatorName " + operatorName);
        }
        return result.createOperation();
    }

    public IOperand readChunk(InputStream formula) throws Exception {
        StringBuffer buf = new StringBuffer();
        int lastRead = 0;
        IOperand currentOp = null;
        int currentPos = -1;
        while ((lastRead = formula.read()) != -1) {
            IOperand op;
            char c = (char)lastRead;
            if (c == START_TAG) {
                buf = new StringBuffer();
                if (currentOp == null) {
                    currentOp = this.readChunk(formula);
                    continue;
                }
                ++currentPos;
                if (currentOp.getOperator().getOperandNumber() <= 0) continue;
                currentOp.setOperand(currentPos, this.readChunk(formula));
                continue;
            }
            if (c == OPERAND_SEPARATOR) {
                if (buf.length() == 0) continue;
                op = null;
                try {
                    op = this.getOperand(buf.toString().trim());
                }
                catch (Exception ex) {
                    if (currentOp != null) {
                        throw new Exception(String.valueOf(currentOp.toString()) + " : " + ex.getMessage());
                    }
                    throw ex;
                }
                buf = new StringBuffer();
                if (currentOp == null) {
                    currentOp = op;
                    continue;
                }
                ++currentPos;
                if (currentOp.getOperator().getOperandNumber() <= 0) continue;
                currentOp.setOperand(currentPos, op);
                continue;
            }
            if (c == END_TAG) {
                if (buf.length() != 0) {
                    op = null;
                    try {
                        op = this.getOperand(buf.toString().trim());
                    }
                    catch (Exception ex) {
                        if (currentOp != null) {
                            throw new Exception(String.valueOf(currentOp.toString()) + " : " + ex.getMessage());
                        }
                        throw ex;
                    }
                    buf = new StringBuffer();
                    if (currentOp == null) {
                        currentOp = op;
                    } else {
                        ++currentPos;
                        if (currentOp.getOperator().getOperandNumber() > 0) {
                            currentOp.setOperand(currentPos, op);
                        }
                    }
                }
                return currentOp;
            }
            if (c == SPACE) continue;
            buf.append(c);
        }
        return currentOp;
    }
}

