/*
 * Decompiled with CFR 0.152.
 */
package bpm.studio.expressions.core.measures.impl;

import bpm.studio.expressions.core.measures.IClause;
import bpm.studio.expressions.core.measures.IOperand;
import bpm.studio.expressions.core.measures.IOperator;
import bpm.studio.expressions.core.measures.impl.Operation;
import java.util.ArrayList;
import java.util.List;

public class ConditionOperator
implements IOperator {
    public static int IF = 0;
    public static int EQU = 1;
    public static int LT = 2;
    public static int LT_EQ = 3;
    public static int GT = 4;
    public static int GT_EQ = 5;
    public static ConditionOperator[] operators = new ConditionOperator[]{new ConditionOperator("if", 3), new ConditionOperator("==", 2), new ConditionOperator("<", 2), new ConditionOperator("<=", 2), new ConditionOperator(">", 2), new ConditionOperator(">=", 2)};
    private int operandNumber;
    private String symbol;
    private String template;

    private ConditionOperator(String symbol, int operandNumber) {
        this.operandNumber = operandNumber;
        this.symbol = symbol;
    }

    @Override
    public int getOperandNumber() {
        return this.operandNumber;
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    @Override
    public boolean supportClauses() {
        return false;
    }

    public IClause getClause(int pos) {
        return null;
    }

    public List<IClause> getClauses() {
        return new ArrayList<IClause>();
    }

    public int getClausesSize() {
        return 0;
    }

    @Override
    public String getTemplate() {
        if (this.template == null) {
            StringBuffer buf = new StringBuffer();
            buf.append(" ( " + this.getSymbol());
            int i = 0;
            while (i < this.operandNumber) {
                buf.append(", <" + (char)(97 + i) + ">");
                ++i;
            }
            buf.append(") ");
            this.template = buf.toString();
        }
        return this.template;
    }

    @Override
    public IOperand createOperation() {
        return new Operation(this);
    }
}

