/*
 * Decompiled with CFR 0.152.
 */
package bpm.connection.manager.connection.jdbc;

import bpm.connection.manager.connection.ConnectionManager;
import bpm.connection.manager.connection.jdbc.VanillaJdbcConnection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.Date;
import org.apache.log4j.Logger;

public class VanillaPreparedStatement {
    private PreparedStatement preparedStatement;
    private String actualQuery;
    private int scroll = -1;
    private int concur = -1;
    private VanillaJdbcConnection connection;

    public VanillaPreparedStatement(VanillaJdbcConnection connection, String query) throws Exception {
        this.actualQuery = query;
        if (query == null || query.isEmpty()) {
            query = connection.getDriverClass().equals("org.apache.derby.jdbc.EmbeddedDriver") ? "values 1" : (connection.getDriverClass().equals("com.ibm.as400.access.AS400JDBCDriver") ? "SELECT 1 FROM SYSIBM.SYSDUMMY1" : "select 1");
        }
        this.preparedStatement = connection.getJdbcConnection().prepareStatement(query);
        this.connection = connection;
    }

    public VanillaPreparedStatement(VanillaJdbcConnection vanillaJdbcConnection, String query, int resultSetType, int resultSetConcurrency) throws Exception {
        this.actualQuery = query;
        if (query == null || query.isEmpty()) {
            query = vanillaJdbcConnection.getDriverClass().equals("org.apache.derby.jdbc.EmbeddedDriver") ? "values 1" : (vanillaJdbcConnection.getDriverClass().equals("com.ibm.as400.access.AS400JDBCDriver") ? "SELECT 1 FROM SYSIBM.SYSDUMMY1" : "select 1");
        }
        this.concur = resultSetConcurrency;
        this.scroll = resultSetType;
        this.preparedStatement = vanillaJdbcConnection.getJdbcConnection().prepareStatement(query, resultSetType, resultSetConcurrency);
        this.connection = vanillaJdbcConnection;
    }

    public String getActualQuery() {
        return this.actualQuery;
    }

    public ResultSet executeQuery(String query) throws Exception {
        try {
            if (this.isQueryChanged(query)) {
                this.prepareStatement(query);
            }
            new Date();
            ResultSet rs = this.preparedStatement.executeQuery();
            new Date();
            return rs;
        }
        catch (Exception exception) {
            this.preparedStatement.close();
            ConnectionManager.getInstance().returnJdbcConnection(this.connection);
            this.connection = ConnectionManager.getInstance().getJdbcConnection(this.connection.getUrl(), this.connection.getUser(), this.connection.getPassword(), this.connection.getDriverClass());
            Statement stmt = null;
            stmt = this.concur != -1 ? this.connection.getJdbcConnection().createStatement(this.scroll, this.concur) : this.connection.getJdbcConnection().createStatement();
            ResultSet rs = stmt.executeQuery(this.actualQuery);
            return rs;
        }
    }

    public ResultSet executeQuery() throws Exception {
        return this.executeQuery("");
    }

    private void prepareStatement(String query) throws Exception {
        this.actualQuery = query;
        this.preparedStatement = this.concur != -1 ? this.connection.getJdbcConnection().prepareStatement(query, this.scroll, this.concur) : this.connection.getJdbcConnection().prepareStatement(query);
    }

    private boolean isQueryChanged(String query) {
        if (this.preparedStatement != null && this.actualQuery != null && !this.actualQuery.isEmpty()) {
            if (query.isEmpty()) {
                return false;
            }
            if (this.actualQuery.equals(query)) {
                return false;
            }
        }
        return true;
    }

    public ResultSetMetaData getQueryMetadata(String query) throws Exception {
        if (this.isQueryChanged(query)) {
            this.prepareStatement(query);
        }
        Date start = new Date();
        ResultSetMetaData rs = this.preparedStatement.getMetaData();
        Date end = new Date();
        Logger.getLogger(VanillaPreparedStatement.class.getClass()).debug((Object)("Metadata for query : " + query + " fetched in " + (end.getTime() - start.getTime()) + "ms"));
        return rs;
    }

    public ParameterMetaData getParameterMetadata(String query) throws Exception {
        if (this.isQueryChanged(query)) {
            this.prepareStatement(query);
        }
        Date start = new Date();
        ParameterMetaData rs = this.preparedStatement.getParameterMetaData();
        Date end = new Date();
        Logger.getLogger(VanillaPreparedStatement.class.getClass()).debug((Object)("ParameterMetadata for query : " + query + " fetched in " + (end.getTime() - start.getTime()) + "ms"));
        return rs;
    }

    public void setParameter(int index, Object value) throws Exception {
        this.preparedStatement.setObject(index, value);
    }

    public void setParameter(int index, Integer value) throws Exception {
        this.preparedStatement.setInt(index, value);
    }

    public void setParameter(int index, String value) throws Exception {
        this.preparedStatement.setString(index, value);
    }

    public void close() throws Exception {
        this.preparedStatement.close();
        this.preparedStatement = null;
        this.actualQuery = null;
    }

    public void setFetchSize(int size) throws Exception {
        this.preparedStatement.setFetchSize(size);
    }

    public void setMaxRows(int maxRows) throws Exception {
        this.preparedStatement.setMaxRows(maxRows);
    }

    public int executeUpdate() throws Exception {
        try {
            return this.preparedStatement.executeUpdate();
        }
        catch (Exception exception) {
            this.preparedStatement.close();
            ConnectionManager.getInstance().returnJdbcConnection(this.connection);
            this.connection = ConnectionManager.getInstance().getJdbcConnection(this.connection.getUrl(), this.connection.getUser(), this.connection.getPassword(), this.connection.getDriverClass());
            Statement stmt = null;
            stmt = this.connection.getJdbcConnection().createStatement();
            return stmt.executeUpdate(this.actualQuery);
        }
    }
}

