/*
 * Decompiled with CFR 0.152.
 */
package bpm.connection.manager.connection.jdbc;

import bpm.studio.jdbc.management.config.IConstants;
import bpm.studio.jdbc.management.model.DriverInfo;
import bpm.studio.jdbc.management.model.DriverShim;
import bpm.studio.jdbc.management.model.ListDriver;
import bpm.vanilla.platform.core.config.ConfigurationManager;
import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import org.apache.log4j.Logger;

public class JdbcConnectionPool {
    private HashMap<String, ComboPooledDataSource> connections = new HashMap();
    private URLClassLoader classLoader;
    private static final Class[] parameters = new Class[]{URL.class};

    public JdbcConnectionPool() throws Exception {
        Logger.getLogger(this.getClass()).debug((Object)"Creating a new Jdbc connectionPool");
    }

    public Connection getConnection(String url, String user, String password, String driverClass) throws Exception {
        String key = this.generateConnectionKey(url, user, password, driverClass);
        if (this.connections.get(key) != null) {
            Connection con = this.connections.get(key).getConnection();
            if (con.isClosed()) {
                this.returnConnection(con);
                return this.getConnection(url, user, password, driverClass);
            }
            return con;
        }
        ComboPooledDataSource pool = this.createConnectionPool(url, user, password, driverClass);
        this.connections.put(key, pool);
        return pool.getConnection();
    }

    private String generateConnectionKey(String url, String user, String password, String driverClass) {
        StringBuffer buf = new StringBuffer();
        buf.append(url);
        buf.append(user);
        buf.append(password);
        buf.append(driverClass);
        String key = UUID.nameUUIDFromBytes(buf.toString().getBytes()).toString();
        return key;
    }

    public void returnConnection(Connection connection) throws Exception {
        connection.close();
    }

    public ComboPooledDataSource createConnectionPool(String url, String user, String password, String driverClass) throws Exception {
        String poolSize;
        this.loadJdbcDriver(driverClass);
        ComboPooledDataSource pool = new ComboPooledDataSource();
        pool.setAutoCommitOnClose(false);
        if (driverClass.equalsIgnoreCase("org.apache.derby.jdbc.EmbeddedDriver")) {
            pool.setPreferredTestQuery("VALUES 1");
        } else if (driverClass.equalsIgnoreCase("oracle.jdbc.driver.OracleDriver")) {
            pool.setPreferredTestQuery("SELECT 1 FROM DUAL");
            pool.setUser(user);
            pool.setPassword(password);
        } else if (driverClass.equalsIgnoreCase("org.apache.hive.jdbc.HiveDriver")) {
            pool.setPreferredTestQuery("show tables");
            pool.setUser(user);
            pool.setPassword(password);
        } else {
            pool.setPreferredTestQuery("SELECT 1");
            pool.setUser(user);
            pool.setPassword(password);
        }
        pool.setMaxIdleTime(21600);
        pool.setIdleConnectionTestPeriod(10800);
        pool.setUsesTraditionalReflectiveProxies(false);
        try {
            poolSize = ConfigurationManager.getInstance().getVanillaConfiguration().getProperty("bpm.connection.manager.jdbc.pools.size");
            if (poolSize == null || poolSize.equals("")) {
                poolSize = "25";
            }
        }
        catch (Exception exception) {
            poolSize = "25";
        }
        pool.setInitialPoolSize(1);
        pool.setMinPoolSize(1);
        pool.setMaxPoolSize(Integer.parseInt(poolSize));
        pool.setJdbcUrl(url);
        pool.setDriverClass(driverClass);
        pool.setAcquireRetryAttempts(5);
        pool.setAcquireRetryDelay(100);
        pool.setBreakAfterAcquireFailure(false);
        pool.setTestConnectionOnCheckin(true);
        pool.setTestConnectionOnCheckout(true);
        return pool;
    }

    private void loadJdbcDriver(String driverClass) throws Exception {
        try {
            Class.forName(driverClass, true, this.classLoader);
        }
        catch (Exception exception) {
            this.addDriversToClasspath();
        }
    }

    private void addDriversToClasspath() throws Exception {
        Logger.getLogger(this.getClass()).debug((Object)"Adding the Jdbc drivers to the classpath");
        ArrayList<URL> newUrls = new ArrayList<URL>();
        for (DriverInfo info : ListDriver.getInstance((String)IConstants.getJdbcDriverXmlFile()).getDriversInfo()) {
            File f = new File(String.valueOf(IConstants.getJdbcJarFolder()) + "/" + info.getFile());
            URL u = f.toURL();
            newUrls.add(u);
        }
        this.classLoader = new URLClassLoader(newUrls.toArray(new URL[newUrls.size()]));
        for (DriverInfo info : ListDriver.getInstance((String)IConstants.getJdbcDriverXmlFile()).getDriversInfo()) {
            Driver d = (Driver)Class.forName(info.getClassName(), true, this.classLoader).newInstance();
            DriverManager.registerDriver((Driver)new DriverShim(d));
        }
    }

    private void registerDriver(String path, String driverClassName) throws Exception {
        ArrayList<URL> newUrls = new ArrayList<URL>();
        for (DriverInfo info : ListDriver.getInstance((String)IConstants.getJdbcDriverXmlFile()).getDriversInfo()) {
            try {
                Class.forName(info.getClassName());
                return;
            }
            catch (ClassNotFoundException classNotFoundException) {
                File f = new File(String.valueOf(IConstants.getJdbcJarFolder()) + "/" + info.getFile());
                URL u = f.toURL();
                newUrls.add(u);
            }
        }
        this.classLoader = new URLClassLoader(newUrls.toArray(new URL[newUrls.size()]));
        for (DriverInfo info : ListDriver.getInstance((String)IConstants.getJdbcDriverXmlFile()).getDriversInfo()) {
            Driver d = (Driver)Class.forName(info.getClassName(), true, this.classLoader).newInstance();
            DriverManager.registerDriver(d);
        }
    }
}

