/*
 * Decompiled with CFR 0.152.
 */
package bpm.connection.manager.connection.jdbc;

import bpm.studio.jdbc.management.config.IConstants;
import bpm.studio.jdbc.management.model.DriverInfo;
import bpm.studio.jdbc.management.model.DriverShim;
import bpm.studio.jdbc.management.model.ListDriver;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.List;

public class BasicJdbcConnectionPool {
    public static List<String> drivers = new ArrayList<String>();
    private URLClassLoader classLoader;
    private String jdbcDriverFolder;
    private static final Class[] parameters;

    static {
        drivers.add("org.apache.drill.jdbc.Driver");
        drivers.add("org.postgresql.Driver");
        drivers.add("org.relique.jdbc.csv.CsvDriver");
        drivers.add("oracle.jdbc.driver.OracleDriver");
        drivers.add("com.ibm.as400.access.AS400JDBCDriver");
        drivers.add("com.mysql.jdbc.Driver");
        parameters = new Class[]{URL.class};
    }

    public Connection getConnection(String url, String user, String password, String driverClass) throws Exception {
        try {
            Class.forName(driverClass, true, this.classLoader);
        }
        catch (Exception exception) {
            this.loadJdbcDriver(driverClass);
        }
        Connection c = DriverManager.getConnection(url, user, password);
        return c;
    }

    public void returnConnection(Connection connection) throws Exception {
        connection.close();
    }

    private void loadJdbcDriver(String driverClass) throws Exception {
        this.addDriversToClasspath();
    }

    private void addDriversToClasspath() throws Exception {
        ArrayList<URL> newUrls = new ArrayList<URL>();
        for (DriverInfo info : ListDriver.getInstance((String)IConstants.getJdbcDriverXmlFile()).getDriversInfo()) {
            File f = new File(String.valueOf(IConstants.getJdbcJarFolder()) + "/" + info.getFile());
            URL u = f.toURL();
            newUrls.add(u);
        }
        this.classLoader = new URLClassLoader(newUrls.toArray(new URL[newUrls.size()]));
        for (DriverInfo info : ListDriver.getInstance((String)IConstants.getJdbcDriverXmlFile()).getDriversInfo()) {
            Driver d = (Driver)Class.forName(info.getClassName(), true, this.classLoader).newInstance();
            DriverManager.registerDriver((Driver)new DriverShim(d));
        }
    }

    private void registerDriver(String path, String driverClassName) throws Exception {
    }
}

