/*
 * Decompiled with CFR 0.152.
 */
package bpm.connection.manager.connection;

import bpm.connection.manager.JdbcUrlHelper;
import bpm.connection.manager.connection.jdbc.BasicJdbcConnectionPool;
import bpm.connection.manager.connection.jdbc.JdbcConnectionPool;
import bpm.connection.manager.connection.jdbc.VanillaJdbcConnection;
import bpm.connection.manager.connection.oda.OdaConnectionPool;
import bpm.connection.manager.connection.oda.VanillaOdaConnection;
import bpm.vanilla.platform.core.beans.data.DatasourceJdbc;
import java.sql.Connection;
import java.util.Properties;
import org.eclipse.datatools.connectivity.oda.IConnection;

public class ConnectionManager {
    private static ConnectionManager instance;
    private JdbcConnectionPool jdbcPool = new JdbcConnectionPool();
    private OdaConnectionPool odaPool = new OdaConnectionPool();
    private BasicJdbcConnectionPool basicPool = new BasicJdbcConnectionPool();

    private ConnectionManager() throws Exception {
    }

    public static ConnectionManager getInstance() throws Exception {
        if (instance == null) {
            instance = new ConnectionManager();
        }
        return instance;
    }

    public VanillaJdbcConnection getJdbcConnection(DatasourceJdbc datasource) throws Exception {
        if (datasource.getFullUrl()) {
            return ConnectionManager.getInstance().getJdbcConnection(datasource.getUrl(), datasource.getUser(), datasource.getPassword(), datasource.getDriver());
        }
        return ConnectionManager.getInstance().getJdbcConnection(JdbcUrlHelper.getJdbcUrl(datasource.getHost(), datasource.getPort(), datasource.getDatabaseName(), datasource.getDriver()), datasource.getUser(), datasource.getPassword(), datasource.getDriver());
    }

    public VanillaJdbcConnection getJdbcConnection(String url, String user, String password, String driverClass) throws Exception {
        if (BasicJdbcConnectionPool.drivers.contains(driverClass)) {
            Connection c = this.basicPool.getConnection(url, user, password, driverClass);
            return new VanillaJdbcConnection(url, user, password, driverClass, c);
        }
        Connection c = this.jdbcPool.getConnection(url, user, password, driverClass);
        return new VanillaJdbcConnection(url, user, password, driverClass, c);
    }

    public void returnJdbcConnection(VanillaJdbcConnection connection) throws Exception {
        if (BasicJdbcConnectionPool.drivers.contains(connection.getDriverClass())) {
            this.basicPool.returnConnection(connection.getJdbcConnection());
        } else {
            this.jdbcPool.returnConnection(connection.getJdbcConnection());
        }
    }

    public VanillaOdaConnection getOdaConnection(Properties publicProperties, Properties privateProperties, String datasourceId) throws Exception {
        IConnection c = this.odaPool.getConnection(publicProperties, privateProperties, datasourceId);
        return new VanillaOdaConnection(c, publicProperties, privateProperties, datasourceId);
    }

    public void returnOdaConnection(VanillaOdaConnection connection) {
        this.odaPool.returnOdaConnection(connection.getOdaConnection());
    }
}

