/*
 * Decompiled with CFR 0.152.
 */
package bpm.metadata.ui.query.resources.dialogs;

import bpm.metadata.layer.business.IBusinessPackage;
import bpm.metadata.layer.business.RelationStrategy;
import bpm.metadata.ui.query.i18n.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.OwnerDrawLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DialogRelationStrategySelection
extends Dialog {
    private CheckboxTableViewer viewer;
    private IBusinessPackage pack;
    private List<RelationStrategy> selectedStrategies;

    public DialogRelationStrategySelection(Shell parentShell, List<RelationStrategy> selected, IBusinessPackage pack) {
        super(parentShell);
        this.pack = pack;
        this.selectedStrategies = selected;
    }

    protected void initializeBounds() {
        this.getShell().setSize(620, 400);
        this.getShell().setText(Messages.DialogRelationStrategySelection_0);
    }

    protected Control createDialogArea(Composite parent) {
        Composite root = new Composite(parent, 0);
        root.setLayout((Layout)new GridLayout(1, false));
        root.setLayoutData((Object)new GridData(4, 4, true, true));
        Label lbl = new Label(root, 0);
        lbl.setLayoutData((Object)new GridData(4, 4, true, false));
        lbl.setText(Messages.DialogRelationStrategySelection_1);
        this.viewer = CheckboxTableViewer.newCheckList((Composite)root, (int)2562);
        this.viewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getChildren(Object parentElement) {
                return null;
            }

            public Object getParent(Object element) {
                return null;
            }

            public boolean hasChildren(Object element) {
                return false;
            }

            public Object[] getElements(Object inputElement) {
                return ((List)inputElement).toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(true);
        TableViewerColumn colName = new TableViewerColumn((TableViewer)this.viewer, 2048);
        colName.getColumn().setText(Messages.DialogRelationStrategySelection_2);
        colName.getColumn().setWidth(150);
        colName.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((RelationStrategy)element).getName();
            }
        });
        TableViewerColumn colTables = new TableViewerColumn((TableViewer)this.viewer, 2048);
        colTables.getColumn().setText(Messages.DialogRelationStrategySelection_3);
        colTables.getColumn().setWidth(150);
        colTables.setLabelProvider((CellLabelProvider)new OwnerDrawLabelProvider(){

            protected void paint(Event event, Object element) {
                StringBuilder buf = new StringBuilder();
                for (String table : ((RelationStrategy)element).getTableNames()) {
                    buf.append(String.valueOf(table) + "\n");
                }
                event.gc.drawText(buf.toString(), event.x, event.y, true);
            }

            protected void measure(Event event, Object element) {
                StringBuilder buf = new StringBuilder();
                for (String table : ((RelationStrategy)element).getTableNames()) {
                    buf.append(String.valueOf(table) + "\n");
                }
                Point size = event.gc.textExtent(buf.toString());
                event.width = DialogRelationStrategySelection.this.viewer.getTable().getColumn(event.index).getWidth();
                int lines = size.x / event.width + 1;
                event.height = size.y * lines;
            }
        });
        TableViewerColumn colRels = new TableViewerColumn((TableViewer)this.viewer, 2048);
        colRels.getColumn().setText(Messages.DialogRelationStrategySelection_6);
        colRels.getColumn().setWidth(300);
        colRels.setLabelProvider((CellLabelProvider)new OwnerDrawLabelProvider(){

            protected void paint(Event event, Object element) {
                StringBuilder buf = new StringBuilder();
                for (String rel : ((RelationStrategy)element).getRelationKeys()) {
                    buf.append(String.valueOf(DialogRelationStrategySelection.this.pack.getBusinessModel().getRelationByKey(rel).getName()) + "\n");
                }
                event.gc.drawText(buf.toString(), event.x, event.y, true);
            }

            protected void measure(Event event, Object element) {
                StringBuilder buf = new StringBuilder();
                for (String rel : ((RelationStrategy)element).getRelationKeys()) {
                    buf.append(String.valueOf(DialogRelationStrategySelection.this.pack.getBusinessModel().getRelationByKey(rel).getName()) + "\n");
                }
                Point size = event.gc.textExtent(buf.toString());
                event.width = DialogRelationStrategySelection.this.viewer.getTable().getColumn(event.index).getWidth();
                int lines = size.x / event.width + 1;
                event.height = size.y * lines;
            }
        });
        this.fillData();
        return root;
    }

    private void fillData() {
        this.viewer.setInput((Object)this.pack.getBusinessModel().getRelationStrategies());
        this.viewer.setCheckedElements(this.selectedStrategies.toArray());
    }

    protected void okPressed() {
        Object[] strats = this.viewer.getCheckedElements();
        this.selectedStrategies = new ArrayList<RelationStrategy>();
        Object[] objectArray = strats;
        int n = strats.length;
        int n2 = 0;
        while (n2 < n) {
            Object s = objectArray[n2];
            this.selectedStrategies.add((RelationStrategy)s);
            ++n2;
        }
        super.okPressed();
    }

    public List<RelationStrategy> getSelectedStrategies() {
        return this.selectedStrategies;
    }
}

