/*
 * Decompiled with CFR 0.152.
 */
package bpm.metadata.ui.query.resources.dialogs;

import bpm.metadata.layer.business.IBusinessPackage;
import bpm.metadata.layer.business.IBusinessTable;
import bpm.metadata.layer.business.SQLBusinessTable;
import bpm.metadata.layer.logical.ICalculatedElement;
import bpm.metadata.layer.logical.IDataSource;
import bpm.metadata.layer.logical.IDataStream;
import bpm.metadata.layer.logical.IDataStreamElement;
import bpm.metadata.query.Formula;
import bpm.metadata.ui.query.i18n.Messages;
import java.util.ArrayList;
import java.util.Locale;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DialogComputedColumn
extends Dialog {
    private TreeViewer viewer;
    private Text formula;
    private Text name;
    private Formula formulaObject;
    private final String NODE_OPERATOR = "Operators";
    private final String[] NODES = new String[]{"+", "-", "*", "/"};
    private IBusinessPackage pack;
    private String groupName;

    public DialogComputedColumn(Shell parentShell, IBusinessPackage pack, String groupName) {
        super(parentShell);
        this.pack = pack;
        this.groupName = groupName;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public DialogComputedColumn(Shell shell, IBusinessPackage pack, String groupName, Formula formula) {
        this(shell, pack, groupName);
        this.initFormula(formula);
    }

    private void initFormula(Formula formula) {
        this.formulaObject = formula;
    }

    private void createContent(Composite parent) {
        Label l = new Label(parent, 0);
        l.setLayoutData((Object)new GridData(4, 2, true, false));
        l.setText(Messages.DialogComputedColumn_5);
        this.name = new Text(parent, 2048);
        this.name.setLayoutData((Object)new GridData(4, 2, true, false));
        this.viewer = new TreeViewer(parent, 0);
        this.viewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getChildren(Object parentElement) {
                ArrayList<String> l = new ArrayList<String>();
                if (parentElement == "Operators") {
                    return DialogComputedColumn.this.NODES;
                }
                if (parentElement instanceof IBusinessTable) {
                    l.addAll(((IBusinessTable)parentElement).getChilds(DialogComputedColumn.this.groupName));
                    l.addAll(((IBusinessTable)parentElement).getColumns(DialogComputedColumn.this.groupName));
                } else if (parentElement instanceof String) {
                    l.add("Operators");
                }
                return l.toArray(new Object[l.size()]);
            }

            public Object getParent(Object element) {
                if (element == "Operators") {
                    return null;
                }
                if (element instanceof IBusinessTable) {
                    return ((IBusinessTable)element).getParent();
                }
                if (element instanceof String) {
                    return "Operators";
                }
                return null;
            }

            public boolean hasChildren(Object element) {
                if (element == "Operators") {
                    return true;
                }
                if (element instanceof IBusinessTable) {
                    return ((IBusinessTable)element).getColumns(DialogComputedColumn.this.groupName).size() + ((IBusinessTable)element).getChilds(DialogComputedColumn.this.groupName).size() > 0;
                }
                return false;
            }

            public Object[] getElements(Object inputElement) {
                IBusinessPackage p = (IBusinessPackage)inputElement;
                ArrayList<String> l = new ArrayList<String>();
                l.add("Operators");
                l.addAll(p.getBusinessTables(DialogComputedColumn.this.groupName));
                return l.toArray(new Object[l.size()]);
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IBusinessTable) {
                    return ((SQLBusinessTable)element).getOuputName(Locale.getDefault());
                }
                if (element instanceof IDataStreamElement) {
                    return ((IDataStreamElement)element).getOuputName(Locale.getDefault());
                }
                return super.getText(element);
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (DialogComputedColumn.this.viewer.getSelection().isEmpty()) {
                    return;
                }
                Object o = ((IStructuredSelection)DialogComputedColumn.this.viewer.getSelection()).getFirstElement();
                if (o instanceof IDataStreamElement) {
                    IDataStreamElement col = (IDataStreamElement)o;
                    try {
                        DialogComputedColumn.this.formula.append("`" + col.getDataStream().getName() + "`." + col.getOrigin().getShortName());
                    }
                    catch (Exception exception) {
                        if (col instanceof ICalculatedElement) {
                            DialogComputedColumn.this.formula.append(((ICalculatedElement)col).getFormula());
                        }
                    }
                } else if (o instanceof String) {
                    DialogComputedColumn.this.formula.append((String)o);
                }
            }
        });
        this.formula = new Text(parent, 2114);
        this.formula.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fillDatas();
    }

    protected Control createDialogArea(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout(2, false));
        main.setLayoutData((Object)new GridData(1808));
        this.createContent(main);
        this.viewer.setInput((Object)this.pack);
        return main;
    }

    private void fillDatas() {
        if (this.formulaObject != null) {
            this.formula.setText(this.formulaObject.getFormula());
            this.name.setText(this.formulaObject.getName());
        }
    }

    protected void initializeBounds() {
        this.getShell().setSize(600, 400);
        this.getShell().setText(Messages.DialogComputedColumn_8);
    }

    public Formula getFormula() {
        return this.formulaObject;
    }

    protected void okPressed() {
        if (this.formulaObject == null) {
            ArrayList<String> streams = new ArrayList<String>();
            for (IDataStream s : ((IDataSource)this.pack.getDataSources(this.groupName).get(0)).getDataStreams()) {
                if (!this.formula.getText().contains(String.valueOf(s.getOriginName()) + ".")) continue;
                streams.add(s.getName());
            }
            this.formulaObject = new Formula(this.name.getText(), this.formula.getText(), streams);
        } else {
            this.formulaObject.setName(this.name.getText());
            this.formulaObject.setFormula(this.formula.getText());
        }
        super.okPressed();
    }
}

