/*
 * Decompiled with CFR 0.152.
 */
package bpm.metadata.ui.query.resources.composites;

import bpm.metadata.resource.IResource;
import bpm.metadata.resource.SqlQueryFilter;
import bpm.metadata.ui.query.i18n.Messages;
import bpm.metadata.ui.query.resources.composites.ResourceBuilder;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CompositeSqlFilter
extends Composite
implements ResourceBuilder {
    private static final Color RED = new Color((Device)Display.getDefault(), 255, 0, 0);
    private SqlQueryFilter filter;
    private Text name;
    private Label errorLabel;
    private Text query;

    public CompositeSqlFilter(Composite parent, int style, SqlQueryFilter filter) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout());
        this.buildContent();
        this.filter = filter;
        this.fillDatas();
    }

    private void buildContent() {
        this.createGeneral(this);
        this.errorLabel = new Label((Composite)this, 0);
        this.errorLabel.setLayoutData((Object)new GridData(4, 3, true, false, 2, 1));
        this.errorLabel.setForeground(RED);
        this.errorLabel.setVisible(false);
    }

    private Control createGeneral(Composite root) {
        Composite parent = new Composite(root, 0);
        parent.setLayout((Layout)new GridLayout(2, false));
        parent.setLayoutData((Object)new GridData(1808));
        Label l = new Label(parent, 0);
        l.setLayoutData((Object)new GridData());
        l.setText(Messages.CompositeSqlFilter_0);
        this.name = new Text(parent, 2048);
        this.name.setLayoutData((Object)new GridData(4, 2, true, false));
        l = new Label(parent, 0);
        l.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        l.setText(Messages.CompositeSqlFilter_1);
        this.query = new Text(parent, 2114);
        this.query.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.query.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CompositeSqlFilter.this.notifyListeners(13, new Event());
            }
        });
        return parent;
    }

    private void fillDatas() {
        this.name.setText(this.filter.getName());
        if (this.filter.getQuery() != null && !this.filter.getQuery().equals(" null")) {
            this.query.setText(this.filter.getQuery());
        }
    }

    @Override
    public IResource getResource() {
        this.filter.setName(this.name.getText());
        this.filter.setQuery(this.query.getText());
        return this.filter;
    }

    public boolean isFilled() {
        return !this.errorLabel.isVisible() && !this.name.getText().trim().equals("") && !this.query.getText().trim().equals("");
    }
}

