/*
 * Decompiled with CFR 0.152.
 */
package bpm.metadata.ui.query.resources.composites;

import bpm.metadata.resource.IResource;
import bpm.metadata.resource.Prompt;
import bpm.metadata.ui.query.i18n.Messages;
import bpm.metadata.ui.query.resources.composites.ResourceBuilder;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CompositePrompt
extends Composite
implements ResourceBuilder {
    private static final Color RED = new Color((Device)Display.getDefault(), 255, 0, 0);
    private Prompt prompt;
    private Text destination;
    private Text name;
    private Combo operator;
    private Label errorLabel;

    public CompositePrompt(Composite parent, int style, Prompt prompt) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout());
        this.buildContent();
        this.prompt = prompt;
        this.fillDatas();
    }

    private void buildContent() {
        this.createGeneral(this);
        this.errorLabel = new Label((Composite)this, 0);
        this.errorLabel.setText(" xx");
        this.errorLabel.setLayoutData((Object)new GridData(4, 3, true, false, 2, 1));
        this.errorLabel.setForeground(RED);
        this.errorLabel.setVisible(false);
    }

    private void setErrorMessage(String message) {
        if (message == null) {
            this.errorLabel.setVisible(false);
        } else {
            this.errorLabel.setText(message);
            this.errorLabel.setVisible(true);
        }
    }

    private Control createGeneral(Composite root) {
        Composite parent = new Composite(root, 0);
        parent.setLayout((Layout)new GridLayout(2, false));
        parent.setLayoutData((Object)new GridData(1808));
        Label l = new Label(parent, 0);
        l.setLayoutData((Object)new GridData());
        l.setText(Messages.CompositePrompt_0);
        this.name = new Text(parent, 2048);
        this.name.setLayoutData((Object)new GridData(4, 2, true, false));
        Label l3 = new Label(parent, 0);
        l3.setLayoutData((Object)new GridData(1, 2, false, false));
        l3.setText(Messages.CompositePrompt_1);
        this.destination = new Text(parent, 2048);
        this.destination.setLayoutData((Object)new GridData(4, 2, true, false));
        this.destination.setEnabled(false);
        Label l4 = new Label(parent, 0);
        l4.setLayoutData((Object)new GridData(1, 2, false, false));
        l4.setText(Messages.CompositePrompt_2);
        this.operator = new Combo(parent, 8);
        this.operator.setLayoutData((Object)new GridData(4, 2, true, false));
        this.operator.setItems(new String[]{"=", "<", "<=", ">", ">=", "!=", "<>", "IN", "LIKE", "BETWEEN"});
        this.operator.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CompositePrompt.this.notifyListeners(13, new Event());
            }
        });
        return parent;
    }

    private void fillDatas() {
        this.name.setText(this.prompt.getName());
        if (this.prompt.getGotoDataStreamElement() != null) {
            this.destination.setText(this.prompt.getGotoDataStreamElement().getName());
        } else {
            this.destination.setText(this.prompt.getGotoSql());
        }
        this.operator.setText(this.prompt.getOperator());
    }

    @Override
    public IResource getResource() {
        this.prompt.setName(this.name.getText());
        this.prompt.setOperator(this.operator.getText());
        return this.prompt;
    }

    public boolean isFilled() {
        return !this.errorLabel.isVisible() && !"".equals(this.name.getText().trim()) && !"".equals(this.operator.getText());
    }
}

