/*
 * Decompiled with CFR 0.152.
 */
package bpm.metadata.ui.query.resources.composites;

import bpm.metadata.resource.ComplexFilter;
import bpm.metadata.resource.IResource;
import bpm.metadata.ui.query.Activator;
import bpm.metadata.ui.query.i18n.Messages;
import bpm.metadata.ui.query.resources.composites.ResourceBuilder;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class CompositeComplexFilter
extends Composite
implements ResourceBuilder {
    private ComplexFilter filter;
    private Text name;
    private TableViewer value;
    private Combo operator;
    private Label errorLabel;

    public CompositeComplexFilter(Composite parent, int style, ComplexFilter filter) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout());
        this.buildContent();
        this.filter = filter;
        this.fillDatas();
    }

    private void buildContent() {
        this.createGeneral(this);
    }

    private Control createGeneral(Composite root) {
        Composite parent = new Composite(root, 0);
        parent.setLayout((Layout)new GridLayout(2, false));
        parent.setLayoutData((Object)new GridData(1808));
        Label l = new Label(parent, 0);
        l.setLayoutData((Object)new GridData());
        l.setText(Messages.CompositeComplexFilter_0);
        this.name = new Text(parent, 2048);
        this.name.setLayoutData((Object)new GridData(4, 2, true, false));
        Label l4 = new Label(parent, 0);
        l4.setLayoutData((Object)new GridData(1, 2, false, false));
        l4.setText(Messages.CompositeComplexFilter_1);
        this.operator = new Combo(parent, 8);
        this.operator.setLayoutData((Object)new GridData(4, 2, true, false));
        this.operator.setItems(ComplexFilter.OPERATORS);
        this.operator.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CompositeComplexFilter.this.notifyListeners(13, new Event());
            }
        });
        Label l5 = new Label(parent, 0);
        l5.setLayoutData((Object)new GridData(1, 1, false, false));
        l5.setText(Messages.CompositeComplexFilter_2);
        ToolBar bar = new ToolBar(parent, 0);
        bar.setLayoutData((Object)new GridData(4, 1, true, false));
        ToolItem add = new ToolItem(bar, 8);
        add.setToolTipText(Messages.CompositeComplexFilter_3);
        add.setImage(Activator.getDefault().getImageRegistry().get("addCol2"));
        add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputDialog d = new InputDialog(CompositeComplexFilter.this.getShell(), Messages.CompositeComplexFilter_4, Messages.CompositeComplexFilter_5, "newValue", null);
                if (d.open() == 0) {
                    switch (CompositeComplexFilter.this.operator.getSelectionIndex()) {
                        case 7: 
                        case 8: {
                            ((List)CompositeComplexFilter.this.value.getInput()).add(d.getValue());
                            break;
                        }
                        case 10: {
                            if (((List)CompositeComplexFilter.this.value.getInput()).size() < 2) {
                                ((List)CompositeComplexFilter.this.value.getInput()).add(d.getValue());
                                break;
                            }
                            ((List)CompositeComplexFilter.this.value.getInput()).clear();
                            ((List)CompositeComplexFilter.this.value.getInput()).add(d.getValue());
                            break;
                        }
                        default: {
                            ((List)CompositeComplexFilter.this.value.getInput()).clear();
                            ((List)CompositeComplexFilter.this.value.getInput()).add(d.getValue());
                        }
                    }
                }
                CompositeComplexFilter.this.value.refresh();
            }
        });
        ToolItem del = new ToolItem(bar, 8);
        del.setToolTipText(Messages.CompositeComplexFilter_8);
        del.setImage(Activator.getDefault().getImageRegistry().get("delCol2"));
        del.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection ss = (IStructuredSelection)CompositeComplexFilter.this.value.getSelection();
                Object[] objectArray = ss.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    ((List)CompositeComplexFilter.this.value.getInput()).remove(o);
                    ++n2;
                }
                CompositeComplexFilter.this.value.refresh();
            }
        });
        this.value = new TableViewer(parent, 2048);
        this.value.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.value.setContentProvider((IContentProvider)new ArrayContentProvider());
        TableViewerColumn col = new TableViewerColumn(this.value, 0);
        col.getColumn().setWidth(300);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider());
        col.setEditingSupport(new EditingSupport((ColumnViewer)this.value){
            TextCellEditor editor;
            {
                this.editor = new TextCellEditor((Composite)CompositeComplexFilter.this.value.getTable(), 0);
            }

            protected void setValue(Object element, Object value) {
                int i = ((List)CompositeComplexFilter.this.value.getInput()).indexOf(element);
                ((List)CompositeComplexFilter.this.value.getInput()).set(i, (String)value);
                CompositeComplexFilter.this.value.refresh();
            }

            protected Object getValue(Object element) {
                return (String)element;
            }

            protected CellEditor getCellEditor(Object element) {
                return this.editor;
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        });
        return parent;
    }

    private void fillDatas() {
        this.name.setText(this.filter.getName());
        this.operator.setText(this.filter.getOperator());
        if (this.filter.getValue() == null) {
            this.value.setInput(new ArrayList());
        } else {
            this.value.setInput((Object)this.filter.getValue());
        }
    }

    @Override
    public IResource getResource() {
        this.filter.setName(this.name.getText());
        this.filter.setOperator(this.operator.getText());
        this.filter.clearValue();
        for (String s : (List)this.value.getInput()) {
            this.filter.setValue(s);
        }
        return this.filter;
    }

    public boolean isFilled() {
        return !this.errorLabel.isVisible() && !this.name.getText().trim().equals("") && !this.operator.getText().trim().equals("") && !((List)this.value.getInput()).isEmpty();
    }
}

