/*
 * Decompiled with CFR 0.152.
 */
package bpm.metadata.ui.query.dialogs;

import bpm.metadata.query.QuerySql;
import bpm.metadata.resource.Prompt;
import bpm.metadata.ui.query.i18n.Messages;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class DialogQueryPrompt
extends Dialog {
    private QuerySql query;
    private TableViewer viewer;
    private Map<Prompt, List<String>> datas = new HashMap<Prompt, List<String>>();

    public DialogQueryPrompt(Shell parentShell, QuerySql query, Map<Prompt, List<String>> values) {
        super(parentShell);
        this.query = query;
        if (values != null) {
            this.datas = values;
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.viewer = new TableViewer(parent, 68096);
        this.viewer.getTable().setLayoutData((Object)new GridData(1808));
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(true);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        TableViewerColumn col = new TableViewerColumn(this.viewer, 0);
        col.getColumn().setText(Messages.DialogQueryPrompt_0);
        col.getColumn().setWidth(200);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((Prompt)element).getOutputName();
            }
        });
        col = new TableViewerColumn(this.viewer, 0);
        col.getColumn().setText(Messages.DialogQueryPrompt_1);
        col.getColumn().setWidth(200);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                List l = (List)DialogQueryPrompt.this.datas.get((Prompt)element);
                if (l == null) {
                    return "";
                }
                StringBuffer buf = new StringBuffer();
                for (String s : l) {
                    if (buf.length() > 0) {
                        buf.append(",");
                    }
                    buf.append(s);
                }
                return buf.toString();
            }
        });
        col.setEditingSupport(new EditingSupport((ColumnViewer)this.viewer){
            TextCellEditor ed;
            {
                this.ed = new TextCellEditor((Composite)DialogQueryPrompt.this.viewer.getTable(), 0);
            }

            protected void setValue(Object element, Object value) {
                ArrayList<String> l = (ArrayList<String>)DialogQueryPrompt.this.datas.get((Prompt)element);
                l = new ArrayList<String>();
                DialogQueryPrompt.this.datas.put((Prompt)element, l);
                l.add((String)value);
                DialogQueryPrompt.this.viewer.refresh();
            }

            protected Object getValue(Object element) {
                List l = (List)DialogQueryPrompt.this.datas.get((Prompt)element);
                if (l != null && !l.isEmpty()) {
                    return l.get(0);
                }
                return "";
            }

            protected CellEditor getCellEditor(Object element) {
                return this.ed;
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        });
        return this.viewer.getTable();
    }

    protected void initializeBounds() {
        this.getShell().setSize(600, 400);
        this.viewer.setInput((Object)this.query.getPrompts());
    }

    public Map<Prompt, List<String>> getValues() {
        return this.datas;
    }
}

