/*
 * Decompiled with CFR 0.152.
 */
package bpm.metadata.ui.query.composite;

import bpm.metadata.MetaDataBuilder;
import bpm.metadata.layer.business.IBusinessPackage;
import bpm.metadata.layer.business.IBusinessTable;
import bpm.metadata.layer.business.RelationStrategy;
import bpm.metadata.layer.logical.IDataStreamElement;
import bpm.metadata.misc.AggregateFormula;
import bpm.metadata.query.EffectiveQuery;
import bpm.metadata.query.Formula;
import bpm.metadata.query.IQuery;
import bpm.metadata.query.Ordonable;
import bpm.metadata.query.QuerySql;
import bpm.metadata.query.SavedQuery;
import bpm.metadata.query.SqlQueryBuilder;
import bpm.metadata.resource.ComplexFilter;
import bpm.metadata.resource.Filter;
import bpm.metadata.resource.IFilter;
import bpm.metadata.resource.IResource;
import bpm.metadata.resource.ListOfValue;
import bpm.metadata.resource.Prompt;
import bpm.metadata.resource.SqlQueryFilter;
import bpm.metadata.ui.query.Activator;
import bpm.metadata.ui.query.composite.IContextManager;
import bpm.metadata.ui.query.dialogs.DialogLoadSavedQuery;
import bpm.metadata.ui.query.dialogs.DialogSavedQuery;
import bpm.metadata.ui.query.i18n.Messages;
import bpm.metadata.ui.query.resources.dialogs.DialogComputedColumn;
import bpm.metadata.ui.query.resources.dialogs.DialogRelationStrategySelection;
import bpm.metadata.ui.query.resources.dialogs.DialogResource;
import bpm.vanilla.platform.core.IRepositoryContext;
import bpm.vanilla.platform.core.IVanillaContext;
import bpm.vanilla.platform.core.remote.RemoteRepositoryApi;
import bpm.vanilla.platform.core.repository.RepositoryItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;
import org.hibernate.engine.jdbc.internal.BasicFormatterImpl;

public class CompositeSqlQuery
extends Composite {
    private static String[] aggregators = new String[]{"None", "SUM", "AVG", "COUNT", "DISTINCT COUNT", "MAX", "MIN"};
    private IBusinessPackage fmdtPakage;
    private String vanillaGroupName;
    private List<IResource> ontheFlyResources = new ArrayList<IResource>();
    private List<RelationStrategy> selectedStrategies = new ArrayList<RelationStrategy>();
    private TreeViewer fmdtViewer;
    private TableViewer columnViewer;
    private TableViewer filterViewer;
    private Button distinct;
    private Button bLimit;
    private Text limit;
    private boolean fromFmdt;
    private IContextManager contextManager;
    private IRepositoryContext context;
    private int itemId;
    private Text filterText;
    private String actualFilter = "";

    public CompositeSqlQuery(Composite parent, int style) {
        super(parent, style);
        this.buildContent();
    }

    public CompositeSqlQuery(Composite parent, int style, boolean fromFmdt, IContextManager contextManager) {
        super(parent, style);
        this.fromFmdt = fromFmdt;
        this.contextManager = contextManager;
        this.buildContent();
    }

    private void buildContent() {
        this.setLayout((Layout)new GridLayout(2, false));
        Composite searchComp = new Composite((Composite)this, 0);
        searchComp.setLayoutData((Object)new GridData(4, 4, true, false));
        searchComp.setLayout((Layout)new GridLayout(2, false));
        this.filterText = new Text(searchComp, 2048);
        this.filterText.setLayoutData((Object)new GridData(4, 4, true, false));
        Button btnSearch = new Button(searchComp, 8);
        btnSearch.setLayoutData((Object)new GridData(4, 4, false, false));
        btnSearch.setText("Search");
        btnSearch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CompositeSqlQuery.this.actualFilter = CompositeSqlQuery.this.filterText.getText();
                CompositeSqlQuery.this.fmdtViewer.refresh();
            }
        });
        Composite queryC = new Composite((Composite)this, 0);
        queryC.setLayoutData((Object)new GridData(4, 4, true, true, 1, 2));
        queryC.setLayout((Layout)new GridLayout(2, false));
        this.fmdtViewer = new TreeViewer((Composite)this, 68354);
        this.fmdtViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.createFmdtViewer();
        ToolBar colsBar = new ToolBar(queryC, 512);
        colsBar.setLayoutData((Object)new GridData(4, 4, false, true, 1, 2));
        Composite c = new Composite(queryC, 0);
        c.setLayout((Layout)new FillLayout(512));
        c.setLayoutData((Object)new GridData(1808));
        this.columnViewer = new TableViewer(c, 68352);
        this.columnViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.createColumnViewer();
        this.filterViewer = new TableViewer(c, 68352);
        this.filterViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.filterViewer.setInput(new ArrayList());
        this.createFilterViewer();
        this.createToolbar(colsBar);
        Composite queryOpts = new Composite(queryC, 0);
        queryOpts.setLayoutData((Object)new GridData(4, 3, true, false));
        queryOpts.setLayout((Layout)new GridLayout(3, false));
        this.distinct = new Button(queryOpts, 32);
        this.distinct.setLayoutData((Object)new GridData());
        this.distinct.setText(Messages.CompositeSqlQuery_13);
        this.bLimit = new Button(queryOpts, 32);
        this.bLimit.setLayoutData((Object)new GridData());
        this.bLimit.setText(Messages.CompositeSqlQuery_14);
        this.bLimit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CompositeSqlQuery.this.limit.setEnabled(CompositeSqlQuery.this.bLimit.getSelection());
            }
        });
        this.limit = new Text(queryOpts, 2048);
        this.limit.setLayoutData((Object)new GridData(4, 1, true, false));
        this.limit.setEnabled(false);
        this.limit.setText("5");
    }

    private void createFilterViewer() {
        this.filterViewer.getTable().setHeaderVisible(true);
        this.filterViewer.getTable().setLinesVisible(true);
        TableViewerColumn col = new TableViewerColumn(this.filterViewer, 0);
        col.getColumn().setWidth(150);
        col.getColumn().setText(Messages.CompositeSqlQuery_16);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((Condition)element).r.getOutputName();
            }

            public Image getImage(Object element) {
                IResource obj = ((Condition)element).r;
                if (obj instanceof Prompt) {
                    return Activator.getDefault().getImageRegistry().get("prompt");
                }
                if (obj instanceof IFilter) {
                    if (obj instanceof ComplexFilter) {
                        return Activator.getDefault().getImageRegistry().get("complexFilter");
                    }
                    if (obj instanceof SqlQueryFilter) {
                        return Activator.getDefault().getImageRegistry().get("sqlFilter");
                    }
                    if (obj instanceof Filter) {
                        return Activator.getDefault().getImageRegistry().get("filter");
                    }
                    return Activator.getDefault().getImageRegistry().get("filter");
                }
                return null;
            }
        });
        col = new TableViewerColumn(this.filterViewer, 0);
        col.getColumn().setWidth(150);
        col.getColumn().setText(Messages.CompositeSqlQuery_21);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Condition c = (Condition)element;
                if (c.r instanceof IFilter) {
                    return ((IFilter)c.r).getOrigin().getOuputName();
                }
                if (c.r instanceof Prompt) {
                    if (((Prompt)c.r).getGotoDataStreamElement() != null) {
                        return ((Prompt)c.r).getGotoDataStreamElement().getOuputName();
                    }
                    return "SqlPrompt";
                }
                return "";
            }
        });
        col = new TableViewerColumn(this.filterViewer, 0);
        col.getColumn().setWidth(100);
        col.getColumn().setText(Messages.CompositeSqlQuery_24);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Condition c = (Condition)element;
                return c.getOperator();
            }
        });
        col = new TableViewerColumn(this.filterViewer, 0);
        col.getColumn().setWidth(100);
        col.getColumn().setText(Messages.CompositeSqlQuery_25);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Condition c = (Condition)element;
                return c.getValues();
            }
        });
    }

    private void createColumnViewer() {
        this.columnViewer.getTable().setHeaderVisible(true);
        this.columnViewer.getTable().setLinesVisible(true);
        TableViewerColumn col = new TableViewerColumn(this.columnViewer, 0);
        col.getColumn().setWidth(150);
        col.getColumn().setText(Messages.CompositeSqlQuery_26);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((QueryItem)element).col.getOutputName();
            }
        });
        col = new TableViewerColumn(this.columnViewer, 0);
        col.getColumn().setWidth(100);
        col.getColumn().setText(Messages.CompositeSqlQuery_27);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                QueryItem agg = (QueryItem)element;
                if (agg.agg == null) {
                    return "";
                }
                return agg.agg;
            }
        });
        col.setEditingSupport(new EditingSupport((ColumnViewer)this.columnViewer){
            ComboBoxCellEditor aggEditor;
            {
                this.aggEditor = new ComboBoxCellEditor((Composite)CompositeSqlQuery.this.columnViewer.getTable(), aggregators, 8);
            }

            protected void setValue(Object element, Object value) {
                Integer v = (Integer)value;
                if (v == 0) {
                    ((QueryItem)element).agg = null;
                } else {
                    ((QueryItem)element).agg = aggregators[v];
                    if (((QueryItem)element).label == null) {
                        ((QueryItem)element).label = new String(((QueryItem)element).col.getOutputName());
                    }
                }
                CompositeSqlQuery.this.columnViewer.refresh();
            }

            protected Object getValue(Object element) {
                QueryItem f = (QueryItem)element;
                if (f.agg == null) {
                    return 0;
                }
                int i = 1;
                while (i < aggregators.length) {
                    if (aggregators[i].equals(f.agg)) {
                        return i;
                    }
                    ++i;
                }
                return 0;
            }

            protected CellEditor getCellEditor(Object element) {
                return this.aggEditor;
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        });
        col = new TableViewerColumn(this.columnViewer, 0);
        col.getColumn().setWidth(150);
        col.getColumn().setText(Messages.CompositeSqlQuery_29);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (((QueryItem)element).agg == null) {
                    return ((QueryItem)element).col.getOutputName();
                }
                return ((QueryItem)element).label;
            }
        });
        col.setEditingSupport(new EditingSupport((ColumnViewer)this.columnViewer){
            TextCellEditor editor;
            {
                this.editor = new TextCellEditor((Composite)CompositeSqlQuery.this.columnViewer.getTable(), 0);
            }

            protected void setValue(Object element, Object value) {
                ((QueryItem)element).label = (String)value;
                CompositeSqlQuery.this.columnViewer.refresh();
            }

            protected Object getValue(Object element) {
                return ((QueryItem)element).label;
            }

            protected CellEditor getCellEditor(Object element) {
                return this.editor;
            }

            protected boolean canEdit(Object element) {
                return ((QueryItem)element).agg != null;
            }
        });
        col = new TableViewerColumn(this.columnViewer, 0);
        col.getColumn().setWidth(100);
        col.getColumn().setText(Messages.CompositeSqlQuery_30);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                int pos = ((List)CompositeSqlQuery.this.columnViewer.getInput()).indexOf(element);
                return "" + (pos + 1);
            }
        });
    }

    private boolean keepTable(IBusinessTable table) {
        for (IBusinessTable sub : table.getChilds(this.vanillaGroupName)) {
            for (IDataStreamElement elem : sub.getColumns(this.vanillaGroupName)) {
                if (!this.keepColumn(elem)) continue;
                return true;
            }
        }
        for (IDataStreamElement elem : table.getColumns(this.vanillaGroupName)) {
            if (!this.keepColumn(elem)) continue;
            return true;
        }
        return false;
    }

    private boolean keepColumn(IDataStreamElement element) {
        return element.getOuputName().toLowerCase().contains(this.actualFilter.toLowerCase());
    }

    private boolean keepResource(IResource resource) {
        return resource.getOutputName().toLowerCase().contains(this.actualFilter.toLowerCase());
    }

    private void createFmdtViewer() {
        this.fmdtViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                IBusinessPackage p = (IBusinessPackage)inputElement;
                ArrayList<Object> l = new ArrayList<Object>();
                String groupName = CompositeSqlQuery.this.getGroupName();
                for (IBusinessTable t : p.getOrderedTables(groupName)) {
                    if (!CompositeSqlQuery.this.keepTable(t)) continue;
                    l.add(t);
                }
                for (IResource r : p.getResources(groupName)) {
                    if (!CompositeSqlQuery.this.keepResource(r)) continue;
                    l.add(r);
                }
                return l.toArray(new Object[l.size()]);
            }

            public boolean hasChildren(Object element) {
                if (element instanceof IBusinessTable) {
                    String groupName = CompositeSqlQuery.this.getGroupName();
                    return ((IBusinessTable)element).getChilds(groupName).size() + ((IBusinessTable)element).getColumns(groupName).size() > 0;
                }
                return false;
            }

            public Object getParent(Object element) {
                return null;
            }

            public Object[] getChildren(Object parentElement) {
                ArrayList<Object> l = new ArrayList<Object>();
                if (parentElement instanceof IBusinessTable) {
                    String groupName = CompositeSqlQuery.this.getGroupName();
                    for (IBusinessTable t : ((IBusinessTable)parentElement).getChilds(groupName)) {
                        if (!CompositeSqlQuery.this.keepTable(t)) continue;
                        l.add(t);
                    }
                    for (IDataStreamElement elem : ((IBusinessTable)parentElement).getColumnsOrdered(groupName)) {
                        if (!CompositeSqlQuery.this.keepColumn(elem)) continue;
                        l.add(elem);
                    }
                }
                return l.toArray(new Object[l.size()]);
            }
        });
        this.fmdtViewer.setLabelProvider((IBaseLabelProvider)new FmdtLabelProvider());
    }

    private void createToolbar(ToolBar parent) {
        final ToolItem add = new ToolItem(parent, 8);
        add.setImage(Activator.getDefault().getImageRegistry().get("addCol"));
        add.setToolTipText(Messages.CompositeSqlQuery_32);
        add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            final boolean viewerContains(Ordonable o) {
                for (Object d : (List)CompositeSqlQuery.this.columnViewer.getInput()) {
                    if (!(d instanceof QueryItem) || ((QueryItem)d).col != o) continue;
                    return true;
                }
                return false;
            }

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection ss = (IStructuredSelection)CompositeSqlQuery.this.fmdtViewer.getSelection();
                for (Object o : ss.toList()) {
                    if (o instanceof IResource) {
                        if (CompositeSqlQuery.this.filterViewer.getInput() == null) {
                            CompositeSqlQuery.this.filterViewer.setInput(new ArrayList());
                        }
                        ((List)CompositeSqlQuery.this.filterViewer.getInput()).add(new Condition((IResource)o));
                        continue;
                    }
                    if (CompositeSqlQuery.this.columnViewer.getInput() == null) {
                        CompositeSqlQuery.this.columnViewer.setInput(new ArrayList());
                    }
                    if (o instanceof IBusinessTable) {
                        for (Ordonable c : ((IBusinessTable)o).getColumns(CompositeSqlQuery.this.getGroupName())) {
                            if (this.viewerContains(c)) continue;
                            ((List)CompositeSqlQuery.this.columnViewer.getInput()).add(new QueryItem(c, null, null));
                        }
                        continue;
                    }
                    if (this.viewerContains((Ordonable)o)) continue;
                    ((List)CompositeSqlQuery.this.columnViewer.getInput()).add(new QueryItem((Ordonable)o, null, null));
                }
                CompositeSqlQuery.this.filterViewer.refresh();
                CompositeSqlQuery.this.columnViewer.refresh();
            }
        });
        add.setEnabled(false);
        final ToolItem del = new ToolItem(parent, 8);
        del.setImage(Activator.getDefault().getImageRegistry().get("delCol"));
        del.setToolTipText(Messages.CompositeSqlQuery_33);
        del.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection ss = (IStructuredSelection)CompositeSqlQuery.this.columnViewer.getSelection();
                for (Object o : ss.toList()) {
                    if (!(o instanceof QueryItem)) continue;
                    ((List)CompositeSqlQuery.this.columnViewer.getInput()).remove(o);
                }
                CompositeSqlQuery.this.columnViewer.refresh();
            }
        });
        del.setEnabled(false);
        ToolItem calc = new ToolItem(parent, 8);
        calc.setImage(Activator.getDefault().getImageRegistry().get("calc"));
        calc.setToolTipText(Messages.CompositeSqlQuery_34);
        calc.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DialogComputedColumn d = new DialogComputedColumn(CompositeSqlQuery.this.getShell(), CompositeSqlQuery.this.fmdtPakage, CompositeSqlQuery.this.getGroupName());
                if (d.open() == 0) {
                    QueryItem it = new QueryItem((Ordonable)d.getFormula(), null, d.getFormula().getName());
                    if (CompositeSqlQuery.this.columnViewer.getInput() == null) {
                        CompositeSqlQuery.this.columnViewer.setInput(new ArrayList());
                    }
                    ((List)CompositeSqlQuery.this.columnViewer.getInput()).add(it);
                }
                CompositeSqlQuery.this.columnViewer.refresh();
            }
        });
        final ToolItem editcalc = new ToolItem(parent, 8);
        editcalc.setImage(Activator.getDefault().getImageRegistry().get("edit"));
        editcalc.setToolTipText(Messages.CompositeSqlQuery_35);
        editcalc.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QueryItem it = (QueryItem)((IStructuredSelection)CompositeSqlQuery.this.columnViewer.getSelection()).getFirstElement();
                DialogComputedColumn d = new DialogComputedColumn(CompositeSqlQuery.this.getShell(), CompositeSqlQuery.this.fmdtPakage, CompositeSqlQuery.this.getGroupName(), (Formula)it.col);
                d.open();
                CompositeSqlQuery.this.columnViewer.refresh();
            }
        });
        final ToolItem newComplex = new ToolItem(parent, 8);
        newComplex.setToolTipText(Messages.CompositeSqlQuery_36);
        newComplex.setImage(Activator.getDefault().getImageRegistry().get("complexFilter"));
        newComplex.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection ss = (IStructuredSelection)CompositeSqlQuery.this.fmdtViewer.getSelection();
                IDataStreamElement col = (IDataStreamElement)ss.getFirstElement();
                ComplexFilter filter = new ComplexFilter();
                filter.setName("newFilter");
                filter.setOrigin(col);
                filter.setOperator(ComplexFilter.OPERATORS[0]);
                DialogResource d = new DialogResource(CompositeSqlQuery.this.getShell(), (IResource)filter);
                if (d.open() == 0) {
                    CompositeSqlQuery.this.ontheFlyResources.add(filter);
                    ((List)CompositeSqlQuery.this.filterViewer.getInput()).add(new Condition((IResource)filter));
                    CompositeSqlQuery.this.filterViewer.refresh();
                }
            }
        });
        newComplex.setEnabled(false);
        final ToolItem newSql = new ToolItem(parent, 8);
        newSql.setToolTipText(Messages.CompositeSqlQuery_38);
        newSql.setImage(Activator.getDefault().getImageRegistry().get("sqlFilter"));
        newSql.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection ss = (IStructuredSelection)CompositeSqlQuery.this.fmdtViewer.getSelection();
                IDataStreamElement col = (IDataStreamElement)ss.getFirstElement();
                SqlQueryFilter filter = new SqlQueryFilter();
                filter.setName("newFilter");
                filter.setOrigin(col);
                DialogResource d = new DialogResource(CompositeSqlQuery.this.getShell(), (IResource)filter);
                if (d.open() == 0) {
                    CompositeSqlQuery.this.ontheFlyResources.add(filter);
                    ((List)CompositeSqlQuery.this.filterViewer.getInput()).add(new Condition((IResource)filter));
                    CompositeSqlQuery.this.filterViewer.refresh();
                }
            }
        });
        newSql.setEnabled(false);
        final ToolItem newPrompt = new ToolItem(parent, 8);
        newPrompt.setToolTipText(Messages.CompositeSqlQuery_40);
        newPrompt.setImage(Activator.getDefault().getImageRegistry().get("prompt"));
        newPrompt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection ss = (IStructuredSelection)CompositeSqlQuery.this.fmdtViewer.getSelection();
                IDataStreamElement col = (IDataStreamElement)ss.getFirstElement();
                Prompt filter = new Prompt();
                filter.setName("promptOn" + col.getOuputName());
                filter.setOrigin(col);
                filter.setGotoDataStreamElement(col);
                DialogResource d = new DialogResource(CompositeSqlQuery.this.getShell(), (IResource)filter);
                if (d.open() == 0) {
                    CompositeSqlQuery.this.ontheFlyResources.add(filter);
                    ((List)CompositeSqlQuery.this.filterViewer.getInput()).add(new Condition((IResource)filter));
                    CompositeSqlQuery.this.filterViewer.refresh();
                }
            }
        });
        newPrompt.setEnabled(false);
        final ToolItem editResource = new ToolItem(parent, 8);
        editResource.setImage(Activator.getDefault().getImageRegistry().get("edit"));
        editResource.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection ss = (IStructuredSelection)CompositeSqlQuery.this.filterViewer.getSelection();
                Condition c = (Condition)ss.getFirstElement();
                DialogResource d = new DialogResource(CompositeSqlQuery.this.getShell(), c.r);
                if (d.open() == 0) {
                    CompositeSqlQuery.this.filterViewer.refresh();
                }
            }
        });
        editResource.setEnabled(false);
        final ToolItem del2 = new ToolItem(parent, 8);
        del2.setImage(Activator.getDefault().getImageRegistry().get("delCol"));
        del2.setToolTipText(Messages.CompositeSqlQuery_42);
        del2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection ss = (IStructuredSelection)CompositeSqlQuery.this.filterViewer.getSelection();
                for (Object o : ss.toList()) {
                    if (!(o instanceof Condition)) continue;
                    ((List)CompositeSqlQuery.this.filterViewer.getInput()).remove(o);
                }
                CompositeSqlQuery.this.filterViewer.refresh();
            }
        });
        del2.setEnabled(false);
        ToolItem relationStrats = new ToolItem(parent, 8);
        relationStrats.setImage(Activator.getDefault().getImageRegistry().get("relstrat"));
        relationStrats.setToolTipText(Messages.CompositeSqlQuery_43);
        relationStrats.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DialogRelationStrategySelection dial = new DialogRelationStrategySelection(CompositeSqlQuery.this.getShell(), CompositeSqlQuery.this.selectedStrategies, CompositeSqlQuery.this.fmdtPakage);
                if (dial.open() == 0) {
                    CompositeSqlQuery.this.selectedStrategies = dial.getSelectedStrategies();
                }
            }
        });
        ToolItem sql = new ToolItem(parent, 8);
        sql.setImage(Activator.getDefault().getImageRegistry().get("sql"));
        sql.setToolTipText(Messages.CompositeSqlQuery_44);
        sql.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QuerySql query = CompositeSqlQuery.this.createFmdtQuery();
                if (!CompositeSqlQuery.this.fmdtPakage.getBusinessModel().getModel().isBuilt()) {
                    MetaDataBuilder builder = new MetaDataBuilder(null);
                    try {
                        builder.build(CompositeSqlQuery.this.fmdtPakage.getBusinessModel().getModel(), null, CompositeSqlQuery.this.getGroupName());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        MessageDialog.openError((Shell)CompositeSqlQuery.this.getShell(), (String)Messages.CompositeSqlQuery_45, (String)(String.valueOf(Messages.CompositeSqlQuery_46) + "\n" + ex.getMessage()));
                        return;
                    }
                }
                try {
                    String resQuery;
                    ArrayList prompts = new ArrayList(query.getPrompts().size());
                    int i = 0;
                    while (i < query.getPrompts().size()) {
                        prompts.add(new ArrayList());
                        ++i;
                    }
                    IVanillaContext ctx = CompositeSqlQuery.this.contextManager != null ? CompositeSqlQuery.this.contextManager.getVanillaContext() : (CompositeSqlQuery.this.context != null ? CompositeSqlQuery.this.context.getVanillaContext() : null);
                    EffectiveQuery sqlQuery = CompositeSqlQuery.this.fmdtPakage.evaluateQuery(ctx, (IQuery)query, prompts, false);
                    try {
                        resQuery = new BasicFormatterImpl().format(sqlQuery.getGeneratedQuery());
                    }
                    catch (Exception exception) {
                        resQuery = sqlQuery.getGeneratedQuery();
                    }
                    DialogSql d = new DialogSql(CompositeSqlQuery.this.getShell(), resQuery.replace("`", "\""));
                    d.open();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    MessageDialog.openError((Shell)CompositeSqlQuery.this.getShell(), (String)Messages.CompositeSqlQuery_2, (String)(String.valueOf(Messages.CompositeSqlQuery_50) + "\n" + ex.getMessage()));
                }
            }
        });
        ToolItem rowCount = new ToolItem(parent, 8);
        rowCount.setImage(Activator.getDefault().getImageRegistry().get("count"));
        rowCount.setToolTipText(Messages.CompositeSqlQuery_51);
        rowCount.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QuerySql query = CompositeSqlQuery.this.createFmdtQuery();
                if (!CompositeSqlQuery.this.fmdtPakage.getBusinessModel().getModel().isBuilt()) {
                    MetaDataBuilder builder = new MetaDataBuilder(null);
                    try {
                        builder.build(CompositeSqlQuery.this.fmdtPakage.getBusinessModel().getModel(), null, CompositeSqlQuery.this.getGroupName());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        MessageDialog.openError((Shell)CompositeSqlQuery.this.getShell(), (String)Messages.CompositeSqlQuery_52, (String)(String.valueOf(Messages.CompositeSqlQuery_53) + "\n" + ex.getMessage()));
                        return;
                    }
                }
                try {
                    ArrayList prompts = new ArrayList(query.getPrompts().size());
                    int promptCount = query.getPrompts().size();
                    List toRm = query.getPrompts();
                    for (Prompt p : query.getPrompts()) {
                        toRm.add(p);
                    }
                    for (Prompt p : toRm) {
                        query.removePrompt(p);
                    }
                    EffectiveQuery sqlQuery = CompositeSqlQuery.this.fmdtPakage.evaluateQuery(null, (IQuery)query, prompts);
                    String queryTocount = sqlQuery.getGeneratedQuery().replace("`", "\"");
                    String newQuery = "select count(*) from (" + queryTocount + ") countTable";
                    List res = CompositeSqlQuery.this.fmdtPakage.executeQuery(0, "Default", newQuery);
                    String count = (String)((List)res.get(0)).get(0);
                    String additionalMessage = "";
                    if (promptCount > 0) {
                        additionalMessage = String.valueOf(additionalMessage) + "\n" + Messages.CompositeSqlQuery_60;
                    }
                    MessageDialog.openInformation((Shell)CompositeSqlQuery.this.getShell(), (String)Messages.CompositeSqlQuery_61, (String)(String.valueOf(Messages.CompositeSqlQuery_62) + count + Messages.CompositeSqlQuery_63 + additionalMessage));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    MessageDialog.openError((Shell)CompositeSqlQuery.this.getShell(), (String)Messages.CompositeSqlQuery_64, (String)(String.valueOf(Messages.CompositeSqlQuery_65) + "\n" + ex.getMessage()));
                }
            }
        });
        final ToolItem up = new ToolItem(parent, 8);
        up.setImage(Activator.getDefault().getImageRegistry().get("up"));
        up.setToolTipText(Messages.CompositeSqlQuery_66);
        up.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection ss = (IStructuredSelection)CompositeSqlQuery.this.columnViewer.getSelection();
                int i = ((List)CompositeSqlQuery.this.columnViewer.getInput()).indexOf(ss.getFirstElement());
                if (i > 0) {
                    Object old = ((List)CompositeSqlQuery.this.columnViewer.getInput()).get(i - 1);
                    ((List)CompositeSqlQuery.this.columnViewer.getInput()).set(i - 1, ss.getFirstElement());
                    ((List)CompositeSqlQuery.this.columnViewer.getInput()).set(i, old);
                    CompositeSqlQuery.this.columnViewer.refresh();
                }
            }
        });
        up.setEnabled(false);
        final ToolItem down = new ToolItem(parent, 8);
        down.setImage(Activator.getDefault().getImageRegistry().get("down"));
        down.setToolTipText(Messages.CompositeSqlQuery_67);
        down.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection ss = (IStructuredSelection)CompositeSqlQuery.this.columnViewer.getSelection();
                int i = ((List)CompositeSqlQuery.this.columnViewer.getInput()).indexOf(ss.getFirstElement());
                if (i < ((List)CompositeSqlQuery.this.columnViewer.getInput()).size() + 1) {
                    Object old = ((List)CompositeSqlQuery.this.columnViewer.getInput()).get(i + 1);
                    ((List)CompositeSqlQuery.this.columnViewer.getInput()).set(i + 1, ss.getFirstElement());
                    ((List)CompositeSqlQuery.this.columnViewer.getInput()).set(i, old);
                    CompositeSqlQuery.this.columnViewer.refresh();
                }
            }
        });
        down.setEnabled(false);
        ToolItem save = new ToolItem(parent, 8);
        save.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_ETOOL_SAVE_EDIT"));
        save.setToolTipText(Messages.CompositeSqlQuery_68);
        if (this.fromFmdt) {
            save.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DialogSavedQuery dial = new DialogSavedQuery(CompositeSqlQuery.this.getShell());
                    if (dial.open() == 0) {
                        String savedName = dial.getSavedName();
                        String savedDescription = dial.getSavedDescription();
                        if (savedName != null && !savedName.isEmpty()) {
                            QuerySql query = CompositeSqlQuery.this.createFmdtQuery();
                            CompositeSqlQuery.this.fmdtPakage.addSavedQuery(new SavedQuery(savedName, savedDescription, query));
                        } else {
                            MessageDialog.openInformation((Shell)CompositeSqlQuery.this.getShell(), (String)"Empty Name", (String)"You need to fill the name field to save the query.");
                        }
                    }
                }
            });
        } else {
            save.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DialogSavedQuery dial = new DialogSavedQuery(CompositeSqlQuery.this.getShell());
                    if (dial.open() == 0) {
                        String savedName = dial.getSavedName();
                        String savedDescription = dial.getSavedDescription();
                        if (savedName != null && !savedName.isEmpty()) {
                            QuerySql query = CompositeSqlQuery.this.createFmdtQuery();
                            CompositeSqlQuery.this.fmdtPakage.addSavedQuery(new SavedQuery(savedName, savedDescription, query));
                            if (CompositeSqlQuery.this.context != null) {
                                try {
                                    String xml = CompositeSqlQuery.this.fmdtPakage.getBusinessModel().getModel().getXml(false);
                                    RemoteRepositoryApi api = new RemoteRepositoryApi(CompositeSqlQuery.this.context);
                                    RepositoryItem item = api.getRepositoryService().getDirectoryItem(CompositeSqlQuery.this.itemId);
                                    api.getRepositoryService().updateModel(item, xml);
                                }
                                catch (Exception e1) {
                                    e1.printStackTrace();
                                    MessageDialog.openInformation((Shell)CompositeSqlQuery.this.getShell(), (String)"Save failed", (String)("Error while saving the query. " + e1.getMessage()));
                                }
                            } else {
                                MessageDialog.openInformation((Shell)CompositeSqlQuery.this.getShell(), (String)"Context null", (String)"You need to be connected to Vanilla to save the query.");
                            }
                        } else {
                            MessageDialog.openInformation((Shell)CompositeSqlQuery.this.getShell(), (String)Messages.CompositeSqlQuery_69, (String)Messages.CompositeSqlQuery_70);
                        }
                    }
                }
            });
        }
        ToolItem loadQuery = new ToolItem(parent, 8);
        loadQuery.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER"));
        loadQuery.setToolTipText(Messages.CompositeSqlQuery_71);
        loadQuery.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List queries = CompositeSqlQuery.this.fmdtPakage.getSavedQueries();
                if (queries != null && !queries.isEmpty()) {
                    DialogLoadSavedQuery dial = new DialogLoadSavedQuery(CompositeSqlQuery.this.getShell(), queries);
                    if (dial.open() == 0) {
                        SavedQuery savedQuery = dial.getSelectedQuery();
                        if (savedQuery != null) {
                            try {
                                CompositeSqlQuery.this.fill(savedQuery.loadQuery(CompositeSqlQuery.this.vanillaGroupName, CompositeSqlQuery.this.fmdtPakage));
                            }
                            catch (Exception e1) {
                                e1.printStackTrace();
                                MessageDialog.openError((Shell)CompositeSqlQuery.this.getShell(), (String)Messages.CompositeSqlQuery_72, (String)e1.getMessage());
                            }
                        } else {
                            MessageDialog.openInformation((Shell)CompositeSqlQuery.this.getShell(), (String)Messages.CompositeSqlQuery_73, (String)Messages.CompositeSqlQuery_74);
                        }
                    }
                } else {
                    MessageDialog.openInformation((Shell)CompositeSqlQuery.this.getShell(), (String)Messages.CompositeSqlQuery_75, (String)Messages.CompositeSqlQuery_76);
                }
            }
        });
        this.fmdtViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection ss = (IStructuredSelection)event.getSelection();
                boolean disable = ss.isEmpty() || !(ss.getFirstElement() instanceof IDataStreamElement);
                add.setEnabled(!disable || ss.getFirstElement() instanceof IResource);
                if (!add.isEnabled()) {
                    for (Object o : ss.toList()) {
                        if (!(o instanceof IBusinessTable)) continue;
                        add.setEnabled(true);
                        break;
                    }
                }
                newComplex.setEnabled(!disable);
                newPrompt.setEnabled(!disable);
                newSql.setEnabled(!disable);
            }
        });
        this.filterViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection ss = (IStructuredSelection)event.getSelection();
                boolean disable = ss.isEmpty();
                editResource.setEnabled(!disable && CompositeSqlQuery.this.ontheFlyResources.contains(((Condition)ss.getFirstElement()).r));
                del2.setEnabled(!ss.isEmpty());
            }
        });
        this.columnViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection ss = (IStructuredSelection)event.getSelection();
                del.setEnabled(!ss.isEmpty());
                down.setEnabled(!ss.isEmpty());
                up.setEnabled(!ss.isEmpty());
                if (!ss.isEmpty()) {
                    QueryItem i = (QueryItem)ss.getFirstElement();
                    editcalc.setEnabled(i.col instanceof Formula);
                }
            }
        });
    }

    public QuerySql createFmdtQuery() {
        ArrayList<IDataStreamElement> cols = new ArrayList<IDataStreamElement>();
        ArrayList<AggregateFormula> aggs = new ArrayList<AggregateFormula>();
        ArrayList<Formula> formulas = new ArrayList<Formula>();
        ArrayList<IFilter> filters = new ArrayList<IFilter>();
        ArrayList<Prompt> prompts = new ArrayList<Prompt>();
        for (QueryItem i : (List)this.columnViewer.getInput()) {
            if (i.agg == null) {
                if (i.col instanceof Formula) {
                    formulas.add((Formula)i.col);
                    continue;
                }
                if (!(i.col instanceof IDataStreamElement)) continue;
                cols.add((IDataStreamElement)i.col);
                continue;
            }
            if (i.col instanceof IDataStreamElement) {
                aggs.add(new AggregateFormula(i.agg, (IDataStreamElement)i.col, i.label));
                continue;
            }
            aggs.add(new AggregateFormula(i.agg, (Formula)i.col, i.label));
        }
        ArrayList<IResource> usedAddedResources = new ArrayList<IResource>();
        for (Condition i : (List)this.filterViewer.getInput()) {
            if (!this.ontheFlyResources.contains(i.r)) {
                if (i.r instanceof Prompt) {
                    prompts.add((Prompt)i.r);
                    continue;
                }
                if (!(i.r instanceof IFilter)) continue;
                filters.add((IFilter)i.r);
                continue;
            }
            usedAddedResources.add(i.r);
        }
        ArrayList<Ordonable> orders = new ArrayList<Ordonable>();
        for (Object o : (List)this.columnViewer.getInput()) {
            orders.add(((QueryItem)o).col);
        }
        QuerySql query = (QuerySql)SqlQueryBuilder.getQuery((String)this.getGroupName(), cols, new HashMap(), aggs, orders, filters, prompts, formulas, this.selectedStrategies);
        for (IResource r : usedAddedResources) {
            query.addDesignTimeResource(r);
        }
        if (this.distinct.getSelection()) {
            query.setDistinct(true);
        }
        if (this.bLimit.getSelection()) {
            query.setLimit(Integer.parseInt(this.limit.getText()));
            this.limit.setEnabled(true);
        }
        return query;
    }

    private String getGroupName() {
        return this.vanillaGroupName;
    }

    public void setConnection(IBusinessPackage fmdtPack, String groupName) throws Exception {
        this.vanillaGroupName = groupName;
        this.fmdtPakage = fmdtPack;
        this.fmdtViewer.setInput((Object)this.fmdtPakage);
    }

    public void fill(final QuerySql query) {
        ArrayList<QueryItem> cols = new ArrayList<QueryItem>();
        this.ontheFlyResources.clear();
        this.ontheFlyResources.addAll(query.getDesignTimeResources());
        this.distinct.setSelection(query.getDistinct());
        this.bLimit.setSelection(query.getLimit() > 0);
        if (query.getLimit() > 0) {
            this.limit.setText(String.valueOf(query.getLimit()));
        }
        for (AggregateFormula agg : query.getAggs()) {
            cols.add(new QueryItem((Ordonable)agg.getCol(), agg.getFunction(), agg.getOutputName()));
        }
        for (IDataStreamElement c : query.getSelect()) {
            cols.add(new QueryItem((Ordonable)c, null, null));
        }
        for (Formula f : query.getFormulas()) {
            cols.add(new QueryItem((Ordonable)f, null, null));
        }
        Collections.sort(cols, new Comparator<QueryItem>(){

            @Override
            public int compare(QueryItem o1, QueryItem o2) {
                Integer i1 = query.getOrderBy().indexOf(o1.col);
                Integer i2 = query.getOrderBy().indexOf(o2.col);
                return i1.compareTo(i2);
            }
        });
        this.columnViewer.setInput(cols);
        ArrayList<Condition> condition = new ArrayList<Condition>();
        for (IFilter f : query.getFilters()) {
            if (this.ontheFlyResources.contains(f)) continue;
            condition.add(new Condition((IResource)f));
        }
        for (IFilter f : query.getPrompts()) {
            if (this.ontheFlyResources.contains(f)) continue;
            condition.add(new Condition((IResource)f));
        }
        for (IResource r : query.getDesignTimeResources()) {
            condition.add(new Condition(r));
        }
        this.filterViewer.setInput(condition);
    }

    public void setConnection(IBusinessPackage fmdtPackage, String groupName, IRepositoryContext context, int itemId) throws Exception {
        this.setConnection(fmdtPackage, groupName);
        this.context = context;
        this.itemId = itemId;
    }

    private static class Condition {
        private IResource r;

        Condition(IResource r) {
            this.r = r;
        }

        public String getOperator() {
            if (this.r instanceof Filter) {
                return "IN";
            }
            if (this.r instanceof ComplexFilter) {
                return ((ComplexFilter)this.r).getOperator();
            }
            if (this.r instanceof SqlQueryFilter) {
                return ((SqlQueryFilter)this.r).getQuery();
            }
            if (this.r instanceof Prompt) {
                return ((Prompt)this.r).getOperator();
            }
            return null;
        }

        public String getValues() {
            StringBuffer buf;
            block6: {
                block5: {
                    buf = new StringBuffer();
                    if (this.r instanceof Prompt) {
                        return "?";
                    }
                    if (!(this.r instanceof ComplexFilter)) break block5;
                    for (String s : ((ComplexFilter)this.r).getValue()) {
                        if (!buf.toString().isEmpty()) {
                            buf.append(", ");
                        }
                        buf.append(s);
                    }
                    break block6;
                }
                if (!(this.r instanceof ComplexFilter)) break block6;
                for (String s : ((ComplexFilter)this.r).getValue()) {
                    if (!buf.toString().isEmpty()) {
                        buf.append(", ");
                    }
                    buf.append(s);
                }
            }
            return buf.toString();
        }

        public boolean supportOperatorEdition() {
            return this.r instanceof ComplexFilter || this.r instanceof Prompt;
        }

        public void setOperator(String operator) {
            if (this.r instanceof Prompt) {
                ((Prompt)this.r).setOperator(operator);
            }
            if (this.r instanceof ComplexFilter) {
                ((ComplexFilter)this.r).setOperator(operator);
            }
        }
    }

    private static class DialogSql
    extends Dialog {
        private Text text;
        private String sql;

        protected DialogSql(Shell parentShell, String query) {
            super(parentShell);
            this.setShellStyle(this.getShellStyle() | 0x10);
            this.sql = query;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, Messages.CompositeSqlQuery_1, true);
        }

        protected Control createDialogArea(Composite parent) {
            this.text = new Text(parent, 2626);
            this.text.setLayoutData((Object)new GridData(1808));
            this.text.setEditable(false);
            return this.text;
        }

        protected void initializeBounds() {
            this.getShell().setText(Messages.CompositeSqlQuery_0);
            this.getShell().setSize(600, 400);
            this.text.setText(this.sql);
        }
    }

    private static class FmdtLabelProvider
    extends LabelProvider {
        private FmdtLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IBusinessTable) {
                return ((IBusinessTable)element).getName();
            }
            if (element instanceof IResource) {
                return ((IResource)element).getOutputName();
            }
            if (element instanceof Ordonable) {
                return ((Ordonable)element).getOutputName();
            }
            return super.getText(element);
        }

        public Image getImage(Object obj) {
            if (obj instanceof IBusinessTable) {
                return Activator.getDefault().getImageRegistry().get("table");
            }
            if (obj instanceof IDataStreamElement) {
                return Activator.getDefault().getImageRegistry().get("column");
            }
            if (obj instanceof Prompt) {
                return Activator.getDefault().getImageRegistry().get("prompt");
            }
            if (obj instanceof IFilter) {
                if (obj instanceof ComplexFilter) {
                    return Activator.getDefault().getImageRegistry().get("complexFilter");
                }
                if (obj instanceof SqlQueryFilter) {
                    return Activator.getDefault().getImageRegistry().get("sqlFilter");
                }
                if (obj instanceof Filter) {
                    return Activator.getDefault().getImageRegistry().get("filter");
                }
                return Activator.getDefault().getImageRegistry().get("filter");
            }
            if (obj instanceof IResource) {
                if (obj instanceof ListOfValue) {
                    return Activator.getDefault().getImageRegistry().get("lov-16");
                }
                return Activator.getDefault().getImageRegistry().get("lov-16");
            }
            return null;
        }
    }

    private static class QueryItem {
        private Ordonable col;
        private String agg;
        private String label;

        public QueryItem(Ordonable col, String agg, String label) {
            this.col = col;
            this.agg = agg;
            this.label = label;
        }
    }
}

