/*
 * Decompiled with CFR 0.152.
 */
package bpm.fm.oda.driver.impl;

import bpm.fm.api.model.Axis;
import bpm.fm.api.model.Level;
import bpm.fm.api.model.Metric;
import bpm.fm.oda.driver.impl.Driver;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class ResultSetMetaData
implements IResultSetMetaData {
    public static String[] columnNames = new String[]{"Metric id", "Metric name", "Value", "Objective", "Minimum", "Maximum"};
    public static final int METRIC_ID = 1;
    public static final int METRIC_NAME = 2;
    public static final int VALUE = 3;
    public static final int VALUE_OBJECTIVE = 4;
    public static final int VALUE_MIN = 5;
    public static final int VALUE_MAX = 6;
    public HashMap<Integer, Level> levelIndexes = new HashMap();
    private int stardDateIndex;
    private int endDateIndex;
    private boolean dateAsParameter;

    public ResultSetMetaData(List<Metric> metrics, List<Axis> axes, Date startDate, Date endDate, boolean dateAsParameter) {
        int index = 7;
        for (Axis axis : axes) {
            for (Level level : axis.getChildren()) {
                this.levelIndexes.put(index, level);
                ++index;
            }
        }
        this.dateAsParameter = dateAsParameter;
        this.stardDateIndex = index + 1;
    }

    public int getColumnCount() throws OdaException {
        int columnNb = 6;
        columnNb += this.levelIndexes.size();
        return ++columnNb;
    }

    public String getColumnName(int index) throws OdaException {
        if (index <= 6) {
            return columnNames[index - 1];
        }
        if (index > 6 && index <= 6 + this.levelIndexes.size()) {
            return this.levelIndexes.get(index).getName();
        }
        if (index == 6 + this.levelIndexes.size() + 1) {
            return "Date";
        }
        throw new OdaException("Out of bounds");
    }

    public String getColumnLabel(int index) throws OdaException {
        return this.getColumnName(index);
    }

    public int getColumnType(int index) throws OdaException {
        switch (index) {
            case 1: {
                return 4;
            }
            case 2: {
                return 12;
            }
            case 3: {
                return 8;
            }
            case 4: {
                return 8;
            }
            case 5: {
                return 8;
            }
            case 6: {
                return 8;
            }
        }
        if (index > 6 && index <= 6 + this.levelIndexes.size()) {
            return 12;
        }
        return 91;
    }

    public String getColumnTypeName(int index) throws OdaException {
        int nativeTypeCode = this.getColumnType(index);
        return Driver.getNativeDataTypeName(nativeTypeCode);
    }

    public int getColumnDisplayLength(int index) throws OdaException {
        return -1;
    }

    public int getPrecision(int index) throws OdaException {
        return -1;
    }

    public int getScale(int index) throws OdaException {
        return -1;
    }

    public int isNullable(int index) throws OdaException {
        return 2;
    }
}

