/*
 * Decompiled with CFR 0.152.
 */
package bpm.fm.oda.driver.impl;

import bpm.fm.api.model.Axis;
import bpm.fm.api.model.Level;
import bpm.fm.api.model.Metric;
import bpm.fm.api.model.utils.LevelMember;
import bpm.fm.api.model.utils.LoaderDataContainer;
import bpm.fm.api.model.utils.LoaderMetricValue;
import bpm.fm.oda.driver.impl.ResultSetMetaData;
import com.ibm.icu.text.SimpleDateFormat;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.datatools.connectivity.oda.IBlob;
import org.eclipse.datatools.connectivity.oda.IClob;
import org.eclipse.datatools.connectivity.oda.IResultSet;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class ResultSet
implements IResultSet {
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private int m_maxRows;
    private int m_currentRowId = -1;
    private List<Metric> metrics;
    private List<Axis> axes;
    private java.util.Date startDate;
    private java.util.Date endDate;
    private List<LoaderDataContainer> data;
    private List<LoaderMetricValue> values;

    public ResultSet(List<LoaderDataContainer> data, List<Metric> metrics, List<Axis> axes, java.util.Date startDate, java.util.Date endDate) {
        this.metrics = metrics;
        this.axes = axes;
        this.startDate = startDate;
        this.endDate = endDate;
        this.data = data;
        this.values = new ArrayList<LoaderMetricValue>();
        for (LoaderDataContainer c : data) {
            this.values.addAll(c.getValues());
        }
    }

    public IResultSetMetaData getMetaData() throws OdaException {
        return new ResultSetMetaData(this.metrics, this.axes, this.startDate, this.endDate, this.startDate == null);
    }

    public void setMaxRows(int max) throws OdaException {
        this.m_maxRows = max;
    }

    protected int getMaxRows() {
        return this.m_maxRows;
    }

    public boolean next() throws OdaException {
        int maxRows = this.getMaxRows();
        if (maxRows <= 0 || maxRows > 0 && this.m_currentRowId < maxRows) {
            ++this.m_currentRowId;
            return this.m_currentRowId < this.values.size();
        }
        return false;
    }

    public void close() throws OdaException {
        this.m_currentRowId = 0;
        this.data = null;
        this.values = null;
    }

    public int getRow() throws OdaException {
        return this.m_currentRowId;
    }

    public String getString(int index) throws OdaException {
        Object o = this.getObject(index);
        if (o == null) {
            return null;
        }
        if (o instanceof Date) {
            return this.sdf.format((java.util.Date)((Date)o));
        }
        if (o instanceof Timestamp) {
            return this.sdf.format((java.util.Date)new Date(((Timestamp)o).getTime()));
        }
        return o.toString();
    }

    public String getString(String columnName) throws OdaException {
        return this.getString(this.findColumn(columnName));
    }

    public int getInt(int index) throws OdaException {
        Object o = this.getObject(index);
        if (o == null) {
            throw new OdaException("Data is null cannot be wrapped into a primitive type");
        }
        return Integer.valueOf(o.toString());
    }

    public int getInt(String columnName) throws OdaException {
        return this.getInt(this.findColumn(columnName));
    }

    public double getDouble(int index) throws OdaException {
        Object o = this.getObject(index);
        if (o == null) {
            throw new OdaException("Data is null cannot be wrapped into a primitive type");
        }
        if (o instanceof Date) {
            return ((Date)o).getTime();
        }
        return Double.valueOf(o.toString());
    }

    public double getDouble(String columnName) throws OdaException {
        return this.getDouble(this.findColumn(columnName));
    }

    public BigDecimal getBigDecimal(int index) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public BigDecimal getBigDecimal(String columnName) throws OdaException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    public Date getDate(int index) throws OdaException {
        return (Date)this.getObject(index);
    }

    public Date getDate(String columnName) throws OdaException {
        return this.getDate(this.findColumn(columnName));
    }

    public Time getTime(int index) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public Time getTime(String columnName) throws OdaException {
        return this.getTime(this.findColumn(columnName));
    }

    public Timestamp getTimestamp(int index) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public Timestamp getTimestamp(String columnName) throws OdaException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    public IBlob getBlob(int index) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public IBlob getBlob(String columnName) throws OdaException {
        return this.getBlob(this.findColumn(columnName));
    }

    public IClob getClob(int index) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public IClob getClob(String columnName) throws OdaException {
        return this.getClob(this.findColumn(columnName));
    }

    public boolean getBoolean(int index) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public boolean getBoolean(String columnName) throws OdaException {
        return this.getBoolean(this.findColumn(columnName));
    }

    public Object getObject(int index) throws OdaException {
        switch (index) {
            case 1: {
                return this.values.get(this.m_currentRowId).getMetric().getId();
            }
            case 2: {
                return this.values.get(this.m_currentRowId).getMetric().getName();
            }
            case 3: {
                return this.values.get(this.m_currentRowId).getValue();
            }
            case 6: {
                return this.values.get(this.m_currentRowId).getMaximum();
            }
            case 5: {
                return this.values.get(this.m_currentRowId).getMinimum();
            }
            case 4: {
                return this.values.get(this.m_currentRowId).getObjective();
            }
        }
        int i = 7;
        for (LevelMember member : this.values.get(this.m_currentRowId).getMembers()) {
            if (i == index) {
                return member.getLabel();
            }
            ++i;
        }
        return this.values.get(this.m_currentRowId).getDate();
    }

    public Object getObject(String columnName) throws OdaException {
        return this.getObject(this.findColumn(columnName));
    }

    public boolean wasNull() throws OdaException {
        return false;
    }

    public int findColumn(String columnName) throws OdaException {
        int i = 0;
        while (i < ResultSetMetaData.columnNames.length) {
            if (columnName.equals(ResultSetMetaData.columnNames[i])) {
                return i + 1;
            }
            ++i;
        }
        int index = 7;
        for (Axis axis : this.axes) {
            for (Level level : axis.getChildren()) {
                if (level.getName().equals(columnName)) {
                    return index;
                }
                ++index;
            }
        }
        if (columnName.equals("Start Date")) {
            return index + 1;
        }
        return index + 2;
    }
}

