/*
 * Decompiled with CFR 0.152.
 */
package bpm.fm.oda.driver.impl;

import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.io.IOUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class QueryParser {
    private int metricId = -1;
    private int applicationId = -1;
    private boolean dateAsParameter = false;
    private boolean applicationAsParameter = false;
    private boolean metricAsParameter = false;
    private boolean generateDateParameter = false;
    private boolean generateAxeParameter = false;
    private boolean generateMetricParameter = false;
    private Date startDate = null;
    private Date endDate = null;
    private String dateFormat = "yyyy-MM-dd";
    private Document query;

    public QueryParser(String query) throws Exception {
        this.query = DocumentHelper.parseText((String)query);
    }

    public QueryParser(InputStream query) throws Exception {
        this.query = DocumentHelper.parseText((String)IOUtils.toString((InputStream)query, (String)"UTF-8"));
    }

    public void parse() throws Exception {
        this.metricId = -1;
        this.applicationId = -1;
        Element root = this.query.getRootElement();
        try {
            this.metricAsParameter = Boolean.parseBoolean(root.element("fmMetricAsParameter").getStringValue());
            if (!this.metricAsParameter) {
                this.metricId = Integer.parseInt(root.element("fmMetricId").getStringValue());
            }
        }
        catch (Exception exception) {
            throw new Exception("Unable to get metricId in query definition");
        }
        try {
            this.applicationAsParameter = Boolean.parseBoolean(root.element("fmApplicationAsParameter").getStringValue());
            if (!this.applicationAsParameter) {
                this.applicationId = Integer.parseInt(root.element("fmApplicationId").getStringValue());
            }
        }
        catch (Exception exception) {
            throw new Exception("Unable to get applicationId in query definition");
        }
        try {
            this.dateAsParameter = Boolean.parseBoolean(root.element("dateAsParameter").getStringValue());
        }
        catch (Exception exception) {}
        try {
            this.dateFormat = root.element("dateFormat").getStringValue();
        }
        catch (Exception exception) {}
        if (!this.dateAsParameter) {
            try {
                String sd = root.element("dateStart").getStringValue();
                this.startDate = new SimpleDateFormat(this.dateFormat).parse(sd);
            }
            catch (Exception exception) {}
            try {
                String ed = root.element("dateEnd").getStringValue();
                this.endDate = new SimpleDateFormat(this.dateFormat).parse(ed);
            }
            catch (Exception exception) {}
        }
        try {
            this.generateAxeParameter = Boolean.parseBoolean(root.element("generateAxeDataset").getStringValue());
        }
        catch (Exception exception) {}
        try {
            this.generateDateParameter = Boolean.parseBoolean(root.element("generateDateDataset").getStringValue());
        }
        catch (Exception exception) {}
        try {
            this.generateMetricParameter = Boolean.parseBoolean(root.element("generateMetricDataset").getStringValue());
        }
        catch (Exception exception) {}
    }

    public int getMetricId() {
        return this.metricId;
    }

    public int getApplicationId() {
        return this.applicationId;
    }

    public boolean isDateParameter() {
        return this.dateAsParameter;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public boolean isApplicationAsParameter() {
        return this.applicationAsParameter;
    }

    public boolean isMetricAsParameter() {
        return this.metricAsParameter;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public boolean isGenerateDateParameter() {
        return this.generateDateParameter;
    }

    public boolean isGenerateAxeParameter() {
        return this.generateAxeParameter;
    }

    public boolean isGenerateMetricParameter() {
        return this.generateMetricParameter;
    }
}

