/*
 * Decompiled with CFR 0.152.
 */
package bpm.fm.oda.driver.impl;

import bpm.fm.api.model.Axis;
import bpm.fm.api.model.Metric;
import bpm.freemetrics.api.manager.client.FmClientAccessor;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class QueryHelper {
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private FmClientAccessor manager;
    private List<Metric> metrics = new ArrayList<Metric>();
    private List<Axis> axes = new ArrayList<Axis>();
    private Date startDate;
    private Date endDate;
    private boolean dateAsParameter;

    public QueryHelper() {
    }

    public QueryHelper(FmClientAccessor manager) {
        this.manager = manager;
    }

    public String createQueryXml(List<Metric> selectedMetric, List<Axis> selectedAxis, String strDate, String enDate, boolean dateAsParameter) {
        Document doc = DocumentHelper.createDocument();
        Element root = doc.addElement("KpiQuery");
        Element metrics = root.addElement("Metrics");
        for (Metric metric : selectedMetric) {
            metrics.addElement("Metric").setText(String.valueOf(metric.getId()));
        }
        Element axes = root.addElement("Axes");
        for (Axis axis : selectedAxis) {
            axes.addElement("Axis").setText(String.valueOf(axis.getId()));
        }
        root.addElement("startDate").setText(strDate);
        root.addElement("endDate").setText(enDate);
        root.addElement("dateAsParameter").setText(String.valueOf(dateAsParameter));
        return doc.asXML();
    }

    public void parseQueryXml(String xml) throws Exception {
        int id;
        Document doc = DocumentHelper.parseText((String)xml);
        for (Element m : doc.getRootElement().element("Metrics").elements("Metric")) {
            id = Integer.parseInt(m.getText());
            Metric metric = this.manager.getRemoteFm().getMetric(id);
            this.metrics.add(metric);
        }
        for (Element m : doc.getRootElement().element("Axes").elements("Axis")) {
            id = Integer.parseInt(m.getText());
            Axis axis = this.manager.getRemoteFm().getAxis(id);
            this.axes.add(axis);
        }
        String date = doc.getRootElement().element("startDate").getText();
        this.startDate = dateFormat.parse(date);
        try {
            date = doc.getRootElement().element("endDate").getText();
            this.endDate = dateFormat.parse(date);
        }
        catch (Exception exception) {}
        String asParam = doc.getRootElement().element("dateAsParameter").getText();
        try {
            this.dateAsParameter = Boolean.parseBoolean(asParam);
        }
        catch (Exception exception) {}
    }

    public List<Metric> getMetrics() {
        return this.metrics;
    }

    public List<Axis> getAxes() {
        return this.axes;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public boolean isDateAsParameter() {
        return this.dateAsParameter;
    }
}

