/*
 * Decompiled with CFR 0.152.
 */
package bpm.fm.oda.driver.impl;

import bpm.fm.api.model.Axis;
import bpm.fm.api.model.Metric;
import bpm.fm.oda.driver.impl.ParameterMetaData;
import bpm.fm.oda.driver.impl.QueryHelper;
import bpm.fm.oda.driver.impl.ResultSet;
import bpm.fm.oda.driver.impl.ResultSetMetaData;
import bpm.freemetrics.api.manager.client.FmClientAccessor;
import com.ibm.icu.text.SimpleDateFormat;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.List;
import org.eclipse.datatools.connectivity.oda.IParameterMetaData;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.IResultSet;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.SortSpec;
import org.eclipse.datatools.connectivity.oda.spec.QuerySpecification;

public class Query
implements IQuery {
    private int m_maxRows;
    private String m_preparedText;
    private List<Metric> metrics;
    private List<Axis> axes;
    private boolean dateAsParameter = false;
    private FmClientAccessor assessor;
    private String dateFormat = "MM/dd/yyyy";
    private java.util.Date startDate = null;
    private java.util.Date endDate = null;
    private ParameterMetaData parameterMetadata;
    private SimpleDateFormat sdf = new SimpleDateFormat(this.dateFormat);

    public Query(FmClientAccessor assessor) {
        this.assessor = assessor;
    }

    public void prepare(String queryText) throws OdaException {
        this.m_preparedText = queryText;
        QueryHelper helper = new QueryHelper(this.assessor);
        try {
            helper.parseQueryXml(queryText);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.metrics = helper.getMetrics();
        this.axes = helper.getAxes();
        this.startDate = helper.getStartDate();
        this.endDate = helper.getEndDate();
        this.dateAsParameter = helper.isDateAsParameter();
    }

    public void setAppContext(Object context) throws OdaException {
    }

    public void close() throws OdaException {
        this.m_preparedText = null;
    }

    public IResultSetMetaData getMetaData() throws OdaException {
        return new ResultSetMetaData(this.metrics, this.axes, this.startDate, this.endDate, this.dateAsParameter);
    }

    public IResultSet executeQuery() throws OdaException {
        List data = null;
        try {
            data = this.assessor.getRemoteFm().getLoaderValuesForAxes(this.metrics, this.axes, this.startDate, this.endDate);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new ResultSet(data, this.metrics, this.axes, this.startDate, this.endDate);
    }

    public void setProperty(String name, String value) throws OdaException {
    }

    public void setMaxRows(int max) throws OdaException {
        this.m_maxRows = max;
    }

    public int getMaxRows() throws OdaException {
        return this.m_maxRows;
    }

    public void clearInParameters() throws OdaException {
        this.startDate = null;
    }

    public void setInt(String parameterName, int value) throws OdaException {
        if (parameterName.equals("StartDate")) {
            this.startDate = new Date(value);
        } else if (parameterName.equals("EndDate")) {
            this.endDate = new Date(value);
        }
    }

    public void setInt(int parameterId, int value) throws OdaException {
        if (this.getFmParameterMetadata().getParameterName(parameterId).equals("StartDate")) {
            this.startDate = new Date(value);
        } else if (this.getFmParameterMetadata().getParameterName(parameterId).equals("EndDate")) {
            this.endDate = new Date(value);
        }
    }

    public void setDouble(String parameterName, double value) throws OdaException {
        if (parameterName.equals("StartDate")) {
            this.startDate = new Date((long)value);
        } else if (parameterName.equals("EndDate")) {
            this.endDate = new Date((long)value);
        }
    }

    public void setDouble(int parameterId, double value) throws OdaException {
        if (this.getFmParameterMetadata().getParameterName(parameterId).equals("StartDate")) {
            this.startDate = new Date((long)value);
        } else if (this.getFmParameterMetadata().getParameterName(parameterId).equals("EndDate")) {
            this.endDate = new Date((long)value);
        }
    }

    public void setBigDecimal(String parameterName, BigDecimal value) throws OdaException {
        if (parameterName.equals("StartDate")) {
            this.startDate = new Date(value.longValue());
        } else if (parameterName.equals("EndDate")) {
            this.endDate = new Date(value.longValue());
        }
    }

    public void setBigDecimal(int parameterId, BigDecimal value) throws OdaException {
        if (this.getFmParameterMetadata().getParameterName(parameterId).equals("StartDate")) {
            this.startDate = new Date(value.longValue());
        } else if (this.getFmParameterMetadata().getParameterName(parameterId).equals("EndDate")) {
            this.endDate = new Date(value.longValue());
        }
    }

    public void setString(String parameterName, String value) throws OdaException {
        if (parameterName.equals("StartDate")) {
            try {
                this.startDate = this.sdf.parse(value);
            }
            catch (ParseException e) {
                this.startDate = null;
                e.printStackTrace();
                throw new OdaException("Error while parsing date : value " + e.getMessage());
            }
        }
        if (parameterName.equals("EndDate")) {
            try {
                this.endDate = this.sdf.parse(value);
            }
            catch (ParseException e) {
                this.endDate = null;
                e.printStackTrace();
                throw new OdaException("Error while parsing date : value " + e.getMessage());
            }
        }
    }

    public void setString(int parameterId, String value) throws OdaException {
        if (this.getFmParameterMetadata().getParameterName(parameterId).equals("StartDate")) {
            try {
                this.startDate = this.sdf.parse(value);
            }
            catch (ParseException e) {
                this.startDate = null;
                e.printStackTrace();
                throw new OdaException("Error while parsing date : value " + e.getMessage());
            }
        }
        if (this.getFmParameterMetadata().getParameterName(parameterId).equals("EndDate")) {
            try {
                this.endDate = this.sdf.parse(value);
            }
            catch (ParseException e) {
                this.endDate = null;
                e.printStackTrace();
                throw new OdaException("Error while parsing date : value " + e.getMessage());
            }
        }
    }

    public void setDate(String parameterName, Date value) throws OdaException {
        if (parameterName.equals("StartDate")) {
            this.startDate = value;
        } else if (parameterName.equals("EndDate")) {
            this.endDate = value;
        } else {
            throw new OdaException("You can't use a date to fill a parameter of type int.");
        }
    }

    public void setDate(int parameterId, Date value) throws OdaException {
        if (this.getFmParameterMetadata().getParameterName(parameterId).equals("StartDate")) {
            this.startDate = value;
        } else if (this.getFmParameterMetadata().getParameterName(parameterId).equals("EndDate")) {
            this.endDate = value;
        } else {
            throw new OdaException("You can't use a date to fill a parameter of type int.");
        }
    }

    public void setTime(String parameterName, Time value) throws OdaException {
        if (parameterName.equals("StartDate")) {
            this.startDate = new Date(value.getTime());
        } else if (parameterName.equals("EndDate")) {
            this.endDate = new Date(value.getTime());
        } else {
            throw new OdaException("You can't use a date to fill a parameter of type int.");
        }
    }

    public void setTime(int parameterId, Time value) throws OdaException {
        if (this.getFmParameterMetadata().getParameterName(parameterId).equals("StartDate")) {
            this.startDate = new Date(value.getTime());
        } else if (this.getFmParameterMetadata().getParameterName(parameterId).equals("EndDate")) {
            this.endDate = new Date(value.getTime());
        } else {
            throw new OdaException("You can't use a date to fill a parameter of type int.");
        }
    }

    public void setTimestamp(String parameterName, Timestamp value) throws OdaException {
        if (parameterName.equals("StartDate")) {
            this.startDate = new Date(value.getTime());
        } else if (parameterName.equals("EndDate")) {
            this.endDate = new Date(value.getTime());
        } else {
            throw new OdaException("You can't use a date to fill a parameter of type int.");
        }
    }

    public void setTimestamp(int parameterId, Timestamp value) throws OdaException {
        if (this.getFmParameterMetadata().getParameterName(parameterId).equals("StartDate")) {
            this.startDate = new Date(value.getTime());
        } else if (this.getFmParameterMetadata().getParameterName(parameterId).equals("EndDate")) {
            this.endDate = new Date(value.getTime());
        } else {
            throw new OdaException("You can't use a date to fill a parameter of type int.");
        }
    }

    public void setBoolean(String parameterName, boolean value) throws OdaException {
        throw new OdaException("This Query cannot contain a Boolean parameter");
    }

    public void setBoolean(int parameterId, boolean value) throws OdaException {
        throw new OdaException("This Query cannot contain a Boolean parameter");
    }

    public void setObject(String parameterName, Object value) throws OdaException {
        if (value instanceof Date) {
            this.setDate(parameterName, (Date)value);
        } else if (value instanceof Integer) {
            this.setInt(parameterName, (int)((Integer)value));
        } else if (value instanceof BigDecimal) {
            this.setBigDecimal(parameterName, (BigDecimal)value);
        } else if (value instanceof Long) {
            this.setDouble(parameterName, (double)new Double(((Long)value).longValue()));
        } else if (value instanceof Float) {
            this.setDouble(parameterName, (double)new Double(((Float)value).floatValue()));
        } else if (value instanceof Double) {
            this.setDouble(parameterName, (double)new Double((Double)value));
        } else if (value instanceof String) {
            this.setString(parameterName, (String)value);
        } else if (value instanceof Time) {
            this.setTime(parameterName, (Time)value);
        } else if (value instanceof Timestamp) {
            this.setTimestamp(parameterName, (Timestamp)value);
        }
        throw new OdaException("Unable to use setObject for the type " + value.getClass().getName());
    }

    public void setObject(int parameterId, Object value) throws OdaException {
        this.setObject(this.getParameterMetaData().getParameterName(parameterId), value);
    }

    public void setNull(String parameterName) throws OdaException {
        if (parameterName.equals("StartDate")) {
            this.startDate = null;
        } else if (parameterName.equals("EndDate")) {
            this.endDate = null;
        }
    }

    public void setNull(int parameterId) throws OdaException {
        if (parameterId == 1) {
            this.startDate = null;
        }
    }

    public int findInParameter(String parameterName) throws OdaException {
        return this.getFmParameterMetadata().getParameterPosition(parameterName);
    }

    public IParameterMetaData getParameterMetaData() throws OdaException {
        if (this.parameterMetadata == null) {
            this.parameterMetadata = new ParameterMetaData(this.dateAsParameter, false, false);
        }
        return this.parameterMetadata;
    }

    public ParameterMetaData getFmParameterMetadata() throws OdaException {
        return (ParameterMetaData)this.getParameterMetaData();
    }

    public void setSortSpec(SortSpec sortBy) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public SortSpec getSortSpec() throws OdaException {
        return null;
    }

    public void setSpecification(QuerySpecification querySpec) throws OdaException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public QuerySpecification getSpecification() {
        return null;
    }

    public String getEffectiveQueryText() {
        return this.m_preparedText;
    }

    public void cancel() throws OdaException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }
}

