/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.relation;

import com.facebook.presto.jdbc.internal.common.type.Type;
import com.facebook.presto.jdbc.internal.spi.SourceLocation;
import com.facebook.presto.jdbc.internal.spi.relation.IntermediateFormExpression;
import com.facebook.presto.jdbc.internal.spi.relation.RowExpression;
import com.facebook.presto.jdbc.internal.spi.relation.RowExpressionVisitor;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class UnresolvedSymbolExpression
extends IntermediateFormExpression {
    private final Type type;
    private final List<String> name;

    public UnresolvedSymbolExpression(Optional<SourceLocation> sourceLocation, Type type, List<String> name) {
        super(sourceLocation);
        this.type = Objects.requireNonNull(type, "type is null");
        this.name = Objects.requireNonNull(name, "name is null");
    }

    @Override
    public Type getType() {
        return this.type;
    }

    public List<String> getName() {
        return this.name;
    }

    @Override
    public List<RowExpression> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        UnresolvedSymbolExpression other = (UnresolvedSymbolExpression)obj;
        return Objects.equals(this.type, other.type) && Objects.equals(this.name, other.name);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.type, this.name);
    }

    @Override
    public String toString() {
        return String.format("UnresolvedSymbolExpression{%s, %s}", this.type, this.name);
    }

    @Override
    public <R, C> R accept(RowExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitUnresolvedSymbolExpression(this, context);
    }

    @Override
    public RowExpression canonicalize() {
        return this;
    }
}

