/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.plan;

import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import com.facebook.presto.jdbc.internal.javax.annotation.concurrent.Immutable;
import com.facebook.presto.jdbc.internal.spi.SourceLocation;
import com.facebook.presto.jdbc.internal.spi.plan.LogicalProperties;
import com.facebook.presto.jdbc.internal.spi.plan.LogicalPropertiesProvider;
import com.facebook.presto.jdbc.internal.spi.plan.PlanNode;
import com.facebook.presto.jdbc.internal.spi.plan.PlanNodeId;
import com.facebook.presto.jdbc.internal.spi.plan.PlanVisitor;
import com.facebook.presto.jdbc.internal.spi.relation.VariableReferenceExpression;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@Immutable
public final class DistinctLimitNode
extends PlanNode {
    private final PlanNode source;
    private final long limit;
    private final int timeoutMillis;
    private final boolean partial;
    private final List<VariableReferenceExpression> distinctVariables;
    private final Optional<VariableReferenceExpression> hashVariable;

    @JsonCreator
    public DistinctLimitNode(Optional<SourceLocation> sourceLocation, @JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="limit") long limit, @JsonProperty(value="partial") boolean partial, @JsonProperty(value="distinctVariables") List<VariableReferenceExpression> distinctVariables, @JsonProperty(value="hashVariable") Optional<VariableReferenceExpression> hashVariable, @JsonProperty(value="timeoutMillis") int timeoutMillis) {
        this(sourceLocation, id, Optional.empty(), source, limit, partial, distinctVariables, hashVariable, timeoutMillis);
    }

    public DistinctLimitNode(Optional<SourceLocation> sourceLocation, PlanNodeId id, Optional<PlanNode> statsEquivalentPlanNode, PlanNode source, long limit, boolean partial, List<VariableReferenceExpression> distinctVariables, Optional<VariableReferenceExpression> hashVariable, int timeoutMillis) {
        super(sourceLocation, id, statsEquivalentPlanNode);
        this.source = Objects.requireNonNull(source, "source is null");
        DistinctLimitNode.checkArgument(limit >= 0L, "limit must be greater than or equal to zero");
        this.limit = limit;
        this.partial = partial;
        this.distinctVariables = Collections.unmodifiableList(distinctVariables);
        this.hashVariable = Objects.requireNonNull(hashVariable, "hashVariable is null");
        this.timeoutMillis = timeoutMillis;
        DistinctLimitNode.checkArgument(!hashVariable.isPresent() || !distinctVariables.contains(hashVariable.get()), "distinctVariables should not contain hash variable");
    }

    @Override
    public List<PlanNode> getSources() {
        return Collections.unmodifiableList(Collections.singletonList(this.source));
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty
    public long getLimit() {
        return this.limit;
    }

    @JsonProperty
    public boolean isPartial() {
        return this.partial;
    }

    @JsonProperty
    public Optional<VariableReferenceExpression> getHashVariable() {
        return this.hashVariable;
    }

    @JsonProperty
    public List<VariableReferenceExpression> getDistinctVariables() {
        return this.distinctVariables;
    }

    @Override
    public LogicalProperties computeLogicalProperties(LogicalPropertiesProvider logicalPropertiesProvider) {
        Objects.requireNonNull(logicalPropertiesProvider, "logicalPropertiesProvider cannot be null.");
        return logicalPropertiesProvider.getDistinctLimitProperties(this);
    }

    @Override
    public List<VariableReferenceExpression> getOutputVariables() {
        ArrayList<VariableReferenceExpression> outputVariables = new ArrayList<VariableReferenceExpression>(this.distinctVariables);
        this.hashVariable.ifPresent(outputVariables::add);
        return Collections.unmodifiableList(outputVariables);
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitDistinctLimit(this, context);
    }

    @Override
    public PlanNode assignStatsEquivalentPlanNode(Optional<PlanNode> statsEquivalentPlanNode) {
        return new DistinctLimitNode(this.getSourceLocation(), this.getId(), statsEquivalentPlanNode, this.source, this.limit, this.partial, this.distinctVariables, this.hashVariable, this.timeoutMillis);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        DistinctLimitNode.checkArgument(newChildren.size() == 1, "Unexpected number of elements in list newChildren");
        return new DistinctLimitNode(this.getSourceLocation(), this.getId(), this.getStatsEquivalentPlanNode(), newChildren.get(0), this.limit, this.partial, this.distinctVariables, this.hashVariable, this.timeoutMillis);
    }

    private static void checkArgument(boolean condition, String message) {
        if (!condition) {
            throw new IllegalArgumentException(message);
        }
    }

    @JsonProperty
    public int getTimeoutMillis() {
        return this.timeoutMillis;
    }
}

