/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.plan;

import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import com.facebook.presto.jdbc.internal.spi.relation.RowExpression;
import com.facebook.presto.jdbc.internal.spi.relation.VariableReferenceExpression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collector;

public class Assignments {
    private final Map<VariableReferenceExpression, RowExpression> assignments;
    private final List<VariableReferenceExpression> outputs;

    @JsonCreator
    public Assignments(@JsonProperty(value="assignments") Map<VariableReferenceExpression, RowExpression> assignments) {
        this.assignments = Collections.unmodifiableMap(new LinkedHashMap<VariableReferenceExpression, RowExpression>(Objects.requireNonNull(assignments, "assignments is null")));
        this.outputs = Collections.unmodifiableList(new ArrayList<VariableReferenceExpression>(assignments.keySet()));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Map<VariableReferenceExpression, RowExpression> assignments) {
        return new Builder().putAll(assignments);
    }

    public static Assignments copyOf(Map<VariableReferenceExpression, RowExpression> assignments) {
        return Assignments.builder().putAll(assignments).build();
    }

    public static Assignments of() {
        return Assignments.builder().build();
    }

    public static Assignments of(VariableReferenceExpression variable, RowExpression expression) {
        return Assignments.builder().put(variable, expression).build();
    }

    public static Assignments of(VariableReferenceExpression variable1, RowExpression expression1, VariableReferenceExpression variable2, RowExpression expression2) {
        return Assignments.builder().put(variable1, expression1).put(variable2, expression2).build();
    }

    public List<VariableReferenceExpression> getOutputs() {
        return this.outputs;
    }

    @JsonProperty(value="assignments")
    public Map<VariableReferenceExpression, RowExpression> getMap() {
        return this.assignments;
    }

    public Assignments filter(Collection<VariableReferenceExpression> variables) {
        return this.filter(variables::contains);
    }

    public Assignments filter(Predicate<VariableReferenceExpression> predicate) {
        return this.assignments.entrySet().stream().filter((? super T entry) -> predicate.test((VariableReferenceExpression)entry.getKey())).collect(this.toAssignments());
    }

    private Collector<Map.Entry<VariableReferenceExpression, RowExpression>, Builder, Assignments> toAssignments() {
        return Collector.of(Assignments::builder, (builder, entry) -> builder.put((VariableReferenceExpression)entry.getKey(), (RowExpression)entry.getValue()), (left, right) -> {
            left.putAll(right.build());
            return left;
        }, Builder::build, new Collector.Characteristics[0]);
    }

    public Collection<RowExpression> getExpressions() {
        return this.assignments.values();
    }

    public Set<VariableReferenceExpression> getVariables() {
        return this.assignments.keySet();
    }

    public Set<Map.Entry<VariableReferenceExpression, RowExpression>> entrySet() {
        return this.assignments.entrySet();
    }

    public RowExpression get(VariableReferenceExpression variable) {
        return this.assignments.get(variable);
    }

    public int size() {
        return this.assignments.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public void forEach(BiConsumer<VariableReferenceExpression, RowExpression> consumer) {
        this.assignments.forEach(consumer);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Assignments that = (Assignments)o;
        return this.assignments.equals(that.assignments);
    }

    public int hashCode() {
        return this.assignments.hashCode();
    }

    public static class Builder {
        private final Map<VariableReferenceExpression, RowExpression> assignments = new LinkedHashMap<VariableReferenceExpression, RowExpression>();

        public Builder putAll(Assignments assignments) {
            return this.putAll(assignments.getMap());
        }

        public Builder putAll(Map<VariableReferenceExpression, RowExpression> assignments) {
            for (Map.Entry<VariableReferenceExpression, RowExpression> assignment : assignments.entrySet()) {
                this.put(assignment.getKey(), assignment.getValue());
            }
            return this;
        }

        public Builder put(VariableReferenceExpression variable, RowExpression expression) {
            RowExpression assignment;
            if (this.assignments.containsKey(variable) && !(assignment = this.assignments.get(variable)).equals(expression)) {
                throw new IllegalStateException(String.format("Variable %s already has assignment %s, while adding %s", variable, assignment, expression));
            }
            this.assignments.put(variable, expression);
            return this;
        }

        public Builder put(Map.Entry<VariableReferenceExpression, RowExpression> assignment) {
            this.put(assignment.getKey(), assignment.getValue());
            return this;
        }

        public Assignments build() {
            return new Assignments(this.assignments);
        }
    }
}

