/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.function;

import com.facebook.presto.jdbc.internal.common.type.Type;
import com.facebook.presto.jdbc.internal.common.type.TypeUtils;
import com.facebook.presto.jdbc.internal.common.type.UnknownType;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import com.facebook.presto.jdbc.internal.javax.annotation.Nullable;
import java.util.Objects;

public class TypeVariableConstraint {
    private final String name;
    private final boolean comparableRequired;
    private final boolean orderableRequired;
    private final String variadicBound;
    private final boolean nonDecimalNumericRequired;

    @JsonCreator
    public TypeVariableConstraint(@JsonProperty(value="name") String name, @JsonProperty(value="comparableRequired") boolean comparableRequired, @JsonProperty(value="orderableRequired") boolean orderableRequired, @JsonProperty(value="variadicBound") @Nullable String variadicBound, @JsonProperty(value="nonDecimalNumericRequired") boolean nonDecimalNumericRequired) {
        this.name = name;
        this.comparableRequired = comparableRequired;
        this.orderableRequired = orderableRequired;
        this.variadicBound = variadicBound;
        this.nonDecimalNumericRequired = nonDecimalNumericRequired;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public boolean isComparableRequired() {
        return this.comparableRequired;
    }

    @JsonProperty
    public boolean isOrderableRequired() {
        return this.orderableRequired;
    }

    @JsonProperty
    public String getVariadicBound() {
        return this.variadicBound;
    }

    @JsonProperty
    public boolean isNonDecimalNumericRequired() {
        return this.nonDecimalNumericRequired;
    }

    public boolean canBind(Type type) {
        if (this.comparableRequired && !type.isComparable()) {
            return false;
        }
        if (this.orderableRequired && !type.isOrderable()) {
            return false;
        }
        if (this.variadicBound != null && !UnknownType.UNKNOWN.equals(type) && !this.variadicBound.equals(type.getTypeSignature().getStandardTypeSignature().getBase())) {
            return false;
        }
        return !this.nonDecimalNumericRequired || TypeUtils.isNonDecimalNumericType(type);
    }

    public String toString() {
        String value = this.name;
        if (this.comparableRequired) {
            value = value + ":comparable";
        }
        if (this.orderableRequired) {
            value = value + ":orderable";
        }
        if (this.variadicBound != null) {
            value = value + ":" + this.variadicBound + "<*>";
        }
        if (this.nonDecimalNumericRequired) {
            value = value + ":nonDecimalNumeric";
        }
        return value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeVariableConstraint that = (TypeVariableConstraint)o;
        return this.comparableRequired == that.comparableRequired && this.orderableRequired == that.orderableRequired && this.nonDecimalNumericRequired == that.nonDecimalNumericRequired && Objects.equals(this.name, that.name) && Objects.equals(this.variadicBound, that.variadicBound);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.comparableRequired, this.orderableRequired, this.variadicBound, this.nonDecimalNumericRequired);
    }
}

