/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.constraints;

import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import com.facebook.presto.jdbc.internal.spi.constraints.TableConstraint;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class UniqueConstraint<T>
extends TableConstraint<T> {
    public UniqueConstraint(Set<T> columnNames, boolean enabled, boolean rely) {
        this(Optional.empty(), columnNames, enabled, rely);
    }

    @JsonCreator
    public UniqueConstraint(@JsonProperty(value="name") String name, @JsonProperty(value="columns") Set<T> columnNames, @JsonProperty(value="enforced") boolean enabled, @JsonProperty(value="rely") boolean rely) {
        super(Optional.of(name), columnNames, enabled, rely);
    }

    protected UniqueConstraint(Optional<String> name, Set<T> columnNames, boolean enabled, boolean rely) {
        super(name, columnNames, enabled, rely);
    }

    @Override
    public <T, R> Optional<TableConstraint<R>> rebaseConstraint(Map<T, R> assignments) {
        if (this.getColumns().stream().allMatch(assignments::containsKey)) {
            return Optional.of(new UniqueConstraint(this.getName(), this.getColumns().stream().map(assignments::get).collect(Collectors.toSet()), this.isEnforced(), this.isRely()));
        }
        return Optional.empty();
    }
}

