/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi;

import com.facebook.presto.jdbc.internal.common.ErrorCode;
import com.facebook.presto.jdbc.internal.spi.ErrorCodeSupplier;

public class PrestoException
extends RuntimeException {
    private final ErrorCode errorCode;

    public PrestoException(ErrorCodeSupplier errorCode, String message) {
        this(errorCode, message, null);
    }

    public PrestoException(ErrorCodeSupplier errorCode, Throwable throwable) {
        this(errorCode, null, throwable);
    }

    public PrestoException(ErrorCodeSupplier errorCodeSupplier, String message, Throwable cause) {
        super(message, cause);
        this.errorCode = errorCodeSupplier.toErrorCode();
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    @Override
    public String getMessage() {
        String message = super.getMessage();
        if (message == null && this.getCause() != null) {
            message = this.getCause().getMessage();
        }
        if (message == null) {
            message = this.errorCode.getName();
        }
        return message;
    }
}

