/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi;

import com.facebook.presto.jdbc.internal.spi.plan.PlanNode;
import com.facebook.presto.jdbc.internal.spi.plan.PlanVisitor;
import java.util.List;
import java.util.stream.Collectors;

public abstract class ConnectorPlanRewriter<C>
extends PlanVisitor<PlanNode, RewriteContext<C>> {
    public static <C> PlanNode rewriteWith(ConnectorPlanRewriter<C> rewriter, PlanNode node) {
        return ConnectorPlanRewriter.rewriteWith(rewriter, node, null);
    }

    public static <C> PlanNode rewriteWith(ConnectorPlanRewriter<C> rewriter, PlanNode node, C context) {
        PlanNode result = (PlanNode)node.accept(rewriter, new RewriteContext(rewriter, context));
        if (node.getStatsEquivalentPlanNode().isPresent() && !result.getStatsEquivalentPlanNode().isPresent()) {
            result = result.assignStatsEquivalentPlanNode(node.getStatsEquivalentPlanNode());
        }
        return result;
    }

    @Override
    public PlanNode visitPlan(PlanNode node, RewriteContext<C> context) {
        return context.defaultRewrite(node, context.get());
    }

    public static class RewriteContext<C> {
        private final C userContext;
        private final ConnectorPlanRewriter<C> nodeRewriter;

        private RewriteContext(ConnectorPlanRewriter<C> nodeRewriter, C userContext) {
            this.nodeRewriter = nodeRewriter;
            this.userContext = userContext;
        }

        public C get() {
            return this.userContext;
        }

        public PlanNode defaultRewrite(PlanNode node) {
            return this.defaultRewrite(node, null);
        }

        public PlanNode defaultRewrite(PlanNode node, C context) {
            List<PlanNode> children = node.getSources().stream().map(child -> this.rewrite((PlanNode)child, context)).collect(Collectors.toList());
            for (int i = 0; i < node.getSources().size(); ++i) {
                if (children.get(i) == node.getSources().get(i)) continue;
                return node.replaceChildren(children);
            }
            return node;
        }

        public PlanNode rewrite(PlanNode node, C userContext) {
            PlanNode result = (PlanNode)node.accept(this.nodeRewriter, new RewriteContext<C>(this.nodeRewriter, userContext));
            if (node.getStatsEquivalentPlanNode().isPresent() && !result.getStatsEquivalentPlanNode().isPresent()) {
                result = result.assignStatsEquivalentPlanNode(node.getStatsEquivalentPlanNode());
            }
            return result;
        }

        public PlanNode rewrite(PlanNode node) {
            return this.rewrite(node, null);
        }
    }
}

