/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.common.array;

import com.facebook.presto.jdbc.internal.common.array.BigArrays;
import com.facebook.presto.jdbc.internal.io.airlift.slice.SizeOf;
import com.facebook.presto.jdbc.internal.jol.info.ClassLayout;
import java.util.Arrays;

public final class ObjectBigArray<T> {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(ObjectBigArray.class).instanceSize();
    private static final long SIZE_OF_SEGMENT = SizeOf.sizeOfObjectArray(1024);
    private final Object initialValue;
    private Object[][] array;
    private long capacity;
    private int segments;

    public ObjectBigArray() {
        this(null);
    }

    public ObjectBigArray(Object initialValue) {
        this.initialValue = initialValue;
        this.array = new Object[1024][];
        this.allocateNewSegment();
    }

    public long sizeOf() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((Object[])this.array) + (long)this.segments * SIZE_OF_SEGMENT;
    }

    public long getCapacity() {
        return this.capacity;
    }

    public T get(long index) {
        return (T)this.array[BigArrays.segment(index)][BigArrays.offset(index)];
    }

    public T getAndSet(long index, T replacement) {
        Object[] segment = this.array[BigArrays.segment(index)];
        int offset = BigArrays.offset(index);
        Object result = segment[offset];
        segment[offset] = replacement;
        return (T)result;
    }

    public void set(long index, T value) {
        this.array[BigArrays.segment((long)index)][BigArrays.offset((long)index)] = value;
    }

    public boolean setIfNull(long index, T value) {
        int offset;
        Object[] segment = this.array[BigArrays.segment(index)];
        if (segment[offset = BigArrays.offset(index)] == null) {
            segment[offset] = value;
            return true;
        }
        return false;
    }

    public void ensureCapacity(long length) {
        if (this.capacity > length) {
            return;
        }
        this.grow(length);
    }

    private void grow(long length) {
        int requiredSegments = BigArrays.segment(length) + 1;
        if (this.array.length < requiredSegments) {
            this.array = (Object[][])Arrays.copyOf(this.array, requiredSegments);
        }
        while (this.segments < requiredSegments) {
            this.allocateNewSegment();
        }
    }

    private void allocateNewSegment() {
        Object[] newSegment = new Object[1024];
        if (this.initialValue != null) {
            Arrays.fill(newSegment, this.initialValue);
        }
        this.array[this.segments] = newSegment;
        this.capacity += 1024L;
        ++this.segments;
    }
}

