/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.common.array;

import com.facebook.presto.jdbc.internal.common.array.BigArrays;
import com.facebook.presto.jdbc.internal.io.airlift.slice.SizeOf;
import com.facebook.presto.jdbc.internal.jol.info.ClassLayout;
import java.util.Arrays;

public final class BooleanBigArray {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(BooleanBigArray.class).instanceSize();
    private static final long SIZE_OF_SEGMENT = SizeOf.sizeOfBooleanArray(1024);
    private final boolean initialValue;
    private boolean[][] array;
    private long capacity;
    private int segments;

    public BooleanBigArray() {
        this(false);
    }

    public BooleanBigArray(boolean initialValue) {
        this.initialValue = initialValue;
        this.array = new boolean[1024][];
        this.allocateNewSegment();
    }

    public long sizeOf() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((Object[])this.array) + (long)this.segments * SIZE_OF_SEGMENT;
    }

    public boolean get(long index) {
        return this.array[BigArrays.segment(index)][BigArrays.offset(index)];
    }

    public void set(long index, boolean value) {
        this.array[BigArrays.segment((long)index)][BigArrays.offset((long)index)] = value;
    }

    public void ensureCapacity(long length) {
        if (this.capacity > length) {
            return;
        }
        this.grow(length);
    }

    private void grow(long length) {
        int requiredSegments = BigArrays.segment(length) + 1;
        if (this.array.length < requiredSegments) {
            this.array = (boolean[][])Arrays.copyOf(this.array, requiredSegments);
        }
        while (this.segments < requiredSegments) {
            this.allocateNewSegment();
        }
    }

    private void allocateNewSegment() {
        boolean[] newSegment = new boolean[1024];
        if (this.initialValue) {
            Arrays.fill(newSegment, this.initialValue);
        }
        this.array[this.segments] = newSegment;
        this.capacity += 1024L;
        ++this.segments;
    }
}

