/*
 * Decompiled with CFR 0.152.
 */
package bpm.vanilla.listdata.oda.driver.impl;

import bpm.dataprovider.odainput.OdaInputDigester;
import bpm.dataprovider.odainput.consumer.QueryHelper;
import bpm.vanilla.platform.core.IRepositoryApi;
import bpm.vanilla.platform.core.beans.data.OdaInput;
import bpm.vanilla.platform.core.repository.DatasProvider;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.eclipse.datatools.connectivity.oda.IParameterMetaData;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.IResultSet;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.SortSpec;
import org.eclipse.datatools.connectivity.oda.spec.QuerySpecification;

public class Query
implements IQuery {
    private int m_maxRows;
    private String m_preparedText;
    private IRepositoryApi repSock;
    private DatasProvider dataProvider;
    private IQuery wrappedQuery;
    private OdaInput odaInput;

    public Query(IRepositoryApi repSock) {
        this.repSock = repSock;
    }

    public void prepare(String queryText) throws OdaException {
        try {
            this.dataProvider = this.repSock.getDatasProviderService().getDatasProvider(Integer.parseInt(queryText));
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            throw new OdaException("Wrong query format");
        }
        catch (Exception e) {
            throw new OdaException((Throwable)e);
        }
        this.m_preparedText = queryText;
        OdaInputDigester dig = null;
        try {
            dig = new OdaInputDigester(this.dataProvider.getXmlDataSourceDefinition());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new OdaException("Error when parsing DataProvider definition, " + e.getMessage());
        }
        this.odaInput = dig.getOdaInput();
        try {
            this.wrappedQuery = QueryHelper.buildquery((OdaInput)this.odaInput);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new OdaException("Unable to Wrapp the OdaQuery, " + e.getMessage());
        }
    }

    public void setAppContext(Object context) throws OdaException {
        this.wrappedQuery.setAppContext(context);
    }

    public void close() throws OdaException {
        this.m_preparedText = null;
        this.wrappedQuery.close();
        QueryHelper.removeQuery((IQuery)this.wrappedQuery);
        try {
            QueryHelper.closeConnectionFor((IQuery)this.wrappedQuery);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public IResultSetMetaData getMetaData() throws OdaException {
        return this.wrappedQuery.getMetaData();
    }

    public IResultSet executeQuery() throws OdaException {
        return this.wrappedQuery.executeQuery();
    }

    public void setProperty(String name, String value) throws OdaException {
        this.wrappedQuery.setProperty(name, value);
    }

    public void setMaxRows(int max) throws OdaException {
        this.m_maxRows = max;
    }

    public int getMaxRows() throws OdaException {
        return this.m_maxRows;
    }

    public void clearInParameters() throws OdaException {
        this.wrappedQuery.clearInParameters();
    }

    public void setInt(String parameterName, int value) throws OdaException {
        this.wrappedQuery.setInt(parameterName, value);
    }

    public void setInt(int parameterId, int value) throws OdaException {
        this.wrappedQuery.setInt(parameterId, value);
    }

    public void setDouble(String parameterName, double value) throws OdaException {
        this.wrappedQuery.setDouble(parameterName, value);
    }

    public void setDouble(int parameterId, double value) throws OdaException {
        this.wrappedQuery.setDouble(parameterId, value);
    }

    public void setBigDecimal(String parameterName, BigDecimal value) throws OdaException {
        this.wrappedQuery.setBigDecimal(parameterName, value);
    }

    public void setBigDecimal(int parameterId, BigDecimal value) throws OdaException {
        this.wrappedQuery.setBigDecimal(parameterId, value);
    }

    public void setString(String parameterName, String value) throws OdaException {
        this.wrappedQuery.setString(parameterName, value);
    }

    public void setString(int parameterId, String value) throws OdaException {
        this.wrappedQuery.setString(parameterId, value);
    }

    public void setDate(String parameterName, Date value) throws OdaException {
        this.wrappedQuery.setDate(parameterName, value);
    }

    public void setDate(int parameterId, Date value) throws OdaException {
        this.wrappedQuery.setDate(parameterId, value);
    }

    public void setTime(String parameterName, Time value) throws OdaException {
        this.wrappedQuery.setTime(parameterName, value);
    }

    public void setTime(int parameterId, Time value) throws OdaException {
        this.wrappedQuery.setTime(parameterId, value);
    }

    public void setTimestamp(String parameterName, Timestamp value) throws OdaException {
        this.wrappedQuery.setTimestamp(parameterName, value);
    }

    public void setTimestamp(int parameterId, Timestamp value) throws OdaException {
        this.wrappedQuery.setTimestamp(parameterId, value);
    }

    public void setBoolean(String parameterName, boolean value) throws OdaException {
        this.wrappedQuery.setBoolean(parameterName, value);
    }

    public void setBoolean(int parameterId, boolean value) throws OdaException {
        this.wrappedQuery.setBoolean(parameterId, value);
    }

    public void setObject(String parameterName, Object value) throws OdaException {
        this.wrappedQuery.setObject(parameterName, value);
    }

    public void setObject(int parameterId, Object value) throws OdaException {
        this.wrappedQuery.setObject(parameterId, value);
    }

    public void setNull(String parameterName) throws OdaException {
        this.wrappedQuery.setNull(parameterName);
    }

    public void setNull(int parameterId) throws OdaException {
        this.wrappedQuery.setNull(parameterId);
    }

    public int findInParameter(String parameterName) throws OdaException {
        return this.wrappedQuery.findInParameter(parameterName);
    }

    public IParameterMetaData getParameterMetaData() throws OdaException {
        return this.wrappedQuery.getParameterMetaData();
    }

    public void setSortSpec(SortSpec sortBy) throws OdaException {
        this.wrappedQuery.setSortSpec(sortBy);
    }

    public SortSpec getSortSpec() throws OdaException {
        return this.wrappedQuery.getSortSpec();
    }

    public void setSpecification(QuerySpecification querySpec) throws OdaException, UnsupportedOperationException {
        this.wrappedQuery.setSpecification(querySpec);
    }

    public QuerySpecification getSpecification() {
        return this.wrappedQuery.getSpecification();
    }

    public String getEffectiveQueryText() {
        return this.wrappedQuery.getEffectiveQueryText();
    }

    public void cancel() throws OdaException, UnsupportedOperationException {
        this.wrappedQuery.cancel();
    }
}

