/*
 * Decompiled with CFR 0.152.
 */
package bpm.vanilla.listdata.oda.driver.impl;

import bpm.vanilla.listdata.oda.driver.impl.DataSetMetaData;
import bpm.vanilla.listdata.oda.driver.impl.Query;
import bpm.vanilla.platform.core.IRepositoryApi;
import bpm.vanilla.platform.core.IRepositoryContext;
import bpm.vanilla.platform.core.IVanillaAPI;
import bpm.vanilla.platform.core.IVanillaContext;
import bpm.vanilla.platform.core.beans.Repository;
import bpm.vanilla.platform.core.beans.User;
import bpm.vanilla.platform.core.impl.BaseRepositoryContext;
import bpm.vanilla.platform.core.impl.BaseVanillaContext;
import bpm.vanilla.platform.core.remote.RemoteRepositoryApi;
import bpm.vanilla.platform.core.remote.RemoteVanillaPlatform;
import bpm.vanilla.platform.core.utils.MD5Helper;
import com.ibm.icu.util.ULocale;
import java.util.Properties;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IDataSetMetaData;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class Connection
implements IConnection {
    private boolean m_isOpen = false;
    public static final String PROP_VANILLA_URL = "vanillaUrl";
    public static final String PROP_VANILLA_LOGIN = "vanillaLogin";
    public static final String PROP_VANILLA_PASSWORD = "vanillaPassword";
    public static final String PROP_REPOSITORY_ID = "vanillaRepositoryId";
    public static final String PROP_VANILLA_DATAPROVIDERR_ID = "vanillaDataProviderId";
    public static final String PROP_GROUP_ID = "groupId";
    private User vanillaUser;
    private IVanillaAPI vanillaApi;
    private IRepositoryApi socket;
    private Integer groupId = -1;

    public void open(Properties connProperties) throws OdaException {
        BaseVanillaContext vCtx = new BaseVanillaContext(connProperties.getProperty(PROP_VANILLA_URL), connProperties.getProperty(PROP_VANILLA_LOGIN), connProperties.getProperty(PROP_VANILLA_PASSWORD));
        this.vanillaApi = new RemoteVanillaPlatform((IVanillaContext)vCtx);
        try {
            this.vanillaUser = this.vanillaApi.getVanillaSecurityManager().getUserByLogin(connProperties.getProperty(PROP_VANILLA_LOGIN));
        }
        catch (Exception ex) {
            throw new OdaException("Unable to fnd User, " + ex.getMessage());
        }
        if (this.vanillaUser == null) {
            throw new OdaException("The User " + connProperties.getProperty(PROP_VANILLA_LOGIN) + " does not exist.");
        }
        String pass = connProperties.getProperty(PROP_VANILLA_PASSWORD);
        if (!pass.matches("[0-9a-f]{32}")) {
            pass = MD5Helper.encode((String)pass);
        }
        if (!this.vanillaUser.getPassword().equals(pass)) {
            throw new OdaException("Bad password.");
        }
        try {
            this.groupId = Integer.parseInt(connProperties.getProperty(PROP_GROUP_ID));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Repository repDef = null;
        try {
            for (Repository def : this.vanillaApi.getVanillaRepositoryManager().getUserRepositories(this.vanillaUser.getLogin())) {
                if (def.getId() != Integer.parseInt(connProperties.getProperty(PROP_REPOSITORY_ID))) continue;
                repDef = def;
                break;
            }
        }
        catch (Exception ex) {
            throw new OdaException("Unable to Browse User's repositories, " + ex.getMessage());
        }
        if (repDef == null) {
            try {
                Repository def;
                def = this.vanillaApi.getVanillaRepositoryManager().getRepositoryById(Integer.parseInt(connProperties.getProperty(PROP_REPOSITORY_ID)));
                if (def == null) {
                    throw new OdaException("Vanilla has no Repository regsitered with id=" + connProperties.getProperty(PROP_REPOSITORY_ID));
                }
                throw new OdaException("The repository " + def.getName() + " cannot be accessed by the user " + this.vanillaUser.getLogin());
            }
            catch (Exception ex) {
                throw new OdaException("Unable to find Repository, " + ex.getMessage());
            }
        }
        try {
            this.socket = new RemoteRepositoryApi((IRepositoryContext)new BaseRepositoryContext((IVanillaContext)vCtx, this.vanillaApi.getVanillaSecurityManager().getGroupById(this.groupId.intValue()), repDef));
        }
        catch (Exception ex) {
            throw new OdaException((Throwable)ex);
        }
        this.m_isOpen = true;
    }

    public void setAppContext(Object context) throws OdaException {
    }

    public void close() throws OdaException {
        this.m_isOpen = false;
    }

    public boolean isOpen() throws OdaException {
        return this.m_isOpen;
    }

    public IDataSetMetaData getMetaData(String dataSetType) throws OdaException {
        return new DataSetMetaData(this);
    }

    public IQuery newQuery(String dataSetType) throws OdaException {
        return new Query(this.socket);
    }

    public int getMaxQueries() throws OdaException {
        return 0;
    }

    public void commit() throws OdaException {
    }

    public void rollback() throws OdaException {
    }

    public void setLocale(ULocale locale) throws OdaException {
    }
}

