/*
 * Decompiled with CFR 0.152.
 */
package bpm.google.spreadsheet.oda.driver.ui.impl.datasource;

import bpm.google.spreadsheet.oda.driver.ui.Activator;
import bpm.google.spreadsheet.oda.driver.ui.Messages;
import com.google.gdata.client.spreadsheet.SpreadsheetService;
import com.google.gdata.data.spreadsheet.SpreadsheetEntry;
import com.google.gdata.data.spreadsheet.SpreadsheetFeed;
import com.google.gdata.util.AuthenticationException;
import com.google.gdata.util.ServiceException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSourceWizardPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.nebula.widgets.pgroup.PGroup;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class GoogleSpreadDataSourcePage
extends DataSourceWizardPage {
    private static final String URL_GET_SPREADSHEET = "http://spreadsheets.google.com/feeds/spreadsheets/private/full";
    private Text login;
    private Text password;
    private org.eclipse.swt.widgets.List listSpread;
    private Button btnOkConn;
    private List<SpreadsheetEntry> spreadsheets;
    private SpreadsheetEntry spreadSelected;
    private SpreadsheetService myService;
    private Properties prop;

    public GoogleSpreadDataSourcePage(String pageName) {
        super(pageName);
    }

    public GoogleSpreadDataSourcePage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createPageCustomControl(Composite pParent) {
        Composite parent = pParent;
        parent.setLayout((Layout)new GridLayout(2, false));
        this.setPingButtonVisible(false);
        this.setPageComplete(false);
        this.setMessage(Messages.GoogleSpreadDataSourcePage_1);
        PGroup group = new PGroup(parent, 65536);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(4, 4, true, false, 2, 4));
        group.setText(Messages.GoogleSpreadDataSourcePage_2);
        group.setImage(Activator.getDefault().getImageRegistry().get("email.png"));
        Label lblAdress = new Label((Composite)group, 0);
        lblAdress.setText(Messages.GoogleSpreadDataSourcePage_3);
        lblAdress.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.login = new Text((Composite)group, 2048);
        this.login.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        Label lblPass = new Label((Composite)group, 0);
        lblPass.setText(Messages.GoogleSpreadDataSourcePage_4);
        lblPass.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.password = new Text((Composite)group, 0x400800);
        this.password.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.btnOkConn = new Button((Composite)group, 0);
        this.btnOkConn.setLayoutData((Object)new GridData(2, 4, true, false, 2, 1));
        this.btnOkConn.setText(Messages.GoogleSpreadDataSourcePage_5);
        this.btnOkConn.setImage(Activator.getDefault().getImageRegistry().get("googleDocs.png"));
        group = new PGroup(parent, 65536);
        group.setText(Messages.GoogleSpreadDataSourcePage_6);
        group.setLayoutData((Object)new GridData(4, 4, true, true, 2, 10));
        group.setLayout((Layout)new GridLayout(1, false));
        group.setImage(Activator.getDefault().getImageRegistry().get("column.png"));
        this.listSpread = new org.eclipse.swt.widgets.List((Composite)group, 2564);
        this.listSpread.setLayoutData((Object)new GridData(4, 4, true, true, 2, 5));
        this.btnOkConn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    GoogleSpreadDataSourcePage.this.myService = new SpreadsheetService(Messages.GoogleSpreadDataSourcePage_7);
                    GoogleSpreadDataSourcePage.this.myService.setUserCredentials(GoogleSpreadDataSourcePage.this.login.getText(), GoogleSpreadDataSourcePage.this.password.getText());
                    GoogleSpreadDataSourcePage.this.getAllSpreadSheet(GoogleSpreadDataSourcePage.this.myService);
                    MessageDialog.openInformation((Shell)GoogleSpreadDataSourcePage.this.getShell(), (String)Messages.GoogleSpreadDataSourcePage_8, (String)Messages.GoogleSpreadDataSourcePage_9);
                }
                catch (AuthenticationException authenticationException) {
                    GoogleSpreadDataSourcePage.this.listSpread.removeAll();
                    MessageDialog.openError((Shell)GoogleSpreadDataSourcePage.this.getShell(), (String)Messages.GoogleSpreadDataSourcePage_10, (String)Messages.GoogleSpreadDataSourcePage_11);
                }
            }
        });
        this.listSpread.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int i = 0;
                while (i < GoogleSpreadDataSourcePage.this.spreadsheets.size()) {
                    GoogleSpreadDataSourcePage.this.setPageComplete(true);
                    if (GoogleSpreadDataSourcePage.this.listSpread.getItem(GoogleSpreadDataSourcePage.this.listSpread.getSelectionIndex()).equals(((SpreadsheetEntry)GoogleSpreadDataSourcePage.this.spreadsheets.get(i)).getTitle().getPlainText())) {
                        GoogleSpreadDataSourcePage.this.spreadSelected = (SpreadsheetEntry)GoogleSpreadDataSourcePage.this.spreadsheets.get(i);
                    }
                    ++i;
                }
            }
        });
        if (this.prop != null) {
            this.login.setText(this.prop.getProperty("P_USER"));
            this.password.setText(this.prop.getProperty("P_PASS"));
            this.myService = new SpreadsheetService(Messages.GoogleSpreadDataSourcePage_12);
            try {
                this.myService.setUserCredentials(this.login.getText(), this.password.getText());
            }
            catch (AuthenticationException e2) {
                e2.printStackTrace();
                this.listSpread.removeAll();
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.GoogleSpreadDataSourcePage_13, (String)Messages.GoogleSpreadDataSourcePage_14);
            }
            this.getAllSpreadSheet(this.myService);
            this.setSelectedWorkSheet(this.prop);
        }
    }

    protected void setSelectedWorkSheet(Properties prop) {
        String strSpreadSelected = prop.getProperty("P_SPREADSHEET_SELECTED");
        int indexSpreadSelected = -1;
        int i = 0;
        while (i < this.listSpread.getItemCount()) {
            if (this.listSpread.getItem(i).equals(strSpreadSelected)) {
                indexSpreadSelected = i;
            }
            ++i;
        }
        if (indexSpreadSelected == -1) {
            this.setErrorMessage(String.valueOf(Messages.GoogleSpreadDataSourcePage_15) + strSpreadSelected + Messages.GoogleSpreadDataSourcePage_16);
        } else {
            this.listSpread.setSelection(indexSpreadSelected);
            this.spreadSelected = this.spreadsheets.get(indexSpreadSelected);
        }
    }

    protected void getAllSpreadSheet(SpreadsheetService myService) {
        try {
            this.listSpread.removeAll();
            URL metafeedUrl = new URL(URL_GET_SPREADSHEET);
            SpreadsheetFeed feed = (SpreadsheetFeed)myService.getFeed(metafeedUrl, SpreadsheetFeed.class);
            this.spreadsheets = feed.getEntries();
            SpreadsheetEntry entry = null;
            int i = 0;
            while (i < this.spreadsheets.size()) {
                entry = this.spreadsheets.get(i);
                this.listSpread.add(entry.getTitle().getPlainText());
                ++i;
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
    }

    public Properties collectCustomProperties() {
        this.prop = new Properties();
        this.prop.setProperty("P_USER", this.login.getText());
        this.prop.setProperty("P_PASS", this.password.getText());
        this.prop.setProperty("P_SPREADSHEET_SELECTED", this.spreadSelected.getTitle().getPlainText());
        return this.prop;
    }

    public void setInitialProperties(Properties propDS) {
        this.prop = propDS;
    }
}

