/*
 * Decompiled with CFR 0.152.
 */
package bpm.google.spreadsheet.oda.driver.ui.impl.datasource;

import bpm.google.spreadsheet.oda.driver.ui.Activator;
import bpm.google.spreadsheet.oda.driver.ui.Messages;
import com.google.gdata.client.spreadsheet.SpreadsheetService;
import com.google.gdata.data.spreadsheet.SpreadsheetEntry;
import com.google.gdata.data.spreadsheet.SpreadsheetFeed;
import com.google.gdata.util.AuthenticationException;
import com.google.gdata.util.ServiceException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import org.eclipse.datatools.connectivity.oda.design.ui.pages.impl.DefaultDataSourcePropertyPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.nebula.widgets.pgroup.PGroup;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPropertyPage;

public class EditGoogleDataSource
extends DefaultDataSourcePropertyPage
implements IWorkbenchPropertyPage {
    private static final String URL_GET_SPREADSHEET = "http://spreadsheets.google.com/feeds/spreadsheets/private/full";
    private Text login;
    private Text password;
    private org.eclipse.swt.widgets.List listSpread;
    private List<SpreadsheetEntry> spreadsheets;
    private String spreadSelected;
    private SpreadsheetService myService;

    protected void createAndInitCustomControl(Composite pParent, Properties profileProps) {
        this.setPingButtonVisible(false);
        Composite parent = pParent;
        parent.setLayout((Layout)new GridLayout(2, false));
        this.setPingButtonVisible(false);
        this.setMessage(Messages.EditGoogleDataSource_1);
        PGroup group = new PGroup(parent, 65536);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(4, 4, true, false, 2, 4));
        group.setText(Messages.EditGoogleDataSource_2);
        group.setImage(Activator.getDefault().getImageRegistry().get("email.png"));
        Label lblAdress = new Label((Composite)group, 0);
        lblAdress.setText(Messages.EditGoogleDataSource_3);
        lblAdress.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.login = new Text((Composite)group, 2048);
        this.login.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.login.setText(profileProps.getProperty("P_USER"));
        Label lblPass = new Label((Composite)group, 0);
        lblPass.setText(Messages.EditGoogleDataSource_4);
        lblPass.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.password = new Text((Composite)group, 0x400800);
        this.password.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.password.setText(profileProps.getProperty("P_PASS"));
        Button btnOkConn = new Button((Composite)group, 0);
        btnOkConn.setLayoutData((Object)new GridData(2, 4, false, false, 2, 1));
        btnOkConn.setText(Messages.EditGoogleDataSource_5);
        btnOkConn.setImage(Activator.getDefault().getImageRegistry().get("googleDocs.png"));
        group = new PGroup(parent, 65536);
        group.setText(Messages.EditGoogleDataSource_6);
        group.setLayoutData((Object)new GridData(4, 4, true, true, 2, 10));
        group.setLayout((Layout)new GridLayout(1, false));
        group.setImage(Activator.getDefault().getImageRegistry().get("column.png"));
        this.listSpread = new org.eclipse.swt.widgets.List((Composite)group, 2564);
        this.listSpread.setLayoutData((Object)new GridData(4, 4, true, true, 2, 5));
        this.myService = new SpreadsheetService(Messages.EditGoogleDataSource_7);
        try {
            this.myService.setUserCredentials(this.login.getText(), this.password.getText());
        }
        catch (AuthenticationException e2) {
            e2.printStackTrace();
            this.listSpread.removeAll();
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.EditGoogleDataSource_8, (String)Messages.EditGoogleDataSource_9);
        }
        this.getAllSpreadSheet(this.myService);
        this.setSelectedWorkSheet(profileProps);
        btnOkConn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    EditGoogleDataSource.this.myService = new SpreadsheetService(Messages.EditGoogleDataSource_10);
                    EditGoogleDataSource.this.myService.setUserCredentials(EditGoogleDataSource.this.login.getText(), EditGoogleDataSource.this.password.getText());
                    EditGoogleDataSource.this.getAllSpreadSheet(EditGoogleDataSource.this.myService);
                    MessageDialog.openInformation((Shell)EditGoogleDataSource.this.getShell(), (String)Messages.EditGoogleDataSource_11, (String)Messages.EditGoogleDataSource_12);
                }
                catch (AuthenticationException authenticationException) {
                    EditGoogleDataSource.this.listSpread.removeAll();
                    MessageDialog.openError((Shell)EditGoogleDataSource.this.getShell(), (String)Messages.EditGoogleDataSource_13, (String)Messages.EditGoogleDataSource_14);
                }
            }
        });
        this.listSpread.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int i = 0;
                while (i < EditGoogleDataSource.this.spreadsheets.size()) {
                    if (EditGoogleDataSource.this.listSpread.getItem(EditGoogleDataSource.this.listSpread.getSelectionIndex()).equals(((SpreadsheetEntry)EditGoogleDataSource.this.spreadsheets.get(i)).getTitle().getPlainText())) {
                        EditGoogleDataSource.this.spreadSelected = ((SpreadsheetEntry)EditGoogleDataSource.this.spreadsheets.get(i)).getTitle().getPlainText();
                    }
                    ++i;
                }
            }
        });
    }

    protected void setSelectedWorkSheet(Properties prop) {
        String strSpreadSelected = prop.getProperty("P_SPREADSHEET_SELECTED");
        int indexSpreadSelected = -1;
        int i = 0;
        while (i < this.listSpread.getItemCount()) {
            if (this.listSpread.getItem(i).equals(strSpreadSelected)) {
                indexSpreadSelected = i;
            }
            ++i;
        }
        if (indexSpreadSelected == -1) {
            this.setErrorMessage(String.valueOf(Messages.EditGoogleDataSource_15) + strSpreadSelected + Messages.EditGoogleDataSource_16);
        } else {
            this.listSpread.setSelection(indexSpreadSelected);
            this.spreadSelected = this.listSpread.getItem(indexSpreadSelected);
        }
    }

    protected void getAllSpreadSheet(SpreadsheetService service) {
        this.listSpread.removeAll();
        try {
            URL metafeedUrl = new URL(URL_GET_SPREADSHEET);
            SpreadsheetFeed feed = (SpreadsheetFeed)service.getFeed(metafeedUrl, SpreadsheetFeed.class);
            this.spreadsheets = feed.getEntries();
            SpreadsheetEntry entry = null;
            int i = 0;
            while (i < this.spreadsheets.size()) {
                entry = this.spreadsheets.get(i);
                this.listSpread.add(entry.getTitle().getPlainText());
                ++i;
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
    }

    protected Properties collectProperties() {
        Properties prop = new Properties();
        prop.setProperty("P_USER", this.login.getText());
        prop.setProperty("P_PASS", this.password.getText());
        prop.setProperty("P_SPREADSHEET_SELECTED", this.spreadSelected);
        return prop;
    }
}

